/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.theming;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import javafx.application.Application;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Cursor;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.OverrunStyle;
import javafx.scene.effect.BlendMode;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.text.FontWeight;
import javafx.scene.text.TextAlignment;

public class CSSFragment {
    private static final Base64.Encoder enc = Base64.getEncoder();
    private final String css;
    private String converted;
    public static final String DATA_URI_PREFIX = "data:base64,";

    public CSSFragment(String css) {
        this.css = css;
    }

    public static void applyOn(String css, Parent parent) {
        CSSFragment f = new CSSFragment(css);
        f.applyOn(parent);
    }

    public String toDataUri() {
        if (this.converted == null) {
            this.converted = DATA_URI_PREFIX + new String(enc.encode(this.css.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        }
        return this.converted;
    }

    public void applyOn(Parent parent) {
        if (!this.isAppliedOn(parent)) {
            parent.getStylesheets().add((Object)this.toDataUri());
        }
    }

    public void applyOn(Scene scene) {
        if (!this.isAppliedOn(scene)) {
            scene.getStylesheets().add((Object)this.toDataUri());
        }
    }

    public void setGlobal() {
        if (!this.isGlobal()) {
            Application.setUserAgentStylesheet((String)this.toDataUri());
        }
    }

    public boolean isAppliedOn(Parent parent) {
        return parent.getStylesheets().contains((Object)this.toDataUri());
    }

    public boolean isAppliedOn(Scene scene) {
        return scene.getStylesheets().contains((Object)this.toDataUri());
    }

    public boolean isGlobal() {
        return Objects.equals(Application.getUserAgentStylesheet(), this.toDataUri());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CSSFragment that = (CSSFragment)o;
        return this.css.equals(that.css);
    }

    public int hashCode() {
        return Objects.hash(this.css);
    }

    public String toString() {
        return this.css;
    }

    public static class Builder {
        private final StringBuilder sb = new StringBuilder();
        private boolean isSelectorOpen = false;
        private boolean isBracketOpen = false;

        public static Builder build() {
            return new Builder();
        }

        public Builder addSelector(String selector) {
            if (this.isSelectorOpen) {
                this.sb.append(",\n");
            }
            this.isSelectorOpen = true;
            this.sb.append(selector.trim());
            return this;
        }

        public Builder closeSelector() {
            if (!this.isBracketOpen) {
                this.sb.append(" {");
            }
            this.sb.append("\n}\n\n");
            this.isSelectorOpen = false;
            this.isBracketOpen = false;
            return this;
        }

        public Builder addStyle(String style) {
            if (!this.isSelectorOpen) {
                throw new IllegalStateException("No selector was opened!");
            }
            if (!this.isBracketOpen) {
                this.sb.append(" {");
                this.isBracketOpen = true;
            }
            this.sb.append("\n  ").append(style).append(";");
            return this;
        }

        public String toString() {
            return this.sb.toString().trim();
        }

        public CSSFragment toCSS() {
            if (this.sb.length() == 0) {
                throw new IllegalStateException("No styles set");
            }
            if (this.isSelectorOpen) {
                throw new IllegalStateException("Selector was not closed!");
            }
            return new CSSFragment(this.sb.toString().trim());
        }

        public void applyOn(Parent parent) {
            this.toCSS().applyOn(parent);
        }

        public void applyOn(Scene scene) {
            this.toCSS().applyOn(scene);
        }

        public Builder blendMode(BlendMode val) {
            this.addStyle("-prop: " + String.valueOf(val));
            return this;
        }

        public Builder cursor(Cursor val) {
            this.addStyle("-fx-cursor: " + String.valueOf(val));
            return this;
        }

        public Builder focusTraversable(boolean val) {
            this.addStyle("-fx-focus-traversable: " + val);
            return this;
        }

        public Builder viewOrder(int val) {
            this.addStyle("-fx-view-order: " + val);
            return this;
        }

        public Builder opacity(double val) {
            this.addStyle("-fx-opacity: " + val);
            return this;
        }

        public Builder rotate(double val) {
            this.addStyle("-fx-rotate: " + val);
            return this;
        }

        public Builder scaleX(double val) {
            this.addStyle("-fx-scale-x: " + val);
            return this;
        }

        public Builder scaleY(double val) {
            this.addStyle("-fx-scale-y: " + val);
            return this;
        }

        public Builder scaleZ(double val) {
            this.addStyle("-fx-scale-z: " + val);
            return this;
        }

        public Builder translateX(double val) {
            this.addStyle("-fx-translate-x: " + val);
            return this;
        }

        public Builder translateY(double val) {
            this.addStyle("-fx-translate-y: " + val);
            return this;
        }

        public Builder translateZ(double val) {
            this.addStyle("-fx-translate-z: " + val);
            return this;
        }

        public Builder visibility(String val) {
            this.addStyle("visibility: " + val);
            return this;
        }

        public Builder managed(boolean val) {
            this.addStyle("-fx-managed: " + val);
            return this;
        }

        public Builder background(String val) {
            this.addStyle("-fx-background-color: " + val);
            return this;
        }

        public Builder backgroundInsets(String val) {
            this.addStyle("-fx-background-insets: " + val);
            return this;
        }

        public Builder backgroundRadius(String val) {
            this.addStyle("-fx-background-radius: " + val);
            return this;
        }

        public Builder border(String val) {
            this.addStyle("-fx-border-color: " + val);
            return this;
        }

        public Builder borderInsets(String val) {
            this.addStyle("-fx-border-insets: " + val);
            return this;
        }

        public Builder borderRadius(String val) {
            this.addStyle("-fx-border-radius: " + val);
            return this;
        }

        public Builder padding(String val) {
            this.addStyle("-fx-padding: " + val);
            return this;
        }

        public Builder positionShape(boolean val) {
            this.addStyle("-fx-position-shape: " + val);
            return this;
        }

        public Builder scaleShape(boolean val) {
            this.addStyle("-fx-scale-shape: " + val);
            return this;
        }

        public Builder shape(String val) {
            this.addStyle("-fx-shape: " + val);
            return this;
        }

        public Builder snapToPixel(boolean val) {
            this.addStyle("-fx-snap-to-pixel: " + val);
            return this;
        }

        public Builder minHeight(double val) {
            this.addStyle("-fx-min-height: " + val);
            return this;
        }

        public Builder prefHeight(double val) {
            this.addStyle("-fx-pref-height: " + val);
            return this;
        }

        public Builder maxHeight(double val) {
            this.addStyle("-fx-max-height: " + val);
            return this;
        }

        public Builder minWidth(double val) {
            this.addStyle("-fx-min-width: " + val);
            return this;
        }

        public Builder prefWidth(double val) {
            this.addStyle("-fx-pref-width: " + val);
            return this;
        }

        public Builder maxWidth(double val) {
            this.addStyle("-fx-max-width: " + val);
            return this;
        }

        public Builder hGap(double val) {
            this.addStyle("-fx-hgap: " + val);
            return this;
        }

        public Builder vGap(double val) {
            this.addStyle("-fx-vgap: " + val);
            return this;
        }

        public Builder alignment(Pos val) {
            this.addStyle("-fx-alignment: " + String.valueOf(val));
            return this;
        }

        public Builder orientation(Orientation val) {
            this.addStyle("-fx-orientation: " + String.valueOf(val));
            return this;
        }

        public Builder columnHAlignment(HPos val) {
            this.addStyle("-fx-column-halignment: " + String.valueOf(val));
            return this;
        }

        public Builder rowVAlignment(VPos val) {
            this.addStyle("-fx-row-valignment: " + String.valueOf(val));
            return this;
        }

        public Builder gridLineVisible(boolean val) {
            this.addStyle("-fx-grid-lines-visible: " + val);
            return this;
        }

        public Builder spacing(double val) {
            this.addStyle("-fx-spacing: " + val);
            return this;
        }

        public Builder fillHeight(boolean val) {
            this.addStyle("-fx-fill-height: " + val);
            return this;
        }

        public Builder fillWidth(boolean val) {
            this.addStyle("-fx-fill-width: " + val);
            return this;
        }

        public Builder prefRows(int val) {
            this.addStyle("-fx-pref-rows: " + val);
            return this;
        }

        public Builder prefColumns(int val) {
            this.addStyle("-fx-pref-columns: " + val);
            return this;
        }

        public Builder prefTileWidth(double val) {
            this.addStyle("-fx-pref-tile-width: " + val);
            return this;
        }

        public Builder prefTileHeight(double val) {
            this.addStyle("-fx-pref-tile-height: " + val);
            return this;
        }

        public Builder tileAlignment(Pos val) {
            this.addStyle("-fx-tile-alignment: " + String.valueOf(val));
            return this;
        }

        public Builder fill(String val) {
            this.addStyle("-fx-fill: " + val);
            return this;
        }

        public Builder smooth(boolean val) {
            this.addStyle("-fx-smooth: " + val);
            return this;
        }

        public Builder stroke(String val) {
            this.addStyle("-fx-stroke: " + val);
            return this;
        }

        public Builder strokeType(StrokeType val) {
            this.addStyle("-fx-stroke-type: " + String.valueOf(val));
            return this;
        }

        public Builder strokeDashArray(String val) {
            this.addStyle("-fx-stroke-dash-array: " + val);
            return this;
        }

        public Builder strokeDashOffset(double val) {
            this.addStyle("-fx-stroke-dash-offset: " + val);
            return this;
        }

        public Builder strokeLineCap(StrokeLineCap val) {
            this.addStyle("-fx-stroke-line-cap: " + String.valueOf(val));
            return this;
        }

        public Builder strokeLineJoin(StrokeLineJoin val) {
            this.addStyle("-fx-stroke-line-join: " + String.valueOf(val));
            return this;
        }

        public Builder strokeMiterLimit(double val) {
            this.addStyle("-fx-stroke-miter-limit: " + val);
            return this;
        }

        public Builder strokeWidth(double val) {
            this.addStyle("-fx-stroke-width: " + val);
            return this;
        }

        public Builder arcHeight(double val) {
            this.addStyle("-fx-arc-height: " + val);
            return this;
        }

        public Builder arcWidth(String val) {
            this.addStyle("-fx-arc-width: " + val);
            return this;
        }

        public Builder fontFamily(String val) {
            this.addStyle("-fx-font-family: " + val);
            return this;
        }

        public Builder fontSize(String val) {
            this.addStyle("-fx-font-size: " + val);
            return this;
        }

        public Builder fontWeight(FontWeight val) {
            this.addStyle("-fx-font-weight: " + String.valueOf(val));
            return this;
        }

        public Builder fontStyle(FontPosture val) {
            this.addStyle("-prop: " + String.valueOf(val));
            return this;
        }

        public Builder fontSmoothingType(FontSmoothingType val) {
            this.addStyle("-fx-font-smoothing-type: " + String.valueOf(val));
            return this;
        }

        public Builder tabSize(int val) {
            this.addStyle("-fx-tab-size: " + val);
            return this;
        }

        public Builder textAlignment(TextAlignment val) {
            this.addStyle("-fx-text-alignment: " + String.valueOf(val));
            return this;
        }

        public Builder textOrigin(VPos val) {
            this.addStyle("-fx-text-origin: " + String.valueOf(val));
            return this;
        }

        public Builder underline(boolean val) {
            this.addStyle("-fx-underline: " + val);
            return this;
        }

        public Builder wrappingWidth(double val) {
            this.addStyle("-fx-wrapping-width: " + val);
            return this;
        }

        public Builder textOverrun(OverrunStyle val) {
            this.addStyle("-fx-text-overrun: " + String.valueOf(val));
            return this;
        }

        public Builder wrapText(boolean val) {
            this.addStyle("-fx-wrap-text: " + val);
            return this;
        }

        public Builder contentDisplay(ContentDisplay val) {
            this.addStyle("-fx-content-display: " + String.valueOf(val));
            return this;
        }

        public Builder graphicTextGap(double val) {
            this.addStyle("-fx-graphic-text-gap: " + val);
            return this;
        }

        public Builder labelPadding(double val) {
            this.addStyle("-fx-label-padding: " + val);
            return this;
        }

        public Builder textFill(String val) {
            this.addStyle("-fx-text-fill: " + val);
            return this;
        }

        public Builder ellipsisString(String val) {
            this.addStyle("-fx-ellipsis-string: " + val);
            return this;
        }

        public Builder promptTextFill(String val) {
            this.addStyle("-fx-prompt-text-fill: " + val);
            return this;
        }

        public Builder highlightFill(String val) {
            this.addStyle("-fx-highlight-fill: " + val);
            return this;
        }

        public Builder highlightTextFill(String val) {
            this.addStyle("-fx-highlight-text-fill: " + val);
            return this;
        }

        public Builder displayCaret(boolean val) {
            this.addStyle("-fx-display-caret: " + val);
            return this;
        }

        public Builder prefColumnCount(int val) {
            this.addStyle("-fx-pref-column-count: " + val);
            return this;
        }

        public Builder prefRowCount(int val) {
            this.addStyle("-fx-pref-row-count: " + val);
            return this;
        }

        public Builder contextMenuEnabled(boolean val) {
            this.addStyle("-fx-context-menu-enabled: " + val);
            return this;
        }

        public Builder pageFill(String val) {
            this.addStyle("-fx-page-fill: " + val);
            return this;
        }

        public Builder fontScale(double val) {
            this.addStyle("-fx-font-scale: " + val);
            return this;
        }
    }
}

