/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.theming;

import io.github.palexdev.materialfx.theming.base.Theme;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Deployer {
    private static final Deployer instance = new Deployer();
    private final Map<String, Map<String, Path>> cache = new HashMap<String, Map<String, Path>>();
    private final Path tmpDir = Path.of(System.getProperty("java.io.tmpdir"), "themes-assets");

    public static Deployer instance() {
        return instance;
    }

    private Deployer() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deploy(Theme theme) throws Exception {
        if (!Files.isDirectory(this.tmpDir, new LinkOption[0])) {
            Files.createDirectories(this.tmpDir, new FileAttribute[0]);
        }
        Path zipPath = null;
        try {
            try (InputStream in = theme.assets();){
                if (in == null) {
                    return;
                }
                Path destDir = this.tmpDir.resolve(theme.deployName());
                if (!Files.isDirectory(destDir, new LinkOption[0])) {
                    Files.createDirectories(destDir, new FileAttribute[0]);
                }
                zipPath = destDir.resolve("assets.zip");
                OutputStream out = Files.newOutputStream(zipPath, new OpenOption[0]);
                in.transferTo(out);
                try (ZipFile zf = new ZipFile(zipPath.toFile());){
                    List entries = zf.stream().collect(Collectors.toList());
                    for (ZipEntry entry : entries) {
                        this.unzip(theme, zf, entry, destDir);
                    }
                }
            }
            if (zipPath == null) return;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (zipPath != null) {
                Files.delete(zipPath);
            }
        }
        Files.delete(zipPath);
        return;
    }

    public boolean clean(Theme theme) {
        Map<String, Path> assets = this.cache.remove(theme.deployName());
        if (assets == null) {
            return true;
        }
        try {
            for (Path path : assets.values()) {
                this.delete(path);
            }
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public boolean cleanAll() {
        try {
            if (Files.isDirectory(this.tmpDir, new LinkOption[0])) {
                this.delete(this.tmpDir);
            }
            this.cache.clear();
            return true;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public Map<String, Path> getDeployed(Theme theme) {
        return this.cache.get(theme.deployName());
    }

    private void unzip(Theme theme, ZipFile zf, ZipEntry entry, Path destDir) throws IOException {
        String name = entry.getName();
        Path target = destDir.resolve(name);
        if (entry.isDirectory()) {
            Files.createDirectories(target, new FileAttribute[0]);
        } else {
            try (InputStream in = zf.getInputStream(entry);){
                Files.copy(in, target, StandardCopyOption.REPLACE_EXISTING);
                Map themeCache = this.cache.computeIfAbsent(theme.deployName(), t -> new HashMap());
                themeCache.put(name, target);
            }
        }
    }

    private void delete(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

