/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.theming;

import java.util.Collection;
import javafx.beans.InvalidationListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Parent;

public class MFXCSSBridge {
    private Parent parent;
    private final ObservableList<String> stylesheets = FXCollections.observableArrayList();
    private final InvalidationListener stylesheetsChanged = invalidated -> this.initializeStylesheets();

    public MFXCSSBridge(Parent parent) {
        this.parent = parent;
        this.initializeStylesheets();
        this.addListeners();
    }

    public void initializeStylesheets() {
        this.stylesheets.clear();
        if (this.parent == null) {
            return;
        }
        this.stylesheets.addAll((Collection)this.parent.getStylesheets());
    }

    public void addListeners() {
        if (this.parent == null) {
            return;
        }
        this.parent.getStylesheets().addListener(this.stylesheetsChanged);
    }

    public void dispose() {
        if (this.parent != null) {
            this.parent.getStylesheets().removeListener(this.stylesheetsChanged);
        }
    }

    public Parent getParent() {
        return this.parent;
    }

    public void setParent(Parent parent) {
        this.parent = parent;
    }

    public ObservableList<String> getStylesheets() {
        return this.stylesheets;
    }
}

