/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.theming;

import io.github.palexdev.materialfx.theming.CSSFragment;
import io.github.palexdev.materialfx.theming.Deployer;
import io.github.palexdev.materialfx.theming.base.Theme;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class UserAgentBuilder {
    private final Set<Theme> themes = new LinkedHashSet<Theme>();
    private boolean resolveAssets = false;
    private boolean deploy = false;
    private boolean debug = false;

    public static UserAgentBuilder builder() {
        return new UserAgentBuilder();
    }

    public UserAgentBuilder themes(Theme ... themes) {
        Collections.addAll(this.themes, themes);
        return this;
    }

    public UserAgentBuilder themes(Collection<? extends Theme> themes) {
        this.themes.addAll(themes);
        return this;
    }

    public CSSFragment build() {
        StringBuilder sb = new StringBuilder();
        Processor processor = new Processor();
        for (Theme theme : this.themes) {
            if (this.isDeploy()) {
                theme.deploy();
            }
            String data = this.load(theme);
            String preProcessed = processor.preProcess(theme, data, this.resolveAssets);
            sb.append(preProcessed).append("\n\n");
        }
        String postProcess = processor.postProcess(sb);
        if (this.isDebug()) {
            this.saveOnDisk(postProcess);
        }
        return new CSSFragment(postProcess);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected String load(Theme theme) {
        try (InputStream is = theme.get().openStream();){
            String string;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                int length;
                byte[] buffer = new byte[8192];
                while ((length = is.read(buffer)) != -1) {
                    baos.write(buffer, 0, length);
                }
                string = baos.toString(StandardCharsets.UTF_8);
            }
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    protected void saveOnDisk(String ua) {
        try {
            Files.writeString(Files.createTempFile("uab-output", ".css", new FileAttribute[0]), (CharSequence)ua, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public boolean isResolveAssets() {
        return this.resolveAssets;
    }

    public UserAgentBuilder setResolveAssets(boolean resolveAssets) {
        this.resolveAssets = resolveAssets;
        return this;
    }

    public boolean isDeploy() {
        return this.deploy;
    }

    public UserAgentBuilder setDeploy(boolean deploy) {
        this.deploy = deploy;
        return this;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public UserAgentBuilder setDebug(boolean debug) {
        this.debug = debug;
        return this;
    }

    private static class Processor {
        private final Set<String> imports = new LinkedHashSet<String>();

        private Processor() {
        }

        /*
         * WARNING - void declaration
         */
        public String preProcess(Theme theme, String data, boolean resolveAssets) {
            String[] lines = data.split("\n");
            StringBuilder sb = new StringBuilder();
            boolean insideComment = false;
            for (String string : lines) {
                void var10_14;
                if (string.isBlank()) continue;
                Type type = this.typeOf(string);
                if (type == Type.START_COMMENT) {
                    if (string.trim().endsWith("*/")) continue;
                    insideComment = true;
                    continue;
                }
                if (type == Type.END_COMMENT) {
                    insideComment = false;
                    continue;
                }
                if (insideComment) continue;
                if (type == Type.IMPORT && resolveAssets) {
                    Path path = this.resolveImport(theme, string);
                    if (path == null || !Files.exists(path, new LinkOption[0])) {
                        System.err.println("Could not resolve import: " + string);
                        continue;
                    }
                    String string2 = "@import \"file:///" + path.toString().replace("\\", "/") + "\";";
                    this.imports.add(string2);
                    continue;
                }
                if (type == Type.URL && resolveAssets && !this.isNetworkResource(string)) {
                    String[] split = string.split(": ");
                    Path path = this.resolveResource(theme, split[1]);
                    if (path == null || !Files.exists(path, new LinkOption[0])) continue;
                    String string3 = string.replaceAll("^(\\s+).+", "$1") + split[0] + ": url(" + String.valueOf(path) + ");";
                }
                if (sb.toString().endsWith("}\n")) {
                    sb.append("\n");
                }
                sb.append((String)var10_14).append("\n");
            }
            return sb.toString();
        }

        public String postProcess(StringBuilder data) {
            int offset = 0;
            for (String imp : this.imports) {
                data.insert(offset, imp + "\n");
                offset += imp.length() + 1;
            }
            return data.toString();
        }

        private Path resolveImport(Theme theme, String line) {
            String[] split = line.replace("\"", "").replace("'", "").replace(";", "").replace("../", "").split(" ");
            String path = split[1];
            Map<String, Path> deployed = Deployer.instance().getDeployed(theme);
            return deployed.get(path);
        }

        private Path resolveResource(Theme theme, String url) {
            String name = this.getResourceName(url);
            Map<String, Path> deployed = Deployer.instance().getDeployed(theme);
            return deployed.get(name);
        }

        private String getResourceName(String url) {
            return url.replace("url(", "").replace(");", "");
        }

        private boolean isNetworkResource(String line) {
            return line.contains("http://") || line.contains("https://") || line.contains("www.");
        }

        private Type typeOf(String line) {
            String trim = line.trim();
            if (trim.startsWith("/*")) {
                return Type.START_COMMENT;
            }
            if (trim.endsWith("*/")) {
                return Type.END_COMMENT;
            }
            if (trim.startsWith("@import")) {
                return Type.IMPORT;
            }
            if (trim.contains("url(")) {
                return Type.URL;
            }
            return Type.OTHER;
        }

        static enum Type {
            START_COMMENT,
            END_COMMENT,
            IMPORT,
            URL,
            OTHER;

        }
    }
}

