/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.theming.base;

import io.github.palexdev.materialfx.MFXResourcesLoader;
import io.github.palexdev.materialfx.theming.Deployer;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Application;
import javafx.scene.Parent;
import javafx.scene.Scene;

public interface Theme {
    public String name();

    public String path();

    default public URL get() {
        if (Helper.isCached(this) && Helper.getCachedTheme(this) != null) {
            return Helper.getCachedTheme(this);
        }
        return Helper.cacheTheme(this, MFXResourcesLoader.loadURL(this.path()));
    }

    default public String toData() {
        return this.get().toExternalForm();
    }

    default public void applyGlobal() {
        Application.setUserAgentStylesheet((String)this.toData());
    }

    default public void applyOn(Scene scene) {
        scene.getStylesheets().add((Object)this.toData());
    }

    default public void applyOn(Parent parent) {
        parent.getStylesheets().add((Object)this.toData());
    }

    default public InputStream assets() {
        return null;
    }

    default public void deploy() {
        try {
            Deployer.instance().deploy(this);
        }
        catch (Exception ex) {
            System.err.println("Failed to deploy theme: " + this.name() + ", because: " + ex.getMessage());
        }
    }

    default public String deployName() {
        return this.name().toLowerCase();
    }

    default public void clean() {
        Deployer.instance().clean(this);
    }

    default public boolean isDeployed() {
        return Deployer.instance().getDeployed(this) != null;
    }

    public static class Helper {
        private static final Map<Theme, URL> CACHE = new HashMap<Theme, URL>();

        public static boolean isCached(Theme theme) {
            return CACHE.containsKey(theme);
        }

        public static URL cacheTheme(Theme theme, URL url) {
            CACHE.put(theme, url);
            return url;
        }

        public static URL getCachedTheme(Theme theme) {
            return CACHE.get(theme);
        }
    }
}

