/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.utils;

import io.github.palexdev.materialfx.utils.NumberUtils;
import io.github.palexdev.mfxcore.base.TriConsumer;
import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javafx.collections.ListChangeListener;

public class ListChangeHelper {
    public static <T> Change processChange(ListChangeListener.Change<? extends T> change, IntegerRange indexes) {
        HashSet<ChangeBean> added = new HashSet<ChangeBean>();
        HashSet<ChangeBean> removed = new HashSet<ChangeBean>();
        HashSet<ReplaceBean> replaced = new HashSet<ReplaceBean>();
        int removeFrom = -1;
        int removeTo = -1;
        HashSet<Integer> removedAccumulator = new HashSet<Integer>();
        int removedSize = 0;
        while (change.next()) {
            IntegerRange range;
            if (change.wasReplaced()) {
                range = IntegerRange.of((Integer)change.getFrom(), (Integer)(change.getTo() - 1));
                Set<Integer> changed = IntegerRange.expandRangeToSet((IntegerRange)range).stream().filter(i -> IntegerRange.inRangeOf((int)i, (IntegerRange)indexes)).collect(Collectors.toSet());
                removeFrom = change.getTo();
                removeTo = NumberUtils.clamp(change.getRemovedSize() - 1, 0, (Integer)indexes.getMax());
                removedAccumulator.addAll(IntegerRange.expandRangeToSet((IntegerRange)IntegerRange.of((Integer)removeFrom, (Integer)removeTo)));
                removedAccumulator.removeAll(changed);
                replaced.add(new ReplaceBean(range, changed, removedAccumulator));
                continue;
            }
            if (change.wasAdded()) {
                range = IntegerRange.of((Integer)change.getFrom(), (Integer)(change.getTo() - 1));
                added.add(new ChangeBean(range, IntegerRange.expandRangeToSet((IntegerRange)range)));
                continue;
            }
            if (!change.wasRemoved()) continue;
            range = ListChangeHelper.computeRemovedIndexes(change, removedSize);
            if (removeFrom == -1) {
                removeFrom = (Integer)range.getMin();
            }
            removeTo = (Integer)range.getMax();
            removedAccumulator.addAll(IntegerRange.expandRangeToSet((IntegerRange)range));
            removedSize += change.getRemovedSize();
        }
        removed.add(new ChangeBean(IntegerRange.of((Integer)removeFrom, (Integer)removeTo), removedAccumulator));
        return new Change(added, removed, replaced);
    }

    private static <T> IntegerRange computeRemovedIndexes(ListChangeListener.Change<? extends T> change, int toOffset) {
        int size = change.getList().size();
        if (size == 0) {
            return IntegerRange.of((Integer)0, (Integer)(change.getRemovedSize() - 1));
        }
        int from = change.getTo() + toOffset;
        int to = change.getFrom() + (change.getRemovedSize() - 1) + toOffset;
        return IntegerRange.of((Integer)from, (Integer)to);
    }

    public static class ReplaceBean {
        private final IntegerRange range;
        private final Set<Integer> changed;
        private final Set<Integer> removed;

        public ReplaceBean(IntegerRange range, Set<Integer> changed, Set<Integer> removed) {
            this.range = range;
            this.changed = changed;
            this.removed = removed;
        }

        public int gerFrom() {
            return (Integer)this.range.getMin();
        }

        public int getTo() {
            return (Integer)this.range.getMax();
        }

        public boolean isEmpty() {
            return this.changed.isEmpty() && this.removed.isEmpty();
        }
    }

    public static class ChangeBean {
        private final IntegerRange range;
        private final Set<Integer> changed;

        public ChangeBean(IntegerRange range, Set<Integer> added) {
            this.range = range;
            this.changed = added;
        }

        public int gerFrom() {
            return (Integer)this.range.getMin();
        }

        public int getTo() {
            return (Integer)this.range.getMax();
        }
    }

    public static class Change {
        private boolean wasReplacement;
        private final Set<ChangeBean> added;
        private final Set<ChangeBean> removed;
        private final Set<ReplaceBean> replaced;

        private Change(Set<ChangeBean> added, Set<ChangeBean> removed, Set<ReplaceBean> replaced) {
            this.added = added;
            this.removed = removed;
            this.replaced = replaced;
        }

        public void processAddition(TriConsumer<Integer, Integer, Set<Integer>> action) {
            if (this.added.isEmpty()) {
                return;
            }
            for (ChangeBean changeBean : this.added) {
                if (changeBean.changed.isEmpty()) continue;
                action.accept((Object)changeBean.gerFrom(), (Object)changeBean.getTo(), changeBean.changed);
            }
        }

        public void processRemoval(TriConsumer<Integer, Integer, Set<Integer>> action) {
            if (this.removed.isEmpty() || this.wasReplacement) {
                return;
            }
            for (ChangeBean changeBean : this.removed) {
                if (changeBean.changed.isEmpty()) continue;
                action.accept((Object)changeBean.gerFrom(), (Object)changeBean.getTo(), changeBean.changed);
            }
        }

        public void processReplacement(BiConsumer<Set<Integer>, Set<Integer>> action) {
            if (this.replaced.isEmpty()) {
                return;
            }
            for (ReplaceBean replaceBean : this.replaced) {
                if (replaceBean.isEmpty()) continue;
                action.accept(replaceBean.changed, replaceBean.removed);
            }
            this.wasReplacement = true;
        }

        public Set<ChangeBean> getAdded() {
            return this.added;
        }

        public Set<ChangeBean> getRemoved() {
            return this.removed;
        }

        public Set<ReplaceBean> getReplaced() {
            return this.replaced;
        }
    }
}

