/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Set;

public class SceneBuilderIntegration {
    private static Boolean inSceneBuilder = null;
    private static int depth = 10;
    private static boolean isDepthInvalid = false;
    public static final Path DEFAULT_DEBUG_FILE = Path.of(System.getProperty("user.home") + "/SceneBuilderIntegrationDebug.log", new String[0]);

    private SceneBuilderIntegration() {
    }

    public static void ifInSceneBuilder(Runnable action) {
        if (SceneBuilderIntegration.isInSceneBuilder()) {
            action.run();
        }
    }

    public static boolean isInSceneBuilder() {
        if (inSceneBuilder == null || isDepthInvalid) {
            StackWalker sw = StackWalker.getInstance(Set.of(StackWalker.Option.RETAIN_CLASS_REFERENCE, StackWalker.Option.SHOW_REFLECT_FRAMES), depth);
            inSceneBuilder = sw.walk(sfs -> sfs.anyMatch(sf -> sf.getClassName() != null && sf.getClassName().contains(".javafx.scenebuilder.kit.")));
            isDepthInvalid = false;
        }
        return inSceneBuilder;
    }

    public static void setDepth(int depth) {
        SceneBuilderIntegration.depth = depth;
        isDepthInvalid = true;
    }

    public static void debug(Path file, boolean truncate, String debug) {
        try {
            StandardOpenOption wrOpt = truncate ? StandardOpenOption.TRUNCATE_EXISTING : StandardOpenOption.APPEND;
            Files.writeString(file, (CharSequence)(debug + "\n"), StandardOpenOption.CREATE, StandardOpenOption.WRITE, wrOpt);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

