/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.utils.others.observables;

import io.github.palexdev.materialfx.utils.others.TriConsumer;
import io.github.palexdev.materialfx.utils.others.observables.When;
import java.lang.ref.WeakReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class OnChanged<T>
extends When<T> {
    private ChangeListener<T> listener;
    private BiConsumer<T, T> action;
    private TriConsumer<WeakReference<When<T>>, T, T> otherwise = (w, o, n) -> {};
    private BiFunction<T, T, Boolean> condition = (o, n) -> true;

    private OnChanged(ObservableValue<T> observableValue) {
        super(observableValue);
    }

    public static <T> OnChanged<T> forObservable(ObservableValue<T> observableValue) {
        return new OnChanged<T>(observableValue);
    }

    public OnChanged<T> then(BiConsumer<T, T> action) {
        this.action = action;
        return this;
    }

    public OnChanged<T> otherwise(TriConsumer<WeakReference<When<T>>, T, T> otherwise) {
        this.otherwise = otherwise;
        return this;
    }

    public OnChanged<T> condition(BiFunction<T, T, Boolean> condition) {
        this.condition = condition;
        return this;
    }

    @Override
    public OnChanged<T> executeNow() {
        this.action.accept(null, this.observableValue.getValue());
        return this;
    }

    @Override
    public OnChanged<T> executeNow(Supplier<Boolean> condition) {
        if (condition.get().booleanValue()) {
            this.executeNow();
        }
        return this;
    }

    @Override
    public OnChanged<T> listen() {
        this.listener = this.oneShot ? (observable, oldValue, newValue) -> {
            if (this.condition.apply(oldValue, newValue).booleanValue()) {
                this.action.accept(oldValue, newValue);
                this.dispose();
            } else {
                this.otherwise.accept(new WeakReference<OnChanged>(this), oldValue, newValue);
            }
        } : (observable, oldValue, newValue) -> {
            if (this.condition.apply(oldValue, newValue).booleanValue()) {
                this.action.accept(oldValue, newValue);
            } else {
                this.otherwise.accept(new WeakReference<OnChanged>(this), oldValue, newValue);
            }
        };
        this.invalidatingObservables.forEach(o -> o.addListener(this.invalidationListener));
        this.register();
        this.observableValue.addListener(this.listener);
        return this;
    }

    @Override
    protected When<T> invalidate() {
        this.executeNow(() -> this.condition.apply(null, this.observableValue.getValue()));
        return this;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.observableValue != null && this.listener != null) {
            this.observableValue.removeListener(this.listener);
            this.listener = null;
            whens.remove(this.observableValue);
        }
    }
}

