/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.utils.others.observables;

import io.github.palexdev.materialfx.utils.others.observables.When;
import java.lang.ref.WeakReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;

public class OnInvalidated<T>
extends When<T> {
    private InvalidationListener listener;
    private Consumer<T> action;
    private BiConsumer<WeakReference<When<T>>, T> otherwise = (w, t) -> {};
    private Function<T, Boolean> condition = t -> true;

    private OnInvalidated(ObservableValue<T> observableValue) {
        super(observableValue);
    }

    public static <T> OnInvalidated<T> forObservable(ObservableValue<T> observableValue) {
        return new OnInvalidated<T>(observableValue);
    }

    public OnInvalidated<T> then(Consumer<T> action) {
        this.action = action;
        return this;
    }

    public OnInvalidated<T> otherwise(BiConsumer<WeakReference<When<T>>, T> otherwise) {
        this.otherwise = otherwise;
        return this;
    }

    public OnInvalidated<T> condition(Function<T, Boolean> condition) {
        this.condition = condition;
        return this;
    }

    @Override
    public OnInvalidated<T> executeNow() {
        this.action.accept(this.observableValue.getValue());
        return this;
    }

    @Override
    public OnInvalidated<T> executeNow(Supplier<Boolean> condition) {
        if (condition.get().booleanValue()) {
            this.executeNow();
        }
        return this;
    }

    @Override
    public OnInvalidated<T> listen() {
        this.listener = this.oneShot ? invalidated -> {
            Object value = this.observableValue.getValue();
            if (this.condition.apply(value).booleanValue()) {
                this.action.accept(value);
                this.dispose();
            } else {
                this.otherwise.accept((WeakReference<When<WeakReference<OnInvalidated>>>)new WeakReference<OnInvalidated>(this), (WeakReference<OnInvalidated>)value);
            }
        } : invalidated -> {
            Object value = this.observableValue.getValue();
            if (this.condition.apply(value).booleanValue()) {
                this.action.accept(value);
            } else {
                this.otherwise.accept((WeakReference<When<WeakReference<OnInvalidated>>>)new WeakReference<OnInvalidated>(this), (WeakReference<OnInvalidated>)value);
            }
        };
        this.invalidatingObservables.forEach(o -> o.addListener(this.invalidationListener));
        this.register();
        this.observableValue.addListener(this.listener);
        return this;
    }

    @Override
    protected When<T> invalidate() {
        this.executeNow(() -> this.condition.apply(this.observableValue.getValue()));
        return this;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.observableValue != null && this.listener != null) {
            this.observableValue.removeListener(this.listener);
            this.listener = null;
            whens.remove(this.observableValue);
        }
    }
}

