/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxeffects.animations;

import io.github.palexdev.mfxeffects.animations.Animations;
import javafx.animation.Interpolator;
import javafx.animation.Timeline;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.util.Duration;

public enum AnimationFactory {
    FADE_IN{

        @Override
        public Timeline build(Node node, double millis, Interpolator i) {
            return Animations.TimelineBuilder.build().add(Animations.KeyFrames.of(0.0, node.opacityProperty(), Double.valueOf(0.0))).add(Animations.KeyFrames.of(millis, node.opacityProperty(), Double.valueOf(1.0), i)).getAnimation();
        }
    }
    ,
    FADE_OUT{

        @Override
        public Timeline build(Node node, double millis, Interpolator i) {
            return Animations.TimelineBuilder.build().add(Animations.KeyFrames.of(0.0, node.opacityProperty(), Double.valueOf(1.0))).add(Animations.KeyFrames.of(millis, node.opacityProperty(), Double.valueOf(0.0), i)).getAnimation();
        }
    }
    ,
    SLIDE_IN_BOTTOM{

        @Override
        public Timeline build(Node node, double millis, Interpolator i) {
            double distance = this.computeDistanceBottom(node);
            return Animations.TimelineBuilder.build().add(Animations.KeyFrames.of(0.0, node.translateYProperty(), Double.valueOf(distance))).add(Animations.KeyFrames.of(millis, node.translateYProperty(), Integer.valueOf(0), i)).getAnimation();
        }
    }
    ,
    SLIDE_OUT_BOTTOM{

        @Override
        public Timeline build(Node node, double millis, Interpolator i) {
            double distance = this.computeDistanceBottom(node);
            return Animations.TimelineBuilder.build().add(Animations.KeyFrames.of(0.0, node.translateYProperty(), Integer.valueOf(0))).add(Animations.KeyFrames.of(millis, node.translateYProperty(), Double.valueOf(distance), i)).getAnimation();
        }
    }
    ,
    SLIDE_IN_LEFT{

        @Override
        public Timeline build(Node node, double millis, Interpolator i) {
            double distance = this.computeDistanceLeft(node);
            return Animations.TimelineBuilder.build().add(Animations.KeyFrames.of(0.0, node.translateXProperty(), Double.valueOf(-distance))).add(Animations.KeyFrames.of(millis, node.translateXProperty(), Integer.valueOf(0), i)).getAnimation();
        }
    }
    ,
    SLIDE_OUT_LEFT{

        @Override
        public Timeline build(Node node, double millis, Interpolator i) {
            double distance = this.computeDistanceLeft(node);
            return Animations.TimelineBuilder.build().add(Animations.KeyFrames.of(0.0, node.translateXProperty(), Integer.valueOf(0))).add(Animations.KeyFrames.of(millis, node.translateXProperty(), Double.valueOf(-distance), i)).getAnimation();
        }
    }
    ,
    SLIDE_IN_RIGHT{

        @Override
        public Timeline build(Node node, double millis, Interpolator i) {
            double distance = this.computeDistanceRight(node);
            return Animations.TimelineBuilder.build().add(Animations.KeyFrames.of(0.0, node.translateXProperty(), Double.valueOf(distance))).add(Animations.KeyFrames.of(millis, node.translateXProperty(), Integer.valueOf(0), i)).getAnimation();
        }
    }
    ,
    SLIDE_OUT_RIGHT{

        @Override
        public Timeline build(Node node, double millis, Interpolator i) {
            double distance = this.computeDistanceRight(node);
            return Animations.TimelineBuilder.build().add(Animations.KeyFrames.of(0.0, node.translateXProperty(), Integer.valueOf(0))).add(Animations.KeyFrames.of(millis, node.translateXProperty(), Double.valueOf(distance), i)).getAnimation();
        }
    }
    ,
    SLIDE_IN_TOP{

        @Override
        public Timeline build(Node node, double millis, Interpolator i) {
            double distance = this.computeDistanceTop(node);
            return Animations.TimelineBuilder.build().add(Animations.KeyFrames.of(0.0, node.translateYProperty(), Double.valueOf(distance))).add(Animations.KeyFrames.of(millis, node.translateYProperty(), Integer.valueOf(0), i)).getAnimation();
        }
    }
    ,
    SLIDE_OUT_TOP{

        @Override
        public Timeline build(Node node, double millis, Interpolator i) {
            double distance = this.computeDistanceTop(node);
            return Animations.TimelineBuilder.build().add(Animations.KeyFrames.of(0.0, node.translateYProperty(), Integer.valueOf(0))).add(Animations.KeyFrames.of(millis, node.translateYProperty(), Double.valueOf(distance), i)).getAnimation();
        }
    };

    public static final Interpolator INTERPOLATOR_V1;
    public static final Interpolator INTERPOLATOR_V2;
    public static double extraOffset;

    public double computeDistanceLeft(Node node) {
        double w = node.getBoundsInParent().getWidth();
        return node.getBoundsInParent().getMinX() + w + extraOffset;
    }

    public double computeDistanceRight(Node node) {
        double w = node.getBoundsInParent().getWidth();
        Parent parent = node.getParent();
        if (parent == null) {
            return w + extraOffset;
        }
        return parent.getLayoutBounds().getWidth() - node.getBoundsInParent().getMaxX() + w + extraOffset;
    }

    public double computeDistanceTop(Node node) {
        double h = node.getBoundsInParent().getHeight();
        return node.getBoundsInParent().getMinY() + h + extraOffset;
    }

    public double computeDistanceBottom(Node node) {
        double h = node.getBoundsInParent().getHeight();
        Parent parent = node.getParent();
        if (parent == null) {
            return h + extraOffset;
        }
        return parent.getLayoutBounds().getHeight() - node.getBoundsInParent().getMaxY() + h + extraOffset;
    }

    public Timeline build(Node node, double millis) {
        return this.build(node, millis, INTERPOLATOR_V1);
    }

    public Timeline build(Node node, Duration duration) {
        return this.build(node, duration.toMillis());
    }

    public Timeline build(Node node, Duration duration, Interpolator i) {
        return this.build(node, duration.toMillis(), i);
    }

    public abstract Timeline build(Node var1, double var2, Interpolator var4);

    static {
        INTERPOLATOR_V1 = Interpolator.SPLINE((double)0.25, (double)0.1, (double)0.25, (double)1.0);
        INTERPOLATOR_V2 = Interpolator.SPLINE((double)0.0825, (double)0.3025, (double)0.0875, (double)0.9975);
        extraOffset = 5.0;
    }
}

