/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxeffects.animations;

import io.github.palexdev.mfxeffects.enums.Interpolators;
import java.util.function.Consumer;
import javafx.animation.Interpolator;
import javafx.animation.Transition;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.util.Duration;

public class ConsumerTransition
extends Transition {
    private Consumer<Double> interpolateConsumer;

    public ConsumerTransition setDuration(Duration duration) {
        this.setCycleDuration(duration);
        return this;
    }

    public ConsumerTransition setDuration(double millis) {
        this.setCycleDuration(Duration.millis((double)millis));
        return this;
    }

    public ConsumerTransition setInterpolateConsumer(Consumer<Double> interpolateConsumer) {
        this.interpolateConsumer = interpolateConsumer;
        return this;
    }

    public ConsumerTransition setInterpolatorFluent(Interpolator interpolator) {
        this.setInterpolator(interpolator);
        return this;
    }

    public ConsumerTransition setInterpolatorFluent(Interpolators interpolator) {
        return this.setInterpolatorFluent(interpolator.toInterpolator());
    }

    public ConsumerTransition setDelayFluent(Duration duration) {
        this.setDelay(duration);
        return this;
    }

    public ConsumerTransition setOnFinishedFluent(EventHandler<ActionEvent> handler) {
        this.setOnFinished(handler);
        return this;
    }

    public void playWithConsumer(Consumer<Double> interpolateConsumer) {
        this.setInterpolateConsumer(interpolateConsumer);
        this.play();
    }

    protected void interpolate(double frac) {
        this.interpolateConsumer.accept(frac);
    }

    public static ConsumerTransition of(Consumer<Double> interpolateConsumer) {
        return new ConsumerTransition().setInterpolateConsumer(interpolateConsumer);
    }

    public static ConsumerTransition of(Consumer<Double> interpolateConsumer, Duration duration) {
        return new ConsumerTransition().setInterpolateConsumer(interpolateConsumer).setDuration(duration);
    }

    public static ConsumerTransition of(Consumer<Double> interpolateConsumer, double duration) {
        return new ConsumerTransition().setInterpolateConsumer(interpolateConsumer).setDuration(duration);
    }

    public static ConsumerTransition of(Consumer<Double> interpolateConsumer, Duration duration, Interpolator interpolator) {
        return new ConsumerTransition().setInterpolateConsumer(interpolateConsumer).setDuration(duration).setInterpolatorFluent(interpolator);
    }

    public static ConsumerTransition of(Consumer<Double> interpolateConsumer, double duration, Interpolator interpolator) {
        return new ConsumerTransition().setInterpolateConsumer(interpolateConsumer).setDuration(duration).setInterpolatorFluent(interpolator);
    }

    public static ConsumerTransition of(Consumer<Double> interpolateConsumer, Duration duration, Interpolators interpolator) {
        return new ConsumerTransition().setInterpolateConsumer(interpolateConsumer).setDuration(duration).setInterpolatorFluent(interpolator.toInterpolator());
    }

    public static ConsumerTransition of(Consumer<Double> interpolateConsumer, double duration, Interpolators interpolator) {
        return new ConsumerTransition().setInterpolateConsumer(interpolateConsumer).setDuration(duration).setInterpolatorFluent(interpolator.toInterpolator());
    }
}

