/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxeffects.animations.motion;

import io.github.palexdev.mfxeffects.animations.base.Curve;

public class Cubic
extends Curve {
    private final double x1;
    private final double y1;
    private final double x2;
    private final double y2;
    private static final double CUBIC_ERROR_BOUND = 0.001;

    public Cubic(double x1, double y1, double x2, double y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    double elevateCubic(double a, double b, double m) {
        return 3.0 * a * (1.0 - m) * (1.0 - m) * m + 3.0 * b * (1.0 - m) * m * m + m * m * m;
    }

    @Override
    public double curve(double t) {
        double start = 0.0;
        double end = 1.0;
        double midpoint;
        double estimate;
        while (!(Math.abs(t - (estimate = this.elevateCubic(this.x1, this.x2, midpoint = (start + end) / 2.0))) < 0.001)) {
            if (estimate < t) {
                start = midpoint;
                continue;
            }
            end = midpoint;
        }
        return this.elevateCubic(this.y1, this.y2, midpoint);
    }
}

