/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxeffects.animations.motion;

import io.github.palexdev.mfxeffects.animations.base.Curve;
import io.github.palexdev.mfxeffects.animations.motion.Motion;
import io.github.palexdev.mfxeffects.utils.NumberUtils;

public class Interval
extends Curve {
    private final double begin;
    private final double end;
    private final Curve curve;

    public Interval(double begin, double end) {
        this.begin = begin;
        this.end = end;
        this.curve = Motion.LINEAR;
    }

    public Interval(double begin, double end, Curve curve) {
        this.begin = begin;
        this.end = end;
        this.curve = curve;
    }

    @Override
    public double curve(double t) {
        assert (this.begin >= 0.0);
        assert (this.begin <= 1.0);
        assert (this.end >= 0.0);
        assert (this.end <= 1.0);
        assert (this.end >= this.begin);
        if ((t = NumberUtils.clamp((t - this.begin) / (this.end - this.begin), 0.0, 1.0)) == 0.0 || t == 1.0) {
            return t;
        }
        return this.curve.curve(t);
    }
}

