/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxeffects.animations.motion;

import io.github.palexdev.mfxeffects.animations.base.Curve;
import io.github.palexdev.mfxeffects.animations.motion.Cubic;
import io.github.palexdev.mfxeffects.beans.Offset;

public class ThreePointCubic
extends Curve {
    private final Offset a1;
    private final Offset b1;
    private final Offset midpoint;
    private final Offset a2;
    private final Offset b2;

    public ThreePointCubic(Offset a1, Offset b1, Offset midpoint, Offset a2, Offset b2) {
        this.a1 = a1;
        this.b1 = b1;
        this.midpoint = midpoint;
        this.a2 = a2;
        this.b2 = b2;
    }

    @Override
    public double curve(double t) {
        boolean firstCurve = t < this.midpoint.getDx();
        double scaleX = firstCurve ? this.midpoint.getDx() : 1.0 - this.midpoint.getDx();
        double scaleY = firstCurve ? this.midpoint.getDy() : 1.0 - this.midpoint.getDy();
        double scaledT = (t - (firstCurve ? 0.0 : this.midpoint.getDx())) / scaleX;
        if (firstCurve) {
            return new Cubic(this.a1.getDx() / scaleX, this.a1.getDy() / scaleY, this.b1.getDx() / scaleX, this.b1.getDy() / scaleY).curve(scaledT) * scaleY;
        }
        return new Cubic((this.a2.getDx() - this.midpoint.getDx()) / scaleX, (this.a2.getDy() - this.midpoint.getDy()) / scaleY, (this.b2.getDx() - this.midpoint.getDx()) / scaleX, (this.b2.getDy() - this.midpoint.getDy()) / scaleY).curve(scaledT) * scaleY + this.midpoint.getDy();
    }
}

