/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxeffects.beans;

import io.github.palexdev.mfxeffects.beans.base.OffsetBase;

public class Offset
extends OffsetBase {
    public static final Offset ZERO = new Offset(0.0, 0.0);
    public static final Offset INFINITE = new Offset(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

    public Offset(double dx, double dy) {
        super(dx, dy);
    }

    public static Offset fromDirection(double direction) {
        return Offset.fromDirection(direction, 1.0);
    }

    public static Offset fromDirection(double direction, double distance) {
        return new Offset(distance * Math.cos(direction), distance * Math.sin(direction));
    }

    public static Offset lerp(Offset a, Offset b, double t) {
        if (b == null) {
            if (a == null) {
                return null;
            }
            return a.mul(1.0 - t);
        }
        if (a == null) {
            return b.mul(t);
        }
        return new Offset(Offset.lerpDouble(a.dx, b.dx, t), Offset.lerpDouble(a.dy, b.dy, t));
    }

    private static double lerpDouble(double a, double b, double t) {
        return a * (1.0 - t) + b * t;
    }

    public double getDistance() {
        return Math.sqrt(this.dx * this.dx + this.dy * this.dy);
    }

    public double getDistanceSquared() {
        return this.dx * this.dx + this.dy * this.dy;
    }

    public double getDirection() {
        return Math.atan2(this.dy, this.dx);
    }

    public Offset scale(double scaleX, double scaleY) {
        return new Offset(this.dx * scaleX, this.dy * scaleY);
    }

    public Offset translate(double translateX, double translateY) {
        return new Offset(this.dx + translateX, this.dy + translateY);
    }

    public Offset inverse() {
        return new Offset(-this.dx, -this.dy);
    }

    public Offset minus(Offset other) {
        return new Offset(this.dx - other.dx, this.dy - other.dy);
    }

    public Offset plus(Offset other) {
        return new Offset(this.dx + other.dx, this.dy + other.dy);
    }

    public Offset mul(double operand) {
        return new Offset(this.dx * operand, this.dy * operand);
    }

    public Offset div(double operand) {
        return new Offset(this.dx / operand, this.dy / operand);
    }

    public Offset divTruncate(double operand) {
        return new Offset((double)((int)this.dx) / operand, (double)((int)this.dy) / operand);
    }

    public Offset mod(double operand) {
        return new Offset(this.dx % operand, this.dy % operand);
    }
}

