/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxeffects.beans.base;

import java.util.Objects;

public abstract class OffsetBase {
    protected final double dx;
    protected final double dy;

    public OffsetBase(double dx, double dy) {
        this.dx = dx;
        this.dy = dy;
    }

    public boolean lesser(OffsetBase other) {
        return this.dx < other.dx && this.dy < other.dy;
    }

    public boolean lesserEq(OffsetBase other) {
        return this.dx <= other.dx && this.dy <= other.dy;
    }

    public boolean greater(OffsetBase other) {
        return this.dx > other.dx && this.dy > other.dy;
    }

    public boolean greaterEq(OffsetBase other) {
        return this.dx >= other.dx && this.dy >= other.dy;
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.dx) || Double.isInfinite(this.dy);
    }

    public boolean isFinite() {
        return !this.isInfinite();
    }

    public double getDx() {
        return this.dx;
    }

    public double getDy() {
        return this.dy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OffsetBase that = (OffsetBase)o;
        return Double.compare(that.dx, this.dx) == 0 && Double.compare(that.dy, this.dy) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.dx, this.dy);
    }

    public String toString() {
        return String.format("%s(%f, %f)", this.getClass().getSimpleName(), this.dx, this.dy);
    }
}

