/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxeffects.beans.properties;

import io.github.palexdev.mfxeffects.beans.Position;
import java.util.Optional;
import javafx.beans.property.ReadOnlyObjectWrapper;

public class PositionProperty
extends ReadOnlyObjectWrapper<Position> {
    public PositionProperty() {
    }

    public PositionProperty(Position initialValue) {
        super((Object)initialValue);
    }

    public PositionProperty(Object bean, String name) {
        super(bean, name);
    }

    public PositionProperty(Object bean, String name, Position initialValue) {
        super(bean, name, (Object)initialValue);
    }

    public void setPosition(double x, double y) {
        this.set(Position.of(x, y));
    }

    public void setX(double x) {
        Optional.ofNullable((Position)this.get()).ifPresentOrElse(p -> {
            boolean changed = p.getX() != x;
            p.setX(x);
            if (changed) {
                this.invalidated();
                this.fireValueChangedEvent();
            }
        }, () -> this.setPosition(x, 0.0));
    }

    public void setY(double y) {
        Optional.ofNullable((Position)this.get()).ifPresentOrElse(p -> {
            boolean changed = p.getY() != y;
            p.setY(y);
            if (changed) {
                this.invalidated();
                this.fireValueChangedEvent();
            }
        }, () -> this.setPosition(0.0, y));
    }

    public double getX() {
        return Optional.ofNullable((Position)this.get()).map(Position::getX).orElse(0.0);
    }

    public double getX(double or) {
        return Optional.ofNullable((Position)this.get()).map(Position::getX).orElse(or);
    }

    public double getY() {
        return Optional.ofNullable((Position)this.get()).map(Position::getY).orElse(0.0);
    }

    public double getY(double or) {
        return Optional.ofNullable((Position)this.get()).map(Position::getY).orElse(or);
    }
}

