/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxeffects.beans.properties.styleable;

import io.github.palexdev.mfxeffects.beans.Size;
import java.util.Arrays;
import java.util.function.Function;
import javafx.css.CssMetaData;
import javafx.css.ParsedValue;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.scene.text.Font;

public class StyleableSizeProperty
extends SimpleStyleableObjectProperty<Size> {
    public StyleableSizeProperty(CssMetaData<? extends Styleable, Size> cssMetaData) {
        super(cssMetaData);
    }

    public StyleableSizeProperty(CssMetaData<? extends Styleable, Size> cssMetaData, Size initialValue) {
        super(cssMetaData, (Object)initialValue);
    }

    public StyleableSizeProperty(CssMetaData<? extends Styleable, Size> cssMetaData, Object bean, String name) {
        super(cssMetaData, bean, name);
    }

    public StyleableSizeProperty(CssMetaData<? extends Styleable, Size> cssMetaData, Object bean, String name, Size initialValue) {
        super(cssMetaData, bean, name, (Object)initialValue);
    }

    public void setSize(double width, double height) {
        this.set(Size.of(width, height));
    }

    public void applyStyle(StyleOrigin origin, Size v) {
        if (v == null) {
            return;
        }
        super.applyStyle(origin, (Object)v);
    }

    public static <S extends Styleable> CssMetaData<S, Size> metaDataFor(String propId, final Function<S, StyleableSizeProperty> property, Size initialValue) {
        return new CssMetaData<S, Size>(propId, SizeConverter.getInstance(), initialValue){

            public boolean isSettable(S styleable) {
                return !((StyleableSizeProperty)((Object)property.apply(styleable))).isBound();
            }

            public StyleableProperty<Size> getStyleableProperty(S styleable) {
                return (StyleableProperty)property.apply(styleable);
            }
        };
    }

    public StyleOrigin getStyleOrigin() {
        return StyleOrigin.USER_AGENT;
    }

    public static class SizeConverter
    extends StyleConverter<String, Size> {
        public static StyleConverter<String, Size> getInstance() {
            return Holder.INSTANCE;
        }

        private SizeConverter() {
        }

        public Size convert(ParsedValue<String, Size> value, Font font) {
            try {
                double[] sizes = Arrays.stream(((String)value.getValue()).split(" ")).mapToDouble(Double::parseDouble).toArray();
                return Size.of(sizes[0], sizes[1]);
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                return null;
            }
        }

        public String toString() {
            return "SizeConverter";
        }

        private static class Holder {
            static final SizeConverter INSTANCE = new SizeConverter();

            private Holder() {
            }
        }
    }
}

