/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxeffects.ripple;

import io.github.palexdev.mfxeffects.animations.Animations;
import io.github.palexdev.mfxeffects.animations.ConsumerTransition;
import io.github.palexdev.mfxeffects.animations.motion.Motion;
import io.github.palexdev.mfxeffects.beans.Offset;
import io.github.palexdev.mfxeffects.beans.Size;
import io.github.palexdev.mfxeffects.ripple.base.Ripple;
import io.github.palexdev.mfxeffects.ripple.base.RippleGeneratorBase;
import io.github.palexdev.mfxeffects.utils.ColorUtils;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.layout.Background;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.util.Duration;

public class CircleRipple
extends Circle
implements Ripple<Circle> {
    private final RippleGeneratorBase generator;
    protected double INIT_RAD_MULTIPLIER = 0.2;
    protected double initRad;
    protected double targetRad;
    protected double initX = 0.0;
    protected double initY = 0.0;
    protected Interpolator CURVE = Motion.EASE;
    protected Duration RAD_IN = Duration.millis((double)300.0);
    protected Duration FADE_IN = Duration.millis((double)100.0);
    protected Duration FADE_OUT = Duration.millis((double)300.0);
    protected Duration BG = Duration.millis((double)300.0);
    protected double MIN_IN_MILLIS = 150.0;
    private Animation radIn;
    private Animation fadeIn;
    private Animation fadeOut;
    private Animation pause;

    public CircleRipple(RippleGeneratorBase generator) {
        this.generator = generator;
    }

    @Override
    public void init() {
        this.setFill((Paint)this.generator.getRippleColor());
        this.determineRippleSize();
        this.buildAnimations();
    }

    protected void buildAnimations() {
        KeyFrame radInKF = Animations.KeyFrames.of(this.RAD_IN, this.radiusProperty(), Double.valueOf(this.targetRad), this.CURVE);
        KeyFrame xInKF = Animations.KeyFrames.of(this.RAD_IN, this.centerXProperty(), Double.valueOf(this.generator.getLayoutBounds().getCenterX()), this.CURVE);
        KeyFrame yInKF = Animations.KeyFrames.of(this.RAD_IN, this.centerYProperty(), Double.valueOf(this.generator.getLayoutBounds().getCenterY()), this.CURVE);
        this.radIn = Animations.TimelineBuilder.build().add(radInKF).add(xInKF).add(yInKF).getAnimation();
        boolean animateBackground = this.generator.doAnimateBackground();
        Color bgColor = this.generator.getBackgroundColor();
        KeyFrame fadeInKF = Animations.KeyFrames.of(this.FADE_IN, this.opacityProperty(), Double.valueOf(1.0));
        KeyFrame fadeOutKF = Animations.KeyFrames.of(this.FADE_OUT, this.opacityProperty(), Double.valueOf(0.0));
        if (animateBackground) {
            this.fadeIn = Animations.ParallelBuilder.build().add(fadeInKF).add(() -> ConsumerTransition.of(dt -> {
                double alpha = dt * bgColor.getOpacity();
                Color color = ColorUtils.atAlpha(bgColor, alpha);
                this.generator.setBackground(Background.fill((Paint)color));
            }, this.BG).setInterpolatorFluent(this.CURVE)).getAnimation();
            this.fadeOut = Animations.ParallelBuilder.build().add(fadeOutKF).add(() -> ConsumerTransition.of(dt -> {
                double bgAlpha = bgColor.getOpacity();
                double alpha = bgAlpha - dt * bgAlpha;
                Color color = ColorUtils.atAlpha(bgColor, alpha);
                this.generator.setBackground(Background.fill((Paint)color));
            }, this.BG).setInterpolatorFluent(this.CURVE)).getAnimation();
        } else {
            this.fadeIn = Animations.TimelineBuilder.build().add(fadeInKF).getAnimation();
            this.fadeOut = Animations.TimelineBuilder.build().add(fadeOutKF).getAnimation();
        }
    }

    protected void determineRippleSize() {
        Size pref = this.generator.getRipplePrefSize();
        if (!Size.invalid().equals(pref)) {
            this.initRad = 0.0;
            this.targetRad = Math.max(pref.getWidth(), pref.getWidth());
            return;
        }
        double w = this.generator.getWidth();
        double h = this.generator.getHeight();
        double diag = new Offset(w, h).getDistance();
        this.initRad = Math.floor(Math.max(w, h) * this.INIT_RAD_MULTIPLIER);
        this.targetRad = diag / 2.0 + 5.0;
    }

    protected void doPosition() {
        this.setOpacity(0.0);
        this.setRadius(this.initRad);
        this.setCenterX(this.initX);
        this.setCenterY(this.initY);
    }

    @Override
    public Circle toNode() {
        return this;
    }

    @Override
    public void position(double x, double y) {
        this.initX = x;
        this.initY = y;
    }

    @Override
    public void playIn() {
        if (Animations.isPlaying(this.pause)) {
            this.pause.stop();
        }
        this.fadeOut.stop();
        this.doPosition();
        this.fadeIn.playFromStart();
        this.radIn.playFromStart();
    }

    @Override
    public void playOut() {
        double ct = this.radIn.getCurrentTime().toMillis();
        double delay = this.MIN_IN_MILLIS - ct;
        if (delay > 0.0) {
            if (this.pause != null) {
                this.pause.stop();
            }
            this.pause = Animations.PauseBuilder.build().setDuration(delay).setOnFinished((EventHandler<ActionEvent>)((EventHandler)e -> {
                this.fadeIn.stop();
                this.fadeOut.playFromStart();
            })).getAnimation();
            this.pause.play();
            return;
        }
        this.fadeOut.playFromStart();
    }
}

