/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxeffects.ripple;

import io.github.palexdev.mfxeffects.beans.Position;
import io.github.palexdev.mfxeffects.beans.Size;
import io.github.palexdev.mfxeffects.beans.properties.styleable.StyleableSizeProperty;
import io.github.palexdev.mfxeffects.enums.MouseMode;
import io.github.palexdev.mfxeffects.enums.RippleState;
import io.github.palexdev.mfxeffects.ripple.base.Ripple;
import io.github.palexdev.mfxeffects.ripple.base.RippleGeneratorBase;
import io.github.palexdev.mfxeffects.utils.StyleUtils;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class MFXRippleGenerator
extends RippleGeneratorBase {
    public static final Color DEFAULT_RIPPLE_COLOR = Color.rgb((int)107, (int)107, (int)107, (double)0.12);
    private Region owner;
    protected GeneratorState state;
    private Supplier<Region> clipSupplier = () -> null;
    private Supplier<Ripple<?>> rippleSupplier = this.defaultRippleSupplier();
    private Function<MouseEvent, Position> meToPosConverter = e -> Position.of(e.getX(), e.getY());
    private EventHandler<MouseEvent> pressed;
    private EventHandler<MouseEvent> released;
    private EventHandler<MouseEvent> exited;
    private boolean disposed = false;
    private final StyleableBooleanProperty animateBackground = new SimpleStyleableBooleanProperty(StyleableProperties.ANIMATE_BACKGROUND, this, "animateBackground", false){

        protected void invalidated() {
            if (MFXRippleGenerator.this.state != null) {
                MFXRippleGenerator.this.state.updateRipple();
            }
        }

        public StyleOrigin getStyleOrigin() {
            return StyleOrigin.USER_AGENT;
        }
    };
    private final StyleableObjectProperty<Color> backgroundColor = new SimpleStyleableObjectProperty<Color>(StyleableProperties.BACKGROUND_COLOR, (Object)this, "backgroundColor", DEFAULT_RIPPLE_COLOR){

        protected void invalidated() {
            if (MFXRippleGenerator.this.state != null && MFXRippleGenerator.this.doAnimateBackground()) {
                MFXRippleGenerator.this.state.updateRipple();
            }
        }

        public StyleOrigin getStyleOrigin() {
            return StyleOrigin.USER_AGENT;
        }
    };
    private final StyleableObjectProperty<Color> rippleColor = new SimpleStyleableObjectProperty<Color>(StyleableProperties.RIPPLE_COLOR, (Object)this, "rippleColor", DEFAULT_RIPPLE_COLOR){

        protected void invalidated() {
            if (MFXRippleGenerator.this.state != null) {
                MFXRippleGenerator.this.state.updateRipple();
            }
        }

        public StyleOrigin getStyleOrigin() {
            return StyleOrigin.USER_AGENT;
        }
    };
    private final StyleableSizeProperty ripplePrefSize = new StyleableSizeProperty(StyleableProperties.RIPPLE_PREF_SIZE, this, "ripplePrefSize", Size.invalid()){

        protected void invalidated() {
            if (MFXRippleGenerator.this.state != null) {
                MFXRippleGenerator.this.state.updateRipple();
            }
        }
    };
    private final StyleableBooleanProperty checkBounds = new SimpleStyleableBooleanProperty(StyleableProperties.CHECK_BOUNDS, this, "checkBounds", true){

        public StyleOrigin getStyleOrigin() {
            return StyleOrigin.USER_AGENT;
        }
    };
    private final StyleableObjectProperty<MouseMode> mouseMode = new SimpleStyleableObjectProperty<MouseMode>(StyleableProperties.MOUSE_MODE, (Object)this, "mouseMode", MouseMode.MOUSE_TRANSPARENT){

        protected void invalidated() {
            MFXRippleGenerator.this.onMouseModeChanged();
        }

        public StyleOrigin getStyleOrigin() {
            return StyleOrigin.USER_AGENT;
        }
    };

    public MFXRippleGenerator(Region owner) {
        this.owner = owner;
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().setAll((Object[])new String[]{this.defaultStyleClass()});
        this.setManaged(false);
        this.onMouseModeChanged();
    }

    public void generate(MouseEvent me) {
        this.generate(this.meToPosConverter.apply(me));
    }

    protected void updateState() {
        this.state = new GeneratorState(this);
        this.state.init();
        this.requestLayout();
    }

    protected void onMouseModeChanged() {
        MouseMode mode = this.getMouseMode();
        switch (mode) {
            case OFF: {
                this.setPickOnBounds(true);
                this.setMouseTransparent(false);
                break;
            }
            case DONT_PICK_ON_BOUNDS: {
                this.setPickOnBounds(false);
                this.setMouseTransparent(false);
                break;
            }
            case MOUSE_TRANSPARENT: {
                this.setPickOnBounds(true);
                this.setMouseTransparent(true);
            }
        }
    }

    public boolean isGeneratorDisabled() {
        return this.isDisabled() || !this.isVisible() || this.getOpacity() == 0.0;
    }

    public boolean canGenerateAt(double x, double y) {
        if (!this.isCheckBounds()) {
            return true;
        }
        return this.owner.getLayoutBounds().contains(x, y);
    }

    @Override
    public void enable() {
        if (this.disposed) {
            return;
        }
        if (this.pressed == null) {
            this.pressed = this::generate;
            this.released = e -> this.release();
            this.exited = e -> this.release();
            this.owner.addEventHandler(MouseEvent.MOUSE_PRESSED, this.pressed);
            this.owner.addEventHandler(MouseEvent.MOUSE_RELEASED, this.released);
            this.owner.addEventHandler(MouseEvent.MOUSE_EXITED, this.exited);
        }
    }

    @Override
    public void disable() {
        if (this.pressed != null) {
            this.owner.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.pressed);
            this.owner.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.released);
            this.owner.removeEventHandler(MouseEvent.MOUSE_EXITED, this.exited);
        }
        this.pressed = null;
        this.released = null;
        this.exited = null;
    }

    @Override
    public void generate(double x, double y) {
        if (this.isGeneratorDisabled() || !this.canGenerateAt(x, y)) {
            return;
        }
        this.state.rippleState = RippleState.WAITING_FOR_CLICK;
        this.state.ripple.position(x, y);
        this.state.ripple.playIn();
    }

    @Override
    public void release() {
        if (this.state.rippleState == RippleState.INACTIVE) {
            return;
        }
        this.state.ripple.playOut();
        this.state.rippleState = RippleState.INACTIVE;
    }

    @Override
    public Region buildClip() {
        Supplier<Region> supplier = this.getClipSupplier();
        if (supplier == null) {
            return null;
        }
        Region clip = supplier.get();
        if (clip != null) {
            return clip;
        }
        clip = new Region();
        clip.backgroundProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
            CornerRadii radius = StyleUtils.parseCornerRadius(this.owner);
            BackgroundFill fill = new BackgroundFill((Paint)Color.WHITE, radius, Insets.EMPTY);
            return new Background(new BackgroundFill[]{fill});
        }, (Observable[])new Observable[]{this.owner.backgroundProperty(), this.owner.borderProperty()}));
        return clip;
    }

    @Override
    public void dispose() {
        this.disposed = true;
        this.getChildren().clear();
        this.disable();
        if (this.state != null) {
            this.state.dispose();
        }
        this.owner = null;
    }

    protected void layoutChildren() {
        if (this.disposed) {
            return;
        }
        double w = this.getWidth();
        double h = this.getHeight();
        if (this.state == null) {
            this.updateState();
            this.state.clip.resizeRelocate(0.0, 0.0, w, h);
            return;
        }
        if (Size.of(w, h).equals(this.state.bounds)) {
            if (this.state.clipUpdated) {
                this.state.clip.resizeRelocate(0.0, 0.0, w, h);
                this.state.clipUpdated = false;
            }
            return;
        }
        this.updateState();
        this.state.clip.resizeRelocate(0.0, 0.0, w, h);
    }

    @Override
    public boolean doAnimateBackground() {
        return this.animateBackground.get();
    }

    @Override
    public StyleableBooleanProperty animateBackgroundProperty() {
        return this.animateBackground;
    }

    @Override
    public void setAnimateBackground(boolean animateBackground) {
        this.animateBackground.set(animateBackground);
    }

    @Override
    public Color getBackgroundColor() {
        return (Color)this.backgroundColor.get();
    }

    @Override
    public StyleableObjectProperty<Color> backgroundColorProperty() {
        return this.backgroundColor;
    }

    @Override
    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor.set((Object)backgroundColor);
    }

    @Override
    public Color getRippleColor() {
        return (Color)this.rippleColor.get();
    }

    @Override
    public StyleableObjectProperty<Color> rippleColorProperty() {
        return this.rippleColor;
    }

    @Override
    public void setRippleColor(Color rippleColor) {
        this.rippleColor.set((Object)rippleColor);
    }

    @Override
    public Size getRipplePrefSize() {
        return (Size)this.ripplePrefSize.get();
    }

    @Override
    public StyleableSizeProperty ripplePrefSizeProperty() {
        return this.ripplePrefSize;
    }

    @Override
    public void setRipplePrefSize(Size ripplePrefSize) {
        this.ripplePrefSize.set(ripplePrefSize);
    }

    public boolean isCheckBounds() {
        return this.checkBounds.get();
    }

    public StyleableBooleanProperty checkBoundsProperty() {
        return this.checkBounds;
    }

    public void setCheckBounds(boolean checkBounds) {
        this.checkBounds.set(checkBounds);
    }

    public MouseMode getMouseMode() {
        return (MouseMode)((Object)this.mouseMode.get());
    }

    public StyleableObjectProperty<MouseMode> mouseModeProperty() {
        return this.mouseMode;
    }

    public void setMouseMode(MouseMode mouseMode) {
        this.mouseMode.set((Object)mouseMode);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.cssMetaDataList;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return MFXRippleGenerator.getClassCssMetaData();
    }

    public final String defaultStyleClass() {
        return "mfx-ripple-generator";
    }

    @Override
    public Region getOwner() {
        return this.owner;
    }

    public RippleState getRippleState() {
        return Optional.ofNullable(this.state).map(GeneratorState::getRippleState).orElse(RippleState.INACTIVE);
    }

    @Override
    public Supplier<Region> getClipSupplier() {
        return this.clipSupplier;
    }

    @Override
    public void setClipSupplier(Supplier<Region> clipSupplier) {
        this.clipSupplier = clipSupplier;
        if (this.state != null) {
            this.state.updateClip();
        }
    }

    @Override
    public Supplier<Ripple<?>> getRippleSupplier() {
        return this.rippleSupplier;
    }

    @Override
    public void setRippleSupplier(Supplier<Ripple<?>> rippleSupplier) {
        this.rippleSupplier = rippleSupplier;
        if (this.state != null) {
            this.state.updateRipple();
        }
    }

    public Function<MouseEvent, Position> getMeToPosConverter() {
        return this.meToPosConverter;
    }

    public void setMeToPosConverter(Function<MouseEvent, Position> meToPosConverter) {
        this.meToPosConverter = meToPosConverter;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    private static class StyleableProperties {
        private static final StyleablePropertyFactory<MFXRippleGenerator> FACTORY = new StyleablePropertyFactory(Region.getClassCssMetaData());
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<MFXRippleGenerator, Boolean> ANIMATE_BACKGROUND;
        private static final CssMetaData<MFXRippleGenerator, Color> BACKGROUND_COLOR;
        private static final CssMetaData<MFXRippleGenerator, Color> RIPPLE_COLOR;
        private static final CssMetaData<MFXRippleGenerator, Size> RIPPLE_PREF_SIZE;
        private static final CssMetaData<MFXRippleGenerator, Boolean> CHECK_BOUNDS;
        private static final CssMetaData<MFXRippleGenerator, MouseMode> MOUSE_MODE;

        private StyleableProperties() {
        }

        static {
            ANIMATE_BACKGROUND = FACTORY.createBooleanCssMetaData("-mfx-animate-background", MFXRippleGenerator::animateBackgroundProperty, false);
            BACKGROUND_COLOR = FACTORY.createColorCssMetaData("-mfx-background-color", MFXRippleGenerator::backgroundColorProperty, DEFAULT_RIPPLE_COLOR);
            RIPPLE_COLOR = FACTORY.createColorCssMetaData("-mfx-ripple-color", MFXRippleGenerator::rippleColorProperty, DEFAULT_RIPPLE_COLOR);
            RIPPLE_PREF_SIZE = StyleableSizeProperty.metaDataFor("-mfx-ripple-pref-size", MFXRippleGenerator::ripplePrefSizeProperty, Size.invalid());
            CHECK_BOUNDS = FACTORY.createBooleanCssMetaData("-mfx-check-bounds", MFXRippleGenerator::checkBoundsProperty, true);
            MOUSE_MODE = FACTORY.createEnumCssMetaData(MouseMode.class, "-mfx-mouse-mode", MFXRippleGenerator::mouseModeProperty, (Enum)MouseMode.MOUSE_TRANSPARENT);
            cssMetaDataList = StyleUtils.cssMetaDataList(Region.getClassCssMetaData(), ANIMATE_BACKGROUND, BACKGROUND_COLOR, RIPPLE_COLOR, RIPPLE_PREF_SIZE, CHECK_BOUNDS, MOUSE_MODE);
        }
    }

    public static class GeneratorState {
        private MFXRippleGenerator generator;
        private RippleState rippleState = RippleState.INACTIVE;
        private Size bounds;
        private Node clip;
        private Ripple<?> ripple;
        private boolean clipUpdated = false;

        public GeneratorState(MFXRippleGenerator generator) {
            this.generator = generator;
        }

        protected void init() {
            this.bounds = Size.of(this.generator.getWidth(), this.generator.getHeight());
            this.updateClip();
            this.updateRipple();
        }

        protected void updateClip() {
            this.clip = this.generator.buildClip();
            this.generator.setClip(this.clip);
        }

        protected void updateRipple() {
            this.ripple = this.generator.buildRipple();
            this.ripple.init();
            this.generator.setRipple(this.ripple);
        }

        protected void dispose() {
            this.bounds = null;
            this.generator.setClip(null);
            this.clip = null;
            this.ripple = null;
            this.generator = null;
        }

        public RippleGeneratorBase getGenerator() {
            return this.generator;
        }

        public RippleState getRippleState() {
            return this.rippleState;
        }

        public Size getBounds() {
            return this.bounds;
        }

        public Node getClip() {
            return this.clip;
        }

        public Ripple<?> getRipple() {
            return this.ripple;
        }

        public boolean wasClipUpdated() {
            return this.clipUpdated;
        }
    }
}

