/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxeffects.utils;

import io.github.palexdev.mfxeffects.utils.NumberUtils;
import java.util.Random;
import javafx.scene.paint.Color;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;

public class ColorUtils {
    private static final Random random = new Random(System.currentTimeMillis());

    private ColorUtils() {
    }

    public static String toCss(Paint paint) {
        if (paint == null) {
            return "";
        }
        if (paint instanceof LinearGradient) {
            LinearGradient gradient = (LinearGradient)paint;
            return ColorUtils.linearGradientToString(gradient);
        }
        if (paint instanceof RadialGradient) {
            RadialGradient gradient = (RadialGradient)paint;
            return ColorUtils.radialGradientToString(gradient);
        }
        return ColorUtils.rgb((Color)paint);
    }

    public static String rgb(Color color) {
        if (color == null) {
            return "";
        }
        return String.format("rgb(%d, %d, %d)", (int)(255.0 * color.getRed()), (int)(255.0 * color.getGreen()), (int)(255.0 * color.getBlue()));
    }

    public static String rgba(Color color) {
        if (color == null) {
            return "";
        }
        return String.format("rgba(%d, %d, %d, %s)", (int)(255.0 * color.getRed()), (int)(255.0 * color.getGreen()), (int)(255.0 * color.getBlue()), color.getOpacity());
    }

    public static Color atAlpha(Color color, double alpha) {
        double cAlpha = NumberUtils.clamp(alpha, 0.0, 1.0);
        return Color.color((double)color.getRed(), (double)color.getGreen(), (double)color.getBlue(), (double)cAlpha);
    }

    public static Color getRandomColor() {
        return Color.rgb((int)random.nextInt(256), (int)random.nextInt(256), (int)random.nextInt(256));
    }

    public static Color getRandomColor(double opacity) {
        return Color.rgb((int)random.nextInt(256), (int)random.nextInt(256), (int)random.nextInt(256), (double)opacity);
    }

    public static String linearGradientToString(LinearGradient gradient) {
        if (gradient == null) {
            return "";
        }
        StringBuilder s = new StringBuilder("linear-gradient(from ").append(ColorUtils.lengthToString(gradient.getStartX(), gradient.isProportional())).append(" ").append(ColorUtils.lengthToString(gradient.getStartY(), gradient.isProportional())).append(" to ").append(ColorUtils.lengthToString(gradient.getEndX(), gradient.isProportional())).append(" ").append(ColorUtils.lengthToString(gradient.getEndY(), gradient.isProportional())).append(", ");
        switch (gradient.getCycleMethod()) {
            case REFLECT: {
                s.append("reflect").append(", ");
                break;
            }
            case REPEAT: {
                s.append("repeat").append(", ");
            }
        }
        for (Stop stop : gradient.getStops()) {
            s.append(ColorUtils.stopToString(stop)).append(", ");
        }
        s.delete(s.length() - 2, s.length());
        s.append(")");
        return s.toString();
    }

    public static String radialGradientToString(RadialGradient gradient) {
        if (gradient == null) {
            return "";
        }
        StringBuilder s = new StringBuilder("radial-gradient(focus-angle ").append(gradient.getFocusAngle()).append("deg, focus-distance ").append(gradient.getFocusDistance() * 100.0).append("% , center ").append(ColorUtils.lengthToString(gradient.getCenterX(), gradient.isProportional())).append(" ").append(ColorUtils.lengthToString(gradient.getCenterY(), gradient.isProportional())).append(", radius ").append(ColorUtils.lengthToString(gradient.getRadius(), gradient.isProportional())).append(", ");
        switch (gradient.getCycleMethod()) {
            case REFLECT: {
                s.append("reflect").append(", ");
                break;
            }
            case REPEAT: {
                s.append("repeat").append(", ");
            }
        }
        for (Stop stop : gradient.getStops()) {
            s.append(ColorUtils.stopToString(stop)).append(", ");
        }
        s.delete(s.length() - 2, s.length());
        s.append(")");
        return s.toString();
    }

    public static String stopToString(Stop stop) {
        return ColorUtils.rgba(stop.getColor()) + " " + stop.getOffset() * 100.0 + "%";
    }

    public static String toWeb(Color color) {
        if (color == null) {
            return "";
        }
        String cs = color.toString();
        return "#" + cs.substring(2, cs.length() - 2);
    }

    public static String toWebAlpha(Color color) {
        if (color == null) {
            return "";
        }
        return "#" + color.toString().substring(2);
    }

    public static String toHSL(Color color) {
        if (color == null) {
            return "";
        }
        double[] rgb = ColorUtils.colorToArray(color);
        double r = rgb[0];
        double g = rgb[1];
        double b = rgb[2];
        double min = Math.min(r, Math.min(g, b));
        double max = Math.max(r, Math.max(g, b));
        double h = 0.0;
        if (max == min) {
            h = 0.0;
        } else if (max == r) {
            h = (60.0 * (g - b) / (max - min) + 360.0) % 360.0;
        } else if (max == g) {
            h = 60.0 * (b - r) / (max - min) + 120.0;
        } else if (max == b) {
            h = 60.0 * (r - g) / (max - min) + 240.0;
        }
        double l = (max + min) / 2.0;
        double s = max == min ? 0.0 : (l <= 0.5 ? (max - min) / (max + min) : (max - min) / (2.0 - max - min));
        return "hsl(" + Math.round(h) + "deg, " + Math.round(s * 100.0) + "%, " + Math.round(l * 100.0) + "%)";
    }

    public static String toHSB(Color color) {
        double hue;
        if (color == null) {
            return "";
        }
        double[] rgb = ColorUtils.colorToArray(color);
        double r = rgb[0];
        double g = rgb[1];
        double b = rgb[2];
        double max = Math.max(Math.max(r, g), b);
        double min = Math.min(Math.min(r, g), b);
        double delta = max - min;
        double brightness = max;
        double saturation = max != 0.0 ? delta / max : 0.0;
        if (saturation == 0.0) {
            hue = 0.0;
        } else {
            double tmpR = (max - r) / delta;
            double tmpG = (max - g) / delta;
            double tmpB = (max - b) / delta;
            hue = r == max ? tmpB - tmpG : (g == max ? 2.0 + tmpR - tmpB : 4.0 + tmpG - tmpR);
            if ((hue /= 6.0) < 0.0) {
                hue += 1.0;
            }
        }
        return "hsb(" + Math.round(hue *= 360.0) + "deg, " + Math.round(saturation * 100.0) + "%, " + Math.round(brightness * 100.0) + "%)";
    }

    private static double[] colorToArray(Color color) {
        return new double[]{color.getRed(), color.getGreen(), color.getBlue()};
    }

    private static String lengthToString(double value, boolean proportional) {
        if (proportional) {
            return value * 100.0 + "%";
        }
        return value + "px";
    }
}

