/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxeffects.utils;

import io.github.palexdev.mfxeffects.beans.Position;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.Region;

public class LayoutUtils {
    private LayoutUtils() {
    }

    public static Position computePosition(Region parent, Node child, double areaX, double areaY, double areaWidth, double areaHeight, double areaBaselineOffset, Insets margin, HPos hAlignment, VPos vAlignment) {
        return LayoutUtils.computePosition(parent, child, areaX, areaY, areaWidth, areaHeight, areaBaselineOffset, margin, hAlignment, vAlignment, true, true);
    }

    public static Position computePosition(Region parent, Node child, double areaX, double areaY, double areaWidth, double areaHeight, double areaBaselineOffset, Insets margin, HPos hAlignment, VPos vAlignment, boolean snapToPixel, boolean computeSizes) {
        Insets snappedMargin;
        Insets insets = snappedMargin = margin == null ? Insets.EMPTY : margin;
        if (snapToPixel) {
            snappedMargin = new Insets(parent.snapSpaceY(snappedMargin.getTop()), parent.snapSpaceX(snappedMargin.getRight()), parent.snapSpaceY(snappedMargin.getBottom()), parent.snapSpaceX(snappedMargin.getLeft()));
        }
        double xPosition = LayoutUtils.computeXPosition(parent, child, areaX, areaWidth, snappedMargin, false, hAlignment, snapToPixel, computeSizes);
        double yPosition = LayoutUtils.computeYPosition(parent, child, areaY, areaHeight, areaBaselineOffset, snappedMargin, false, vAlignment, snapToPixel, computeSizes);
        return Position.of(xPosition, yPosition);
    }

    public static double computeXPosition(Region parent, Node child, double areaX, double areaWidth, Insets margin, boolean snapMargin, HPos hAlignment, boolean snapToPixel, boolean computeSizes) {
        Insets snappedMargin;
        Insets insets = snappedMargin = margin == null ? Insets.EMPTY : margin;
        if (snapMargin) {
            snappedMargin = new Insets(parent.snapSpaceY(snappedMargin.getTop()), parent.snapSpaceX(snappedMargin.getRight()), parent.snapSpaceY(snappedMargin.getBottom()), parent.snapSpaceX(snappedMargin.getLeft()));
        }
        double leftMargin = snappedMargin.getLeft();
        double rightMargin = snappedMargin.getRight();
        double xOffset = leftMargin + LayoutUtils.computeXOffset(areaWidth - leftMargin - rightMargin, computeSizes ? LayoutUtils.boundWidth(child) : child.getLayoutBounds().getWidth(), hAlignment);
        double xPosition = areaX + xOffset;
        return snapToPixel ? parent.snapPositionX(xPosition) : xPosition;
    }

    public static double computeYPosition(Region parent, Node child, double areaY, double areaHeight, double areaBaselineOffset, Insets margin, boolean snapMargin, VPos vAlignment, boolean snapToPixel, boolean computeSizes) {
        double bo;
        Insets snappedMargin;
        Insets insets = snappedMargin = margin == null ? Insets.EMPTY : margin;
        if (snapMargin) {
            snappedMargin = new Insets(parent.snapSpaceY(snappedMargin.getTop()), parent.snapSpaceX(snappedMargin.getRight()), parent.snapSpaceY(snappedMargin.getBottom()), parent.snapSpaceX(snappedMargin.getLeft()));
        }
        double topMargin = snappedMargin.getTop();
        double bottomMargin = snappedMargin.getBottom();
        double yOffset = vAlignment == VPos.BASELINE ? ((bo = child.getBaselineOffset()) == Double.NEGATIVE_INFINITY ? areaBaselineOffset - (computeSizes ? LayoutUtils.boundHeight(child) : child.getLayoutBounds().getHeight()) : areaBaselineOffset - bo) : topMargin + LayoutUtils.computeYOffset(areaHeight - topMargin - bottomMargin, computeSizes ? LayoutUtils.boundHeight(child) : child.getLayoutBounds().getHeight(), vAlignment);
        double yPosition = areaY + yOffset;
        return snapToPixel ? parent.snapPositionY(yPosition) : yPosition;
    }

    private static double computeXOffset(double areaWidth, double contentWidth, HPos hAlignment) {
        switch (hAlignment) {
            case LEFT: {
                return 0.0;
            }
            case CENTER: {
                return (areaWidth - contentWidth) / 2.0;
            }
            case RIGHT: {
                return areaWidth - contentWidth;
            }
        }
        throw new AssertionError((Object)"Unhandled hPos");
    }

    private static double computeYOffset(double areaHeight, double contentHeight, VPos vAlignment) {
        switch (vAlignment) {
            case BASELINE: 
            case TOP: {
                return 0.0;
            }
            case CENTER: {
                return (areaHeight - contentHeight) / 2.0;
            }
            case BOTTOM: {
                return areaHeight - contentHeight;
            }
        }
        throw new AssertionError((Object)"Unhandled vPos");
    }

    public static void resize(Region parent, Node node, double w, double h) {
        node.resize(parent.snapSizeX(w), parent.snapSizeY(h));
    }

    public static void relocate(Region parent, Node node, double x, double y) {
        node.relocate(parent.snapPositionX(x), parent.snapPositionY(y));
    }

    public static void resizeRelocate(Region parent, Node node, double x, double y, double w, double h) {
        node.resizeRelocate(parent.snapPositionX(x), parent.snapPositionY(y), parent.snapSizeX(w), parent.snapSizeY(h));
    }

    public static double boundedSize(double min, double pref, double max) {
        double a = Math.max(pref, min);
        double b = Math.max(min, max);
        return Math.min(a, b);
    }

    public static double boundWidth(Node node) {
        return LayoutUtils.boundedSize(node.minWidth(-1.0), node.prefWidth(-1.0), node.maxWidth(-1.0));
    }

    public static double boundHeight(Node node) {
        return LayoutUtils.boundedSize(node.minHeight(-1.0), node.prefHeight(-1.0), node.maxHeight(-1.0));
    }

    public static double snappedBoundWidth(Node node) {
        Parent p = node.getParent();
        if (p instanceof Region) {
            return ((Region)p).snapSizeX(LayoutUtils.boundWidth(node));
        }
        return LayoutUtils.boundWidth(node);
    }

    public static double snappedBoundHeight(Node node) {
        Parent p = node.getParent();
        if (p instanceof Region) {
            return ((Region)p).snapSizeY(LayoutUtils.boundHeight(node));
        }
        return LayoutUtils.boundHeight(node);
    }
}

