/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxeffects.utils;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class NumberUtils {
    private NumberUtils() {
    }

    public static double clamp(double val, double min, double max) {
        return Math.max(min, Math.min(max, val));
    }

    public static float clamp(float val, float min, float max) {
        return Math.max(min, Math.min(max, val));
    }

    public static int clamp(int val, int min, int max) {
        return Math.max(min, Math.min(max, val));
    }

    public static long clamp(long val, long min, long max) {
        return Math.max(min, Math.min(max, val));
    }

    public static double closestValueTo(double val, List<Double> list) {
        if (list.isEmpty()) {
            return 0.0;
        }
        double res = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            if (!(Math.abs(val - res) > Math.abs(val - list.get(i)))) continue;
            res = list.get(i);
        }
        return res;
    }

    public static float closestValueTo(float val, List<Float> list) {
        if (list.isEmpty()) {
            return 0.0f;
        }
        float res = list.get(0).floatValue();
        for (int i = 1; i < list.size(); ++i) {
            if (!(Math.abs(val - res) > Math.abs(val - list.get(i).floatValue()))) continue;
            res = list.get(i).floatValue();
        }
        return res;
    }

    public static int closestValueTo(int val, List<Integer> list) {
        if (list.isEmpty()) {
            return 0;
        }
        int res = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            if (Math.abs(val - res) <= Math.abs(val - list.get(i))) continue;
            res = list.get(i);
        }
        return res;
    }

    public static long closestValueTo(long val, List<Long> list) {
        if (list.isEmpty()) {
            return 0L;
        }
        long res = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            if (Math.abs(val - res) <= Math.abs(val - list.get(i))) continue;
            res = list.get(i);
        }
        return res;
    }

    public static double formatTo(double value, int decimalPrecision) {
        int calcScale = (int)Math.pow(10.0, decimalPrecision);
        return (double)Math.round(value * (double)calcScale) / (double)calcScale;
    }

    public static String formatToString(double value, int decimalPrecision) {
        return String.format("%." + decimalPrecision + "f", value);
    }

    public static double getRandomDoubleBetween(double min, double max) {
        return ThreadLocalRandom.current().nextDouble(min, max);
    }

    public static float getRandomFloat() {
        return ThreadLocalRandom.current().nextFloat();
    }

    public static int getRandomIntBetween(int min, int max) {
        return ThreadLocalRandom.current().nextInt(min, max);
    }

    public static long getRandomLongBetween(long min, long max) {
        return ThreadLocalRandom.current().nextLong(min, max);
    }

    public static boolean isEven(int number) {
        return number % 2 == 0;
    }
}

