/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxeffects;

import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.effect.BlendMode;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.stage.Window;

public class MFXScrimEffect {
    private final Rectangle scrim = new Rectangle();

    public void scrim(Pane pane, double opacity) {
        this.scrim.widthProperty().bind((ObservableValue)pane.widthProperty());
        this.scrim.heightProperty().bind((ObservableValue)pane.heightProperty());
        this.scrim.setFill((Paint)Color.rgb((int)0, (int)0, (int)0, (double)opacity));
        this.scrim.setBlendMode(BlendMode.SRC_ATOP);
        pane.getChildren().add(0, (Object)this.scrim);
    }

    public void modalScrim(Pane pane, double opacity) {
        this.scrim.widthProperty().bind((ObservableValue)pane.widthProperty());
        this.scrim.heightProperty().bind((ObservableValue)pane.heightProperty());
        this.scrim.setFill((Paint)Color.rgb((int)0, (int)0, (int)0, (double)opacity));
        this.scrim.setBlendMode(BlendMode.SRC_ATOP);
        pane.getChildren().add((Object)this.scrim);
    }

    public void modalScrim(Pane parent, Node child, double opacity) {
        this.scrim.widthProperty().bind((ObservableValue)parent.widthProperty());
        this.scrim.heightProperty().bind((ObservableValue)parent.heightProperty());
        this.scrim.setFill((Paint)Color.rgb((int)0, (int)0, (int)0, (double)opacity));
        this.scrim.setBlendMode(BlendMode.SRC_ATOP);
        ObservableList children = parent.getChildren();
        children.stream().filter(node -> node.equals(child)).findFirst().ifPresent(node -> {
            if (children.indexOf(node) != children.size() - 1) {
                parent.getChildren().remove(node);
                parent.getChildren().add(node);
            }
        });
        parent.getChildren().add(children.size() - 1, (Object)this.scrim);
    }

    public void scrimWindow(Window window, double opacity) {
        Parent root = window.getScene().getRoot();
        if (root instanceof Pane) {
            Pane pane = (Pane)root;
            this.scrim.widthProperty().bind((ObservableValue)pane.widthProperty());
            this.scrim.heightProperty().bind((ObservableValue)pane.heightProperty());
            this.scrim.setFill((Paint)Color.rgb((int)0, (int)0, (int)0, (double)opacity));
            this.scrim.setBlendMode(BlendMode.SRC_ATOP);
            pane.getChildren().add((Object)this.scrim);
        }
    }

    public void removeEffect(Pane pane) {
        pane.getChildren().remove((Object)this.scrim);
        this.unbindResizing();
    }

    public void removeEffect(Window window) {
        Parent root = window.getScene().getRoot();
        if (root instanceof Pane) {
            this.removeEffect((Pane)root);
            this.unbindResizing();
        }
    }

    private void unbindResizing() {
        this.scrim.widthProperty().unbind();
        this.scrim.heightProperty().unbind();
    }

    public Node getScrimNode() {
        return this.scrim;
    }
}

