/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxeffects.animations;

import io.github.palexdev.mfxeffects.animations.base.FluentTransition;
import io.github.palexdev.mfxeffects.enums.Interpolators;
import java.util.function.Consumer;
import javafx.animation.Interpolator;
import javafx.util.Duration;

public class ConsumerTransition
extends FluentTransition {
    private Consumer<Double> interpolateConsumer;

    public ConsumerTransition setInterpolateConsumer(Consumer<Double> interpolateConsumer) {
        this.interpolateConsumer = interpolateConsumer;
        return this;
    }

    public void playWithConsumer(Consumer<Double> interpolateConsumer) {
        this.setInterpolateConsumer(interpolateConsumer);
        this.play();
    }

    protected void interpolate(double frac) {
        this.interpolateConsumer.accept(frac);
    }

    public static ConsumerTransition of(Consumer<Double> interpolateConsumer) {
        return new ConsumerTransition().setInterpolateConsumer(interpolateConsumer);
    }

    public static FluentTransition of(Consumer<Double> interpolateConsumer, Duration duration) {
        return new ConsumerTransition().setInterpolateConsumer(interpolateConsumer).setDuration(duration);
    }

    public static FluentTransition of(Consumer<Double> interpolateConsumer, double duration) {
        return new ConsumerTransition().setInterpolateConsumer(interpolateConsumer).setDuration(duration);
    }

    public static FluentTransition of(Consumer<Double> interpolateConsumer, Duration duration, Interpolator interpolator) {
        return new ConsumerTransition().setInterpolateConsumer(interpolateConsumer).setDuration(duration).setInterpolatorFluent(interpolator);
    }

    public static FluentTransition of(Consumer<Double> interpolateConsumer, double duration, Interpolator interpolator) {
        return new ConsumerTransition().setInterpolateConsumer(interpolateConsumer).setDuration(duration).setInterpolatorFluent(interpolator);
    }

    public static FluentTransition of(Consumer<Double> interpolateConsumer, Duration duration, Interpolators interpolator) {
        return new ConsumerTransition().setInterpolateConsumer(interpolateConsumer).setDuration(duration).setInterpolatorFluent(interpolator.toInterpolator());
    }

    public static FluentTransition of(Consumer<Double> interpolateConsumer, double duration, Interpolators interpolator) {
        return new ConsumerTransition().setInterpolateConsumer(interpolateConsumer).setDuration(duration).setInterpolatorFluent(interpolator.toInterpolator());
    }
}

