/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxeffects.animations;

import io.github.palexdev.mfxeffects.animations.base.FluentTransition;
import java.util.function.Consumer;
import javafx.util.Duration;

public class MomentumTransition
extends FluentTransition {
    private double momentum;
    private double acceleration;
    private double displacement;
    private int direction = 1;
    private double displacementDelta;
    private double lastFrameTime;
    private Consumer<Double> onUpdate;

    protected MomentumTransition() {
        this.onUpdate = delta -> {};
    }

    public MomentumTransition(double momentum, double acceleration, double displacement) {
        this.onUpdate = delta -> {};
        assert (acceleration < 0.0);
        this.momentum = momentum;
        this.acceleration = acceleration;
        this.direction = displacement < 0.0 ? -1 : 1;
        this.displacement = Math.abs(displacement);
    }

    public static MomentumTransition fromTime(double displacement, double millis) {
        double absDisplacement;
        MomentumTransition mt = new MomentumTransition();
        mt.direction = displacement < 0.0 ? -1 : 1;
        mt.displacement = absDisplacement = Math.abs(displacement);
        mt.setCycleDuration(Duration.millis((double)millis));
        mt.momentum = MomentumTransition.timeToMomentum(absDisplacement, millis);
        mt.acceleration = MomentumTransition.momentumToDeceleration(mt.momentum, millis);
        return mt;
    }

    public static MomentumTransition fromDeceleration(double displacement, double deceleration) {
        double absDisplacement;
        assert (deceleration < 0.0);
        MomentumTransition mt = new MomentumTransition();
        mt.direction = displacement < 0.0 ? -1 : 1;
        mt.displacement = absDisplacement = Math.abs(displacement);
        mt.acceleration = deceleration;
        mt.momentum = MomentumTransition.decelerationToMomentum(absDisplacement, deceleration);
        mt.setCycleDuration(Duration.millis((double)MomentumTransition.momentumToTime(mt.momentum, deceleration)));
        return mt;
    }

    public static double timeToMomentum(double displacement, double time) {
        return 2.0 * displacement / time;
    }

    public static double momentumToDeceleration(double momentum, double time) {
        return -(momentum / time);
    }

    public static double decelerationToMomentum(double displacement, double deceleration) {
        return Math.sqrt(-2.0 * deceleration * displacement);
    }

    public static double momentumToTime(double momentum, double deceleration) {
        return -(momentum / deceleration);
    }

    protected void interpolate(double frac) {
        double deltaFrameTime = this.getDeltaFrameTime(frac);
        this.displacementDelta = this.momentum * deltaFrameTime;
        this.momentum += this.acceleration * deltaFrameTime;
        this.update();
    }

    public void update() {
        if (this.onUpdate != null) {
            this.onUpdate.accept(this.displacementDelta * (double)this.direction);
        }
    }

    private double getDeltaFrameTime(double frac) {
        double frameTime = this.getCycleDuration().toMillis() * frac;
        double deltaFrameTime = frameTime - this.lastFrameTime;
        this.lastFrameTime = frameTime;
        return deltaFrameTime;
    }

    public double getMomentum() {
        return this.momentum;
    }

    public double getAcceleration() {
        return this.acceleration;
    }

    public double getDisplacement() {
        return this.displacement;
    }

    public int getDirection() {
        return this.direction;
    }

    public Consumer<Double> getOnUpdate() {
        return this.onUpdate;
    }

    public MomentumTransition setOnUpdate(Consumer<Double> onUpdate) {
        this.onUpdate = onUpdate;
        return this;
    }
}

