/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxeffects.animations;

import io.github.palexdev.mfxeffects.animations.base.ITransitionType;
import io.github.palexdev.mfxeffects.beans.Position;
import io.github.palexdev.mfxeffects.beans.Size;
import io.github.palexdev.mfxeffects.utils.LayoutUtils;
import io.github.palexdev.mfxeffects.utils.TriFunction;
import java.util.function.Supplier;
import javafx.animation.Animation;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;

public class TransitionPane
extends StackPane {
    private final String STYLE_CLASS = "transition-pane";
    public static final PseudoClass CLOSED_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"closed");
    public static final PseudoClass OPEN_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"open");
    private final ObjectProperty<Node> closedNode = new SimpleObjectProperty<Node>(){

        public void set(Node newValue) {
            Node oldValue = (Node)this.get();
            if (oldValue != null) {
                TransitionPane.super.getChildren().remove((Object)oldValue);
            }
            if (newValue != null) {
                TransitionPane.super.getChildren().add((Object)newValue);
            }
            super.set((Object)newValue);
        }
    };
    private final ObjectProperty<Node> openNode = new SimpleObjectProperty<Node>(){

        public void set(Node newValue) {
            Node oldValue = (Node)this.get();
            if (oldValue != null) {
                TransitionPane.super.getChildren().remove((Object)oldValue);
            }
            if (newValue != null) {
                TransitionPane.super.getChildren().add((Object)newValue);
                newValue.setManaged(false);
                newValue.setVisible(false);
                newValue.setOpacity(0.0);
            }
            super.set((Object)newValue);
        }
    };
    private final ReadOnlyBooleanWrapper open = new ReadOnlyBooleanWrapper(false);
    private final ObjectProperty<Supplier<Size>> targetSize = new SimpleObjectProperty<Supplier<Size>>(){

        protected void invalidated() {
            TransitionPane.this.cachedClosedSize = null;
            TransitionPane.this.cachedOpenSize = null;
        }
    };
    private final ObjectProperty<Supplier<Position>> targetOffset = new SimpleObjectProperty(Position::origin);
    private Size cachedClosedSize;
    private Size cachedOpenSize;
    private final ObjectProperty<TriFunction<TransitionPane, Node, Node, Animation>> closeAnimationFactory = new SimpleObjectProperty();
    private final ObjectProperty<TriFunction<TransitionPane, Node, Node, Animation>> openAnimationFactory = new SimpleObjectProperty();
    private Animation cachedCloseAnimation;
    private Animation cachedOpenAnimation;

    public TransitionPane() {
        this(null, null);
    }

    public TransitionPane(Node closedNode, Node openNode) {
        this.setClosedNode(closedNode);
        this.setOpenNode(openNode);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"transition-pane");
        this.pseudoClassStateChanged(CLOSED_PSEUDO_CLASS, true);
        this.setTargetSize(() -> {
            Node node = this.getOpenNode();
            if (node == null) {
                return Size.invalid();
            }
            return Size.of(LayoutUtils.boundWidth(node), LayoutUtils.boundHeight(node));
        });
        this.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    }

    public void open() {
        if (this.isOpen()) {
            return;
        }
        Node openNode = this.getOpenNode();
        Size size = this.getOpenSize();
        if (openNode == null || Size.invalid().equals(size)) {
            return;
        }
        this.setOpen(true);
        if (this.cachedOpenAnimation == null) {
            this.cachedOpenAnimation = this.getOpenAnimationFactory().apply(this, openNode, this.getClosedNode());
        }
        if (this.cachedCloseAnimation != null) {
            this.cachedCloseAnimation.stop();
        }
        this.cachedOpenAnimation.playFromStart();
    }

    public void close() {
        if (!this.isOpen()) {
            return;
        }
        Node closedNode = this.getClosedNode();
        if (closedNode == null) {
            return;
        }
        this.getClosedSize();
        this.setOpen(false);
        if (this.cachedCloseAnimation == null) {
            this.cachedCloseAnimation = this.getCloseAnimationFactory().apply(this, this.getOpenNode(), closedNode);
        }
        if (this.cachedOpenAnimation != null) {
            this.cachedOpenAnimation.stop();
        }
        this.cachedCloseAnimation.playFromStart();
    }

    public void setAnimationType(ITransitionType type) {
        this.setOpenAnimationFactory(type::open);
        this.setCloseAnimationFactory(type::close);
    }

    public Size getOpenSize() {
        if (this.cachedOpenSize == null || Size.invalid().equals(this.cachedOpenSize)) {
            this.cachedOpenSize = this.getTargetSize().get();
        }
        return this.cachedOpenSize;
    }

    public Size getClosedSize() {
        if (this.cachedClosedSize == null || Size.invalid().equals(this.cachedClosedSize)) {
            Node closedNode = this.getClosedNode();
            this.cachedClosedSize = closedNode != null ? Size.of(LayoutUtils.boundWidth(closedNode), LayoutUtils.boundHeight(closedNode)) : Size.invalid();
        }
        return this.cachedClosedSize;
    }

    public ObservableList<Node> getChildren() {
        return this.getChildrenUnmodifiable();
    }

    protected void layoutChildren() {
        super.layoutChildren();
        Node node = this.getOpenNode();
        if (node == null) {
            return;
        }
        node.resizeRelocate(0.0, 0.0, this.getWidth(), this.getHeight());
    }

    public Node getClosedNode() {
        return (Node)this.closedNode.get();
    }

    public ObjectProperty<Node> closedNodeProperty() {
        return this.closedNode;
    }

    public void setClosedNode(Node closedNode) {
        this.closedNode.set((Object)closedNode);
    }

    public Node getOpenNode() {
        return (Node)this.openNode.get();
    }

    public ObjectProperty<Node> openNodeProperty() {
        return this.openNode;
    }

    public void setOpenNode(Node openNode) {
        this.openNode.set((Object)openNode);
    }

    public boolean isOpen() {
        return this.open.get();
    }

    public ReadOnlyBooleanProperty openProperty() {
        return this.open.getReadOnlyProperty();
    }

    protected void setOpen(boolean open) {
        this.open.set(open);
        this.pseudoClassStateChanged(CLOSED_PSEUDO_CLASS, !open);
        this.pseudoClassStateChanged(OPEN_PSEUDO_CLASS, open);
    }

    public Supplier<Size> getTargetSize() {
        return (Supplier)this.targetSize.get();
    }

    public ObjectProperty<Supplier<Size>> targetSizeProperty() {
        return this.targetSize;
    }

    public void setTargetSize(Supplier<Size> targetSize) {
        this.targetSize.set(targetSize);
    }

    public Supplier<Position> getTargetOffset() {
        return (Supplier)this.targetOffset.get();
    }

    public ObjectProperty<Supplier<Position>> targetOffsetProperty() {
        return this.targetOffset;
    }

    public void setTargetOffset(Supplier<Position> targetOffset) {
        this.targetOffset.set(targetOffset);
    }

    public TriFunction<TransitionPane, Node, Node, Animation> getCloseAnimationFactory() {
        return (TriFunction)this.closeAnimationFactory.get();
    }

    public ObjectProperty<TriFunction<TransitionPane, Node, Node, Animation>> closeAnimationFactoryProperty() {
        return this.closeAnimationFactory;
    }

    public void setCloseAnimationFactory(TriFunction<TransitionPane, Node, Node, Animation> closeAnimationFactory) {
        this.closeAnimationFactory.set(closeAnimationFactory);
    }

    public TriFunction<TransitionPane, Node, Node, Animation> getOpenAnimationFactory() {
        return (TriFunction)this.openAnimationFactory.get();
    }

    public ObjectProperty<TriFunction<TransitionPane, Node, Node, Animation>> openAnimationFactoryProperty() {
        return this.openAnimationFactory;
    }

    public void setOpenAnimationFactory(TriFunction<TransitionPane, Node, Node, Animation> openAnimationFactory) {
        this.openAnimationFactory.set(openAnimationFactory);
    }
}

