/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxeffects.animations.motion;

import io.github.palexdev.mfxeffects.animations.base.Curve;

public class ElasticInOutCurve
extends Curve {
    private final double period;

    public ElasticInOutCurve() {
        this(0.4);
    }

    public ElasticInOutCurve(double period) {
        this.period = period;
    }

    @Override
    public double curve(double t) {
        double s = this.period / 4.0;
        t = 2.0 * t - 1.0;
        double sin = Math.sin((t - s) * (Math.PI * 2) / this.period);
        if (t < 0.0) {
            return -0.5 * Math.pow(2.0, 10.0 * t) * sin;
        }
        return Math.pow(2.0, -10.0 * t) * sin * 0.5 + 1.0;
    }
}

