/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxeffects.beans;

import java.util.Objects;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;

public class Size {
    private final DoubleProperty width = new SimpleDoubleProperty(0.0);
    private final DoubleProperty height = new SimpleDoubleProperty(0.0);

    public Size(double width, double height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public static Size of(double width, double height) {
        return new Size(width, height);
    }

    public static Size empty() {
        return Size.of(0.0, 0.0);
    }

    public static Size invalid() {
        return Size.of(-1.0, -1.0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Size size = (Size)o;
        return this.getWidth() == size.getWidth() && this.getHeight() == size.getHeight();
    }

    public int hashCode() {
        return Objects.hash(this.getWidth(), this.getHeight());
    }

    public String toString() {
        return "W x H (" + this.getWidth() + " x " + this.getHeight() + ")";
    }

    public double getWidth() {
        return this.width.get();
    }

    public DoubleProperty widthProperty() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width.set(width);
    }

    public double getHeight() {
        return this.height.get();
    }

    public DoubleProperty heightProperty() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height.set(height);
    }
}

