/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxeffects.beans.properties;

import io.github.palexdev.mfxeffects.beans.Size;
import java.util.Optional;
import javafx.beans.property.ReadOnlyObjectWrapper;

public class SizeProperty
extends ReadOnlyObjectWrapper<Size> {
    public SizeProperty() {
    }

    public SizeProperty(Size initialValue) {
        super((Object)initialValue);
    }

    public SizeProperty(Object bean, String name) {
        super(bean, name);
    }

    public SizeProperty(Object bean, String name, Size initialValue) {
        super(bean, name, (Object)initialValue);
    }

    public void setSize(double w, double h) {
        this.set(Size.of(w, h));
    }

    public void setWidth(double w) {
        Optional.ofNullable((Size)this.get()).ifPresentOrElse(s -> {
            boolean changed = s.getWidth() != w;
            s.setWidth(w);
            if (changed) {
                this.invalidated();
                this.fireValueChangedEvent();
            }
        }, () -> this.setSize(w, 0.0));
    }

    public void setHeight(double h) {
        Optional.ofNullable((Size)this.get()).ifPresentOrElse(s -> {
            boolean changed = s.getHeight() != h;
            s.setHeight(h);
            if (changed) {
                this.invalidated();
                this.fireValueChangedEvent();
            }
        }, () -> this.setSize(0.0, h));
    }

    public double getWidth() {
        return Optional.ofNullable((Size)this.get()).map(Size::getWidth).orElse(-1.0);
    }

    public double getHeight() {
        return Optional.ofNullable((Size)this.get()).map(Size::getHeight).orElse(-1.0);
    }
}

