/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxeffects.beans.properties.styleable;

import io.github.palexdev.mfxeffects.beans.Position;
import java.util.Arrays;
import java.util.function.Function;
import javafx.css.CssMetaData;
import javafx.css.ParsedValue;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.scene.text.Font;

public class StyleablePositionProperty
extends SimpleStyleableObjectProperty<Position> {
    public StyleablePositionProperty(CssMetaData<? extends Styleable, Position> cssMetaData) {
        super(cssMetaData);
    }

    public StyleablePositionProperty(CssMetaData<? extends Styleable, Position> cssMetaData, Position initialValue) {
        super(cssMetaData, (Object)initialValue);
    }

    public StyleablePositionProperty(CssMetaData<? extends Styleable, Position> cssMetaData, Object bean, String name) {
        super(cssMetaData, bean, name);
    }

    public StyleablePositionProperty(CssMetaData<? extends Styleable, Position> cssMetaData, Object bean, String name, Position initialValue) {
        super(cssMetaData, bean, name, (Object)initialValue);
    }

    public void setPosition(double x, double y) {
        this.set(Position.of(x, y));
    }

    public void applyStyle(StyleOrigin origin, Position v) {
        if (v == null) {
            return;
        }
        super.applyStyle(origin, (Object)v);
    }

    public static <S extends Styleable> CssMetaData<S, Position> metaDataFor(String propId, final Function<S, StyleablePositionProperty> property, Position initialValue) {
        return new CssMetaData<S, Position>(propId, PositionConverter.getInstance(), initialValue){

            public boolean isSettable(S styleable) {
                return !((StyleablePositionProperty)((Object)property.apply(styleable))).isBound();
            }

            public StyleableProperty<Position> getStyleableProperty(S styleable) {
                return (StyleableProperty)property.apply(styleable);
            }
        };
    }

    public StyleOrigin getStyleOrigin() {
        return StyleOrigin.USER_AGENT;
    }

    public static class PositionConverter
    extends StyleConverter<String, Position> {
        public static StyleConverter<String, Position> getInstance() {
            return Holder.INSTANCE;
        }

        private PositionConverter() {
        }

        public Position convert(ParsedValue<String, Position> value, Font font) {
            try {
                double[] sizes = Arrays.stream(((String)value.getValue()).split(" ")).mapToDouble(Double::parseDouble).toArray();
                return Position.of(sizes[0], sizes[1]);
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                return null;
            }
        }

        public String toString() {
            return "PositionConverter";
        }

        private static class Holder {
            static final PositionConverter INSTANCE = new PositionConverter();

            private Holder() {
            }
        }
    }
}

