/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxeffects.enums;

import io.github.palexdev.mfxeffects.animations.Animations;
import io.github.palexdev.mfxeffects.animations.base.Curve;
import io.github.palexdev.mfxeffects.animations.motion.Motion;
import java.util.Arrays;
import javafx.animation.Interpolator;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.paint.Color;

public enum ElevationLevel {
    LEVEL0(Color.rgb((int)0, (int)0, (int)0, (double)0.0), 0.0, 0.0, 0.0, 0.0),
    LEVEL1(3.0, 0.12, 0.0, 2.0),
    LEVEL2(8.0, 0.16, 0.0, 3.0),
    LEVEL3(18.0, 0.19, 0.0, 3.0),
    LEVEL4(14.0, 0.25, 0.0, 5.0),
    LEVEL5(16.0, 0.3, 0.0, 7.0);

    private final Color color;
    private final double radius;
    private final double spread;
    private final double offsetX;
    private final double offsetY;

    private ElevationLevel(double radius, double spread, double offsetX, double offsetY) {
        this(Color.rgb((int)0, (int)0, (int)0, (double)0.2), radius, spread, offsetX, offsetY);
    }

    private ElevationLevel(Color color, double radius, double spread, double offsetX, double offsetY) {
        this.color = color;
        this.radius = radius;
        this.spread = spread;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public Color getColor() {
        return this.color;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getSpread() {
        return this.spread;
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public ElevationLevel next() {
        return ElevationLevel.values()[(this.ordinal() + 1) % ElevationLevel.values().length];
    }

    public void animateTo(DropShadow current, ElevationLevel next) {
        Curve i = Motion.EASE;
        Animations.TimelineBuilder.build().add(Animations.KeyFrames.of(1.0, current.offsetXProperty(), Double.valueOf(next.getOffsetX()), (Interpolator)i)).add(Animations.KeyFrames.of(1.0, current.offsetYProperty(), Double.valueOf(next.getOffsetY()), (Interpolator)i)).add(Animations.KeyFrames.of(250.0, current.radiusProperty(), Double.valueOf(next.getRadius()), (Interpolator)i)).add(Animations.KeyFrames.of(250.0, current.spreadProperty(), Double.valueOf(next.getSpread()), (Interpolator)i)).getAnimation().play();
    }

    public DropShadow toShadow() {
        return new DropShadow(BlurType.GAUSSIAN, this.getColor(), this.getRadius(), this.getSpread(), this.getOffsetX(), this.getOffsetY());
    }

    public static ElevationLevel from(DropShadow shadow) {
        return Arrays.stream(ElevationLevel.values()).filter(depthLevel -> ElevationLevel.levelEqualsShadow(depthLevel, shadow)).findFirst().orElse(null);
    }

    public static boolean levelEqualsShadow(ElevationLevel level, DropShadow shadow) {
        return level.color.equals((Object)shadow.getColor()) && level.offsetX == shadow.getOffsetX() && level.offsetY == shadow.getOffsetY() && level.radius == shadow.getRadius() && level.spread == shadow.getSpread();
    }
}

