/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxeffects.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.geometry.Insets;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;

public class StyleUtils {
    private StyleUtils() {
    }

    public static void updateBackground(Region region, Paint fill) {
        Background background = region.getBackground();
        if (background == null || background.getFills().isEmpty()) {
            return;
        }
        ArrayList<BackgroundFill> fills = new ArrayList<BackgroundFill>();
        for (BackgroundFill bf : background.getFills()) {
            fills.add(new BackgroundFill(fill, bf.getRadii(), bf.getInsets()));
        }
        region.setBackground(new Background((BackgroundFill[])fills.toArray(BackgroundFill[]::new)));
    }

    public static void updateBackground(Region region, Paint fill, Insets backgroundInsets) {
        Background background = region.getBackground();
        if (background == null || background.getFills().isEmpty()) {
            return;
        }
        ArrayList<BackgroundFill> fills = new ArrayList<BackgroundFill>();
        for (BackgroundFill bf : background.getFills()) {
            fills.add(new BackgroundFill(fill, bf.getRadii(), backgroundInsets));
        }
        region.setBackground(new Background((BackgroundFill[])fills.toArray(BackgroundFill[]::new)));
    }

    public static void updateBackground(Region region, Paint fill, CornerRadii cornerRadii, Insets backgroundInsets) {
        Background background = region.getBackground();
        if (background == null || background.getFills().isEmpty()) {
            return;
        }
        ArrayList<BackgroundFill> fills = new ArrayList<BackgroundFill>();
        for (BackgroundFill bf : background.getFills()) {
            fills.add(new BackgroundFill(fill, cornerRadii, backgroundInsets));
        }
        region.setBackground(new Background((BackgroundFill[])fills.toArray(BackgroundFill[]::new)));
    }

    public static void setBackground(Region region, Paint fill) {
        StyleUtils.setBackground(region, fill, CornerRadii.EMPTY, Insets.EMPTY);
    }

    public static void setBackground(Region region, Paint fill, CornerRadii radius) {
        StyleUtils.setBackground(region, fill, radius, Insets.EMPTY);
    }

    public static void setBackground(Region region, Paint fill, CornerRadii radius, Insets insets) {
        region.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(fill, radius, insets)}));
    }

    public static CornerRadii parseCornerRadius(Region region) {
        Border border;
        CornerRadii backRadius = CornerRadii.EMPTY;
        CornerRadii bordRadius = CornerRadii.EMPTY;
        Background background = region.getBackground();
        if (background != null && !background.isEmpty()) {
            backRadius = ((BackgroundFill)background.getFills().get(0)).getRadii();
        }
        if ((border = region.getBorder()) != null && !border.isEmpty()) {
            bordRadius = ((BorderStroke)border.getStrokes().get(0)).getRadii();
        }
        return !backRadius.equals((Object)CornerRadii.EMPTY) ? backRadius : bordRadius;
    }

    @SafeVarargs
    public static List<CssMetaData<? extends Styleable, ?>> cssMetaDataList(List<CssMetaData<? extends Styleable, ?>> styleable, CssMetaData<? extends Styleable, ?> ... cssMetaData) {
        CssMetaDataList styleableMetaData = new CssMetaDataList((Collection<? extends CssMetaData<? extends Styleable, ?>>)styleable);
        styleableMetaData.addAll(cssMetaData);
        return styleableMetaData.toUnmodifiable();
    }

    public static class CssMetaDataList
    extends ArrayList<CssMetaData<? extends Styleable, ?>> {
        public CssMetaDataList() {
        }

        public CssMetaDataList(Collection<? extends CssMetaData<? extends Styleable, ?>> c) {
            super(c);
        }

        @SafeVarargs
        public final boolean addAll(CssMetaData<? extends Styleable, ?> ... cssMetaData) {
            return Collections.addAll(this, cssMetaData);
        }

        public List<CssMetaData<? extends Styleable, ?>> toUnmodifiable() {
            return Collections.unmodifiableList(this);
        }
    }
}

