/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxlocalization;

import io.github.palexdev.mfxlocalization.Language;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;

public class I18N {
    private static final ObjectProperty<Locale> locale = new SimpleObjectProperty();

    public static String get(String key, Object ... args) {
        ResourceBundle bundle = I18N.getBundle(I18N.getLocale());
        return MessageFormat.format(bundle.getString(key), args);
    }

    public static String get(Language language, String key, Object ... args) {
        ResourceBundle bundle = I18N.getBundle(language.getLocale());
        return MessageFormat.format(bundle.getString(key), args);
    }

    public static String getOrDefault(String key, Object ... args) {
        ResourceBundle bundle = I18N.getBundle(I18N.getLocale());
        try {
            String s = bundle.getString(key);
            return MessageFormat.format(s, args);
        }
        catch (Exception ex) {
            return I18N.get(Language.defaultLanguage(), key, args);
        }
    }

    public static String getOrDefault(Language language, String key, Object ... args) {
        ResourceBundle bundle = I18N.getBundle(language.getLocale());
        try {
            String s = bundle.getString(key);
            return MessageFormat.format(s, args);
        }
        catch (Exception ex) {
            return I18N.get(Language.defaultLanguage(), key, args);
        }
    }

    public static String getOrDefault(String key, String def, Object ... args) {
        ResourceBundle bundle = I18N.getBundle(I18N.getLocale());
        try {
            String s = bundle.getString(key);
            return MessageFormat.format(s, args);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public static String getOrDefault(Language language, String key, String def, Object ... args) {
        ResourceBundle bundle = I18N.getBundle(language.getLocale());
        try {
            String s = bundle.getString(key);
            return MessageFormat.format(s, args);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public static StringBinding getBinding(String key, Object ... args) {
        return Bindings.createStringBinding(() -> I18N.getOrDefault(key, args), (Observable[])new Observable[]{locale});
    }

    public static StringBinding getBinding(Callable<String> callable) {
        return Bindings.createStringBinding(callable, (Observable[])new Observable[]{locale});
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle(I18N.getBundleBaseName(), locale);
    }

    public static Locale getLocale() {
        return (Locale)locale.get();
    }

    public static ObjectProperty<Locale> localeProperty() {
        return locale;
    }

    public static void setLanguage(Language language) {
        locale.set((Object)language.getLocale());
    }

    public static Language[] getSupportedLanguages() {
        return Language.values();
    }

    public static String getBundleBaseName() {
        return "io.github.palexdev.mfxlocalization.mfxlang";
    }

    static {
        I18N.setLanguage(Language.defaultLanguage());
        locale.addListener(invalidated -> Locale.setDefault(I18N.getLocale()));
    }
}

