/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxresources.builders;

import io.github.palexdev.mfxresources.builders.IconWrapperBuilder;
import io.github.palexdev.mfxresources.fonts.IconsProviders;
import io.github.palexdev.mfxresources.fonts.MFXFontIcon;
import java.util.function.Function;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.NodeOrientation;
import javafx.scene.CacheHint;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.effect.Effect;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;

public class IconBuilder {
    protected final MFXFontIcon icon;

    public IconBuilder() {
        this.icon = new MFXFontIcon();
    }

    public IconBuilder(MFXFontIcon icon) {
        this.icon = icon;
    }

    public static IconBuilder build() {
        return new IconBuilder();
    }

    public static IconBuilder build(MFXFontIcon icon) {
        return new IconBuilder(icon);
    }

    public IconBuilder setColor(Color color) {
        this.icon.setColor(color);
        return this;
    }

    public IconBuilder setDescription(String code) {
        this.icon.setDescription(code);
        return this;
    }

    public IconBuilder setSize(double size) {
        this.icon.setSize(size);
        return this;
    }

    public IconBuilder setIconsProvider(IconsProviders provider) {
        this.icon.setIconsProvider(provider);
        return this;
    }

    public IconBuilder setIconsProvider(Font font, Function<String, Character> converter) {
        this.icon.setIconsProvider(font, converter);
        return this;
    }

    public IconBuilder setDescriptionConverter(Function<String, Character> descriptionConverter) {
        this.icon.setDescriptionConverter(descriptionConverter);
        return this;
    }

    public IconWrapperBuilder wrap() {
        return new IconWrapperBuilder(this.icon.wrap());
    }

    public IconBuilder setId(String id) {
        this.icon.setId(id);
        return this;
    }

    public IconBuilder setStyle(String style) {
        this.icon.setStyle(style);
        return this;
    }

    public IconBuilder addStyleClasses(String ... styleClasses) {
        this.icon.getStyleClass().addAll((Object[])styleClasses);
        return this;
    }

    public IconBuilder setStyleClasses(String ... styleClasses) {
        this.icon.getStyleClass().setAll((Object[])styleClasses);
        return this;
    }

    public IconBuilder pseudoClassStateChanged(PseudoClass pseudoClass, boolean active) {
        this.icon.pseudoClassStateChanged(pseudoClass, active);
        return this;
    }

    public IconBuilder setVisible(boolean visible) {
        this.icon.setVisible(visible);
        return this;
    }

    public IconBuilder setCursor(Cursor cursor) {
        this.icon.setCursor(cursor);
        return this;
    }

    public IconBuilder setOpacity(double opacity) {
        this.icon.setOpacity(opacity);
        return this;
    }

    public IconBuilder setClip(Node clip) {
        this.icon.setClip(clip);
        return this;
    }

    public IconBuilder setCache(boolean cache) {
        this.icon.setCache(cache);
        return this;
    }

    public IconBuilder setCacheHint(CacheHint cacheHint) {
        this.icon.setCacheHint(cacheHint);
        return this;
    }

    public IconBuilder setEffect(Effect effect) {
        this.icon.setEffect(effect);
        return this;
    }

    public IconBuilder setDisable(boolean disable) {
        this.icon.setDisable(disable);
        return this;
    }

    public IconBuilder setManaged(boolean managed) {
        this.icon.setManaged(managed);
        return this;
    }

    public IconBuilder relocate(double x, double y) {
        this.icon.relocate(x, y);
        return this;
    }

    public IconBuilder resize(double width, double height) {
        this.icon.resize(width, height);
        return this;
    }

    public IconBuilder resizeRelocate(double x, double y, double width, double height) {
        this.icon.resizeRelocate(x, y, width, height);
        return this;
    }

    public IconBuilder autosize() {
        this.icon.autosize();
        return this;
    }

    public IconBuilder setViewOrder(double viewOrder) {
        this.icon.setViewOrder(viewOrder);
        return this;
    }

    public IconBuilder setTranslateX(double translateX) {
        this.icon.setTranslateX(translateX);
        return this;
    }

    public IconBuilder setTranslateY(double translateY) {
        this.icon.setTranslateY(translateY);
        return this;
    }

    public IconBuilder setTranslateZ(double translateZ) {
        this.icon.setTranslateZ(translateZ);
        return this;
    }

    public IconBuilder setScaleX(double scaleX) {
        this.icon.setScaleX(scaleX);
        return this;
    }

    public IconBuilder setScaleY(double scaleY) {
        this.icon.setScaleY(scaleY);
        return this;
    }

    public IconBuilder setScaleZ(double scaleZ) {
        this.icon.setScaleZ(scaleZ);
        return this;
    }

    public IconBuilder setRotate(double rotate) {
        this.icon.setRotate(rotate);
        return this;
    }

    public IconBuilder setNodeOrientation(NodeOrientation orientation) {
        this.icon.setNodeOrientation(orientation);
        return this;
    }

    public IconBuilder setMouseTransparent(boolean mouseTransparent) {
        this.icon.setMouseTransparent(mouseTransparent);
        return this;
    }

    public IconBuilder setFocusTraversable(boolean focusTraversable) {
        this.icon.setFocusTraversable(focusTraversable);
        return this;
    }

    public IconBuilder requestFocus() {
        this.icon.requestFocus();
        return this;
    }

    public <T extends Event> IconBuilder addEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.icon.addEventHandler(eventType, eventHandler);
        return this;
    }

    public <T extends Event> IconBuilder removeEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.icon.removeEventHandler(eventType, eventHandler);
        return this;
    }

    public <T extends Event> IconBuilder addEventFilter(EventType<T> eventType, EventHandler<? super T> eventFilter) {
        this.icon.addEventFilter(eventType, eventFilter);
        return this;
    }

    public <T extends Event> IconBuilder removeEventFilter(EventType<T> eventType, EventHandler<? super T> eventFilter) {
        this.icon.removeEventFilter(eventType, eventFilter);
        return this;
    }

    public MFXFontIcon get() {
        return this.icon;
    }
}

