/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxresources.fonts;

import io.github.palexdev.mfxresources.MFXResources;
import io.github.palexdev.mfxresources.fonts.IconProvider;
import io.github.palexdev.mfxresources.fonts.MFXFontIcon;
import io.github.palexdev.mfxresources.fonts.fontawesome.FontAwesomeBrands;
import io.github.palexdev.mfxresources.fonts.fontawesome.FontAwesomeRegular;
import io.github.palexdev.mfxresources.fonts.fontawesome.FontAwesomeSolid;
import io.github.palexdev.mfxresources.utils.EnumUtils;
import java.io.InputStream;
import java.util.function.Function;
import javafx.scene.paint.Color;

public enum IconsProviders implements IconProvider
{
    FONTAWESOME_BRANDS("FontAwesome/brands/FontAwesomeBrands.ttf", FontAwesomeBrands::toCode),
    FONTAWESOME_REGULAR("FontAwesome/regular/FontAwesomeRegular.ttf", FontAwesomeRegular::toCode),
    FONTAWESOME_SOLID("FontAwesome/solid/FontAwesomeSolid.ttf", FontAwesomeSolid::toCode);

    private final String font;
    private final Function<String, Character> converter;

    private IconsProviders(String font, Function<String, Character> converter) {
        this.font = font;
        this.converter = converter;
    }

    @Override
    public String getFontPath() {
        return this.font;
    }

    @Override
    public Function<String, Character> getConverter() {
        return this.converter;
    }

    @Override
    public InputStream load() {
        return MFXResources.loadFont(this.font);
    }

    public MFXFontIcon randomIcon(double size, Color color) {
        String desc;
        MFXFontIcon icon = new MFXFontIcon();
        switch (this) {
            case FONTAWESOME_BRANDS: {
                icon.setIconsProvider(FONTAWESOME_BRANDS);
                desc = EnumUtils.randomEnum(FontAwesomeBrands.class).getDescription();
                break;
            }
            case FONTAWESOME_REGULAR: {
                icon.setIconsProvider(FONTAWESOME_REGULAR);
                desc = EnumUtils.randomEnum(FontAwesomeRegular.class).getDescription();
                break;
            }
            case FONTAWESOME_SOLID: {
                icon.setIconsProvider(FONTAWESOME_SOLID);
                desc = EnumUtils.randomEnum(FontAwesomeSolid.class).getDescription();
                break;
            }
            default: {
                return icon;
            }
        }
        icon.setDescription(desc);
        icon.setColor(color);
        icon.setSize(size);
        return icon;
    }

    public MFXFontIcon randomIcon() {
        String desc;
        MFXFontIcon icon = new MFXFontIcon();
        switch (this) {
            case FONTAWESOME_BRANDS: {
                icon.setIconsProvider(FONTAWESOME_BRANDS);
                desc = EnumUtils.randomEnum(FontAwesomeBrands.class).getDescription();
                break;
            }
            case FONTAWESOME_REGULAR: {
                icon.setIconsProvider(FONTAWESOME_REGULAR);
                desc = EnumUtils.randomEnum(FontAwesomeRegular.class).getDescription();
                break;
            }
            case FONTAWESOME_SOLID: {
                icon.setIconsProvider(FONTAWESOME_SOLID);
                desc = EnumUtils.randomEnum(FontAwesomeSolid.class).getDescription();
                break;
            }
            default: {
                return icon;
            }
        }
        icon.setDescription(desc);
        return icon;
    }

    public static MFXFontIcon randomIcon(IconsProviders provider, double size, Color color) {
        return provider.randomIcon(size, color);
    }

    public static MFXFontIcon randomIcon(IconsProviders provider) {
        return provider.randomIcon();
    }

    public static IconsProviders defaultProvider() {
        return FONTAWESOME_SOLID;
    }
}

