/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxresources.fonts;

import io.github.palexdev.mfxeffects.beans.Position;
import io.github.palexdev.mfxeffects.ripple.MFXRippleGenerator;
import io.github.palexdev.mfxresources.base.properties.IconProperty;
import io.github.palexdev.mfxresources.fonts.IconProvider;
import io.github.palexdev.mfxresources.fonts.MFXFontIcon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Circle;
import javafx.scene.text.Font;

public class MFXIconWrapper
extends StackPane {
    private final String STYLE_CLASS = "mfx-icon-wrapper";
    private final IconProperty icon = new IconProperty();
    private MFXRippleGenerator rg;
    private EventHandler<MouseEvent> pressHandler;
    private EventHandler<MouseEvent> releaseHandler;
    private EventHandler<MouseEvent> exitHandler;
    private final StyleableDoubleProperty size = new SimpleStyleableDoubleProperty(StyleableProperties.SIZE, (Object)this, "size", -1.0){

        public StyleOrigin getStyleOrigin() {
            return StyleOrigin.USER_AGENT;
        }
    };
    private final StyleableBooleanProperty enableRipple = new SimpleStyleableBooleanProperty(StyleableProperties.ENABLE_RIPPLE, (Object)this, "enableRipple", false){

        protected void invalidated() {
            boolean state = this.get();
            if (!state && MFXIconWrapper.this.rg != null) {
                MFXIconWrapper.this.enableRippleGenerator(false);
            }
            if (state && MFXIconWrapper.this.rg == null) {
                MFXIconWrapper.this.enableRippleGenerator(true);
            }
        }

        public StyleOrigin getStyleOrigin() {
            return StyleOrigin.USER_AGENT;
        }
    };
    private final StyleableBooleanProperty round = new SimpleStyleableBooleanProperty(StyleableProperties.ROUND, (Object)this, "round", false){

        protected void invalidated() {
            boolean state = this.get();
            MFXIconWrapper.this.makeRound(state);
        }

        public StyleOrigin getStyleOrigin() {
            return StyleOrigin.USER_AGENT;
        }
    };

    public MFXIconWrapper() {
        this(new MFXFontIcon(), -1.0);
    }

    public MFXIconWrapper(MFXFontIcon icon) {
        this(icon, -1.0);
    }

    public MFXIconWrapper(MFXFontIcon icon, double size) {
        this.initialize();
        this.setIcon(icon);
        this.setSize(size);
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-icon-wrapper");
        this.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.addEventHandler(MouseEvent.MOUSE_PRESSED, e -> this.requestFocus());
        this.icon.addListener((observable, oldValue, newValue) -> {
            super.getChildren().remove((Object)oldValue);
            this.manageChildren();
        });
        this.size.addListener((observable, oldValue, newValue) -> this.setPrefSize(newValue.doubleValue(), newValue.doubleValue()));
    }

    public MFXIconWrapper enableRippleGenerator(boolean enable) {
        return this.enableRippleGenerator(enable, e -> Position.of((double)e.getX(), (double)e.getY()));
    }

    public MFXIconWrapper enableRippleGenerator(boolean enable, Function<MouseEvent, Position> positionFunction) {
        if (!enable) {
            if (this.rg != null && this.pressHandler != null) {
                this.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.pressHandler);
                this.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.releaseHandler);
                this.removeEventHandler(MouseEvent.MOUSE_EXITED, this.exitHandler);
                super.getChildren().remove((Object)this.rg);
                this.rg = null;
            }
            return this;
        }
        if (this.rg != null) {
            throw new IllegalStateException("Ripple generator has already been enabled for this icon!");
        }
        if (this.pressHandler == null) {
            this.pressHandler = e -> {
                if (e.getButton() == MouseButton.PRIMARY) {
                    this.rg.generate(e);
                }
            };
            this.releaseHandler = e -> this.rg.release();
            this.exitHandler = e -> this.rg.release();
        }
        this.rg = new MFXRippleGenerator((Region)this);
        this.rg.setMeToPosConverter(positionFunction);
        this.addEventHandler(MouseEvent.MOUSE_PRESSED, this.pressHandler);
        this.addEventHandler(MouseEvent.MOUSE_RELEASED, this.releaseHandler);
        this.addEventHandler(MouseEvent.MOUSE_EXITED, this.exitHandler);
        this.manageChildren();
        this.setEnableRipple(true);
        return this;
    }

    public MFXIconWrapper makeRound(boolean state) {
        if (!state) {
            this.setClip(null);
            return this;
        }
        Node clip = this.getClip();
        if (clip != null) {
            return this;
        }
        Circle circle = new Circle();
        circle.radiusProperty().bind((ObservableValue)this.widthProperty().divide(2.0));
        circle.centerXProperty().bind((ObservableValue)this.widthProperty().divide(2.0));
        circle.centerYProperty().bind((ObservableValue)this.heightProperty().divide(2.0));
        this.setClip((Node)circle);
        this.setRound(true);
        return this;
    }

    public MFXIconWrapper makeRound(boolean state, double radius) {
        if (!state) {
            this.setClip(null);
            return this;
        }
        Node clip = this.getClip();
        if (clip != null) {
            return this;
        }
        Circle circle = new Circle(radius);
        circle.centerXProperty().bind((ObservableValue)this.widthProperty().divide(2.0));
        circle.centerYProperty().bind((ObservableValue)this.heightProperty().divide(2.0));
        this.setClip((Node)circle);
        this.setRound(true);
        return this;
    }

    private void manageChildren() {
        ObservableList children = super.getChildren();
        children.clear();
        MFXFontIcon icon = this.getIcon();
        if (this.rg != null) {
            children.add((Object)this.rg);
        }
        if (icon != null) {
            children.add((Object)icon);
        }
    }

    public ObservableList<Node> getChildren() {
        return this.getChildrenUnmodifiable();
    }

    protected void layoutChildren() {
        super.layoutChildren();
        MFXFontIcon icon = this.getIcon();
        if (icon != null && icon.getDescription() != null && !icon.getDescription().isBlank() && this.getSize() == -1.0) {
            double iW = icon.prefWidth(-1.0);
            double iH = icon.prefHeight(-1.0);
            double size = Math.max(this.snappedLeftInset() + iW + this.snappedRightInset(), this.snappedTopInset() + iH + this.snappedBottomInset());
            this.setSize(size);
        }
    }

    public double getSize() {
        return this.size.get();
    }

    public StyleableDoubleProperty sizeProperty() {
        return this.size;
    }

    public MFXIconWrapper setSize(double size) {
        this.size.set(size);
        return this;
    }

    public boolean isEnableRipple() {
        return this.enableRipple.get();
    }

    public StyleableBooleanProperty enableRippleProperty() {
        return this.enableRipple;
    }

    public MFXIconWrapper setEnableRipple(boolean enableRipple) {
        this.enableRipple.set(enableRipple);
        return this;
    }

    public boolean isRound() {
        return this.round.get();
    }

    public StyleableBooleanProperty roundProperty() {
        return this.round;
    }

    public MFXIconWrapper setRound(boolean round) {
        this.round.set(round);
        return this;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.cssMetaDataList;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return MFXIconWrapper.getClassCssMetaData();
    }

    public MFXRippleGenerator getRippleGenerator() {
        return this.rg;
    }

    public MFXFontIcon getIcon() {
        return (MFXFontIcon)((Object)this.icon.get());
    }

    public IconProperty iconProperty() {
        return this.icon;
    }

    public MFXIconWrapper setIcon(MFXFontIcon icon) {
        this.icon.set((Object)icon);
        return this;
    }

    public MFXIconWrapper setIcon(String desc) {
        this.setIcon(new MFXFontIcon(desc));
        return this;
    }

    public MFXIconWrapper setIcon(IconProvider provider, String desc) {
        this.setIcon(new MFXFontIcon().setIconsProvider(provider).setDescription(desc));
        return this;
    }

    public MFXIconWrapper setIcon(Font font, Function<String, Character> converter, String desc) {
        this.setIcon(new MFXFontIcon().setIconsProvider(font, converter).setDescription(desc));
        return this;
    }

    private static class StyleableProperties {
        private static final StyleablePropertyFactory<MFXIconWrapper> FACTORY = new StyleablePropertyFactory(StackPane.getClassCssMetaData());
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<MFXIconWrapper, Number> SIZE;
        private static final CssMetaData<MFXIconWrapper, Boolean> ENABLE_RIPPLE;
        private static final CssMetaData<MFXIconWrapper, Boolean> ROUND;

        private StyleableProperties() {
        }

        static {
            SIZE = FACTORY.createSizeCssMetaData("-mfx-size", MFXIconWrapper::sizeProperty, (Number)-1.0);
            ENABLE_RIPPLE = FACTORY.createBooleanCssMetaData("-mfx-enable-ripple", MFXIconWrapper::enableRippleProperty, false);
            ROUND = FACTORY.createBooleanCssMetaData("-mfx-round", MFXIconWrapper::roundProperty, false);
            ArrayList data = new ArrayList(StackPane.getClassCssMetaData());
            Collections.addAll(data, SIZE, ENABLE_RIPPLE, ROUND);
            cssMetaDataList = List.copyOf(data);
        }
    }
}

