/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxresources.utils;

import java.util.Random;

public class EnumUtils {
    public static final Random rng = new Random(System.currentTimeMillis());

    private EnumUtils() {
    }

    public static <E extends Enum<E>> E valueOfIgnoreCase(Class<E> clazz, String name) {
        Enum enumeration = null;
        for (Enum e : (Enum[])clazz.getEnumConstants()) {
            if (!e.name().equalsIgnoreCase(name)) continue;
            enumeration = e;
        }
        if (enumeration == null) {
            throw new IllegalArgumentException("No enum constant " + clazz.getCanonicalName() + "." + name);
        }
        return (E)enumeration;
    }

    public static <E extends Enum<E>> E next(Class<E> clazz, E val) {
        Enum[] values = (Enum[])clazz.getEnumConstants();
        return (E)values[(val.ordinal() + 1) % values.length];
    }

    public static <E extends Enum<E>> E previous(Class<E> clazz, E val) {
        Enum[] values = (Enum[])clazz.getEnumConstants();
        return (E)values[(val.ordinal() - 1 + values.length) % values.length];
    }

    public static <E extends Enum<E>> E randomEnum(Class<E> clazz) {
        Enum[] vals = (Enum[])clazz.getEnumConstants();
        return (E)vals[rng.nextInt(vals.length)];
    }
}

