/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxresources.builders;

import io.github.palexdev.mfxeffects.beans.Position;
import io.github.palexdev.mfxresources.fonts.IconDescriptor;
import io.github.palexdev.mfxresources.fonts.IconsProviders;
import io.github.palexdev.mfxresources.fonts.MFXFontIcon;
import io.github.palexdev.mfxresources.fonts.MFXIconWrapper;
import java.util.function.Function;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.NodeOrientation;
import javafx.scene.CacheHint;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.effect.Effect;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;

public class IconWrapperBuilder {
    protected final MFXIconWrapper wrapper;

    public IconWrapperBuilder() {
        this.wrapper = new MFXIconWrapper();
    }

    public IconWrapperBuilder(MFXIconWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public static IconWrapperBuilder build() {
        return new IconWrapperBuilder();
    }

    public static IconWrapperBuilder build(MFXIconWrapper wrapper) {
        return new IconWrapperBuilder(wrapper);
    }

    public IconWrapperBuilder enableRippleGenerator(boolean enable) {
        this.wrapper.enableRippleGenerator(enable);
        return this;
    }

    public IconWrapperBuilder enableRippleGenerator(boolean enable, Function<MouseEvent, Position> positionFunction) {
        this.wrapper.enableRippleGenerator(enable, positionFunction);
        return this;
    }

    public IconWrapperBuilder makeRound(boolean state) {
        this.wrapper.makeRound(state);
        return this;
    }

    public IconWrapperBuilder makeRound(boolean state, double radius) {
        this.wrapper.makeRound(state, radius);
        return this;
    }

    public IconWrapperBuilder setSize(double size) {
        this.wrapper.setSize(size);
        return this;
    }

    public IconWrapperBuilder setIcon(MFXFontIcon icon) {
        this.wrapper.setIcon(icon);
        return this;
    }

    public IconWrapperBuilder setIcon(String desc) {
        this.wrapper.setIcon(desc);
        return this;
    }

    public IconWrapperBuilder setIcon(IconsProviders provider, String desc) {
        this.wrapper.setIcon(provider, desc);
        return this;
    }

    public IconWrapperBuilder setIcon(Font font, Function<String, Character> converter, String desc) {
        this.wrapper.setIcon(font, converter, desc);
        return this;
    }

    public MFXIconWrapper setAnimated(boolean animated) {
        return this.wrapper.setAnimated(animated);
    }

    public MFXIconWrapper setIcon(IconDescriptor descriptor) {
        return this.wrapper.setIcon(descriptor);
    }

    public MFXIconWrapper setAnimationProvider(MFXIconWrapper.AnimationPresets preset) {
        return this.wrapper.setAnimationProvider(preset);
    }

    public IconWrapperBuilder setId(String id) {
        this.wrapper.setId(id);
        return this;
    }

    public IconWrapperBuilder setStyle(String style) {
        this.wrapper.setStyle(style);
        return this;
    }

    public IconWrapperBuilder addStyleClasses(String ... styleClasses) {
        this.wrapper.getStyleClass().addAll((Object[])styleClasses);
        return this;
    }

    public IconWrapperBuilder setStyleClasses(String ... styleClasses) {
        this.wrapper.getStyleClass().setAll((Object[])styleClasses);
        return this;
    }

    public IconWrapperBuilder pseudoClassStateChanged(PseudoClass pseudoClass, boolean active) {
        this.wrapper.pseudoClassStateChanged(pseudoClass, active);
        return this;
    }

    public IconWrapperBuilder setVisible(boolean visible) {
        this.wrapper.setVisible(visible);
        return this;
    }

    public IconWrapperBuilder setCursor(Cursor cursor) {
        this.wrapper.setCursor(cursor);
        return this;
    }

    public IconWrapperBuilder setOpacity(double opacity) {
        this.wrapper.setOpacity(opacity);
        return this;
    }

    public IconWrapperBuilder setClip(Node clip) {
        this.wrapper.setClip(clip);
        return this;
    }

    public IconWrapperBuilder setCache(boolean cache) {
        this.wrapper.setCache(cache);
        return this;
    }

    public IconWrapperBuilder setCacheHint(CacheHint cacheHint) {
        this.wrapper.setCacheHint(cacheHint);
        return this;
    }

    public IconWrapperBuilder setEffect(Effect effect) {
        this.wrapper.setEffect(effect);
        return this;
    }

    public IconWrapperBuilder setDisable(boolean disable) {
        this.wrapper.setDisable(disable);
        return this;
    }

    public IconWrapperBuilder setManaged(boolean managed) {
        this.wrapper.setManaged(managed);
        return this;
    }

    public IconWrapperBuilder relocate(double x, double y) {
        this.wrapper.relocate(x, y);
        return this;
    }

    public IconWrapperBuilder resize(double width, double height) {
        this.wrapper.resize(width, height);
        return this;
    }

    public IconWrapperBuilder resizeRelocate(double x, double y, double width, double height) {
        this.wrapper.resizeRelocate(x, y, width, height);
        return this;
    }

    public IconWrapperBuilder autosize() {
        this.wrapper.autosize();
        return this;
    }

    public IconWrapperBuilder setViewOrder(double viewOrder) {
        this.wrapper.setViewOrder(viewOrder);
        return this;
    }

    public IconWrapperBuilder setTranslateX(double translateX) {
        this.wrapper.setTranslateX(translateX);
        return this;
    }

    public IconWrapperBuilder setTranslateY(double translateY) {
        this.wrapper.setTranslateY(translateY);
        return this;
    }

    public IconWrapperBuilder setTranslateZ(double translateZ) {
        this.wrapper.setTranslateZ(translateZ);
        return this;
    }

    public IconWrapperBuilder setScaleX(double scaleX) {
        this.wrapper.setScaleX(scaleX);
        return this;
    }

    public IconWrapperBuilder setScaleY(double scaleY) {
        this.wrapper.setScaleY(scaleY);
        return this;
    }

    public IconWrapperBuilder setScaleZ(double scaleZ) {
        this.wrapper.setScaleZ(scaleZ);
        return this;
    }

    public IconWrapperBuilder setRotate(double rotate) {
        this.wrapper.setRotate(rotate);
        return this;
    }

    public IconWrapperBuilder setNodeOrientation(NodeOrientation orientation) {
        this.wrapper.setNodeOrientation(orientation);
        return this;
    }

    public IconWrapperBuilder setMouseTransparent(boolean mouseTransparent) {
        this.wrapper.setMouseTransparent(mouseTransparent);
        return this;
    }

    public IconWrapperBuilder setFocusTraversable(boolean focusTraversable) {
        this.wrapper.setFocusTraversable(focusTraversable);
        return this;
    }

    public IconWrapperBuilder requestFocus() {
        this.wrapper.requestFocus();
        return this;
    }

    public <T extends Event> IconWrapperBuilder addEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.wrapper.addEventHandler(eventType, eventHandler);
        return this;
    }

    public <T extends Event> IconWrapperBuilder removeEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.wrapper.removeEventHandler(eventType, eventHandler);
        return this;
    }

    public <T extends Event> IconWrapperBuilder addEventFilter(EventType<T> eventType, EventHandler<? super T> eventFilter) {
        this.wrapper.addEventFilter(eventType, eventFilter);
        return this;
    }

    public <T extends Event> IconWrapperBuilder removeEventFilter(EventType<T> eventType, EventHandler<? super T> eventFilter) {
        this.wrapper.removeEventFilter(eventType, eventFilter);
        return this;
    }

    public MFXIconWrapper get() {
        return this.wrapper;
    }
}

