/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxresources.fonts;

import io.github.palexdev.mfxresources.MFXResources;
import io.github.palexdev.mfxresources.fonts.IconProvider;
import io.github.palexdev.mfxresources.fonts.fontawesome.FontAwesomeBrands;
import io.github.palexdev.mfxresources.fonts.fontawesome.FontAwesomeRegular;
import io.github.palexdev.mfxresources.fonts.fontawesome.FontAwesomeSolid;
import java.io.InputStream;
import java.util.function.Function;

public enum IconsProviders implements IconProvider
{
    FONTAWESOME_BRANDS("FontAwesome/brands/FontAwesomeBrands.ttf", FontAwesomeBrands::toCode),
    FONTAWESOME_REGULAR("FontAwesome/regular/FontAwesomeRegular.ttf", FontAwesomeRegular::toCode),
    FONTAWESOME_SOLID("FontAwesome/solid/FontAwesomeSolid.ttf", FontAwesomeSolid::toCode);

    private final String font;
    private final Function<String, Character> converter;

    private IconsProviders(String font, Function<String, Character> converter) {
        this.font = font;
        this.converter = converter;
    }

    @Override
    public String getFontPath() {
        return this.font;
    }

    @Override
    public Function<String, Character> getConverter() {
        return this.converter;
    }

    @Override
    public InputStream load() {
        return MFXResources.loadFont(this.font);
    }

    public static IconsProviders defaultProvider() {
        return FONTAWESOME_SOLID;
    }
}

