/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxresources.fonts;

import io.github.palexdev.mfxresources.builders.IconWrapperBuilder;
import io.github.palexdev.mfxresources.fonts.IconDescriptor;
import io.github.palexdev.mfxresources.fonts.IconProvider;
import io.github.palexdev.mfxresources.fonts.IconsProviders;
import io.github.palexdev.mfxresources.fonts.MFXIconWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.SimpleStyleableStringProperty;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.css.StyleableStringProperty;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class MFXFontIcon
extends Text
implements Cloneable {
    private final String STYLE_CLASS = "mfx-font-icon";
    private final ObjectProperty<Function<String, Character>> descriptionConverter = new SimpleObjectProperty();
    private final StyleableObjectProperty<Color> color = new SimpleStyleableObjectProperty<Color>(StyleableProperties.COLOR, (Object)this, "color", Color.web((String)"#454545")){

        public StyleOrigin getStyleOrigin() {
            return StyleOrigin.USER_AGENT;
        }
    };
    private final StyleableStringProperty description = new SimpleStyleableStringProperty(StyleableProperties.DESCRIPTION, this, "description"){

        public StyleOrigin getStyleOrigin() {
            return StyleOrigin.USER_AGENT;
        }
    };
    private final StyleableDoubleProperty size = new SimpleStyleableDoubleProperty(StyleableProperties.SIZE, this, "size", 16.0){

        protected void invalidated() {
            double size = this.get();
            MFXFontIcon.this.setFontSize(size);
        }

        public StyleOrigin getStyleOrigin() {
            return StyleOrigin.USER_AGENT;
        }
    };

    public MFXFontIcon() {
        this((String)null);
    }

    public MFXFontIcon(IconDescriptor icon) {
        this(icon.getDescription());
    }

    public MFXFontIcon(IconDescriptor icon, Color color) {
        this(icon.getDescription(), color);
    }

    public MFXFontIcon(IconDescriptor icon, double size) {
        this(icon.getDescription(), size);
    }

    public MFXFontIcon(IconDescriptor icon, double size, Color color) {
        this(icon.getDescription(), size, color);
    }

    public MFXFontIcon(String description) {
        this(description, 16.0);
    }

    public MFXFontIcon(String description, Color color) {
        this(description, 16.0, color);
    }

    public MFXFontIcon(String description, double size) {
        this(description, size, Color.web((String)"#454545"));
    }

    public MFXFontIcon(String description, double size, Color color) {
        this.setSize(size);
        this.initialize();
        this.setDescription(description);
        this.setFont(Font.font((String)this.getFont().getFamily(), (double)size));
        this.setColor(color);
    }

    public static IconsProviders defaultProvider() {
        return IconsProviders.defaultProvider();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-font-icon");
        this.setIconsProvider(MFXFontIcon.defaultProvider());
        this.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            String desc = this.getDescription();
            return desc != null && !desc.isBlank() ? this.descToCode(desc) : "";
        }, (Observable[])new Observable[]{this.descriptionProperty(), this.fontProperty()}));
        this.fillProperty().bind(this.colorProperty());
    }

    public MFXFontIcon setIconsProvider(IconProvider provider) {
        this.setDescription("");
        this.setDescriptionConverter(provider.getConverter());
        this.setFont(provider.loadFont());
        this.setFontSize(this.getSize());
        return this;
    }

    public MFXFontIcon setIconsProvider(Font font, Function<String, Character> converter) {
        this.setDescription("");
        this.setDescriptionConverter(converter);
        this.setFont(font);
        this.setSize(font.getSize());
        return this;
    }

    public String descToCode(String desc) {
        return String.valueOf(this.getDescriptionConverter().apply(desc));
    }

    public String symbolToCode() {
        String text = this.getText();
        if (text.isEmpty()) {
            return "\u0000";
        }
        return "\\u" + Integer.toHexString(this.getText().charAt(0) | 0x10000).substring(1).toUpperCase();
    }

    public MFXIconWrapper wrap() {
        return new MFXIconWrapper(this);
    }

    public IconWrapperBuilder wrapperBuilder() {
        return new IconWrapperBuilder(this.wrap());
    }

    private void setFontSize(double size) {
        String family = this.getFont().getFamily();
        this.setFont(Font.font((String)family, (double)size));
    }

    public Color getColor() {
        return (Color)this.color.get();
    }

    public StyleableObjectProperty<Color> colorProperty() {
        return this.color;
    }

    public MFXFontIcon setColor(Color color) {
        this.color.set((Object)color);
        return this;
    }

    public String getDescription() {
        return this.description.get();
    }

    public StyleableStringProperty descriptionProperty() {
        return this.description;
    }

    public MFXFontIcon setDescription(String code) {
        this.description.set(code);
        return this;
    }

    public MFXFontIcon setDescription(IconDescriptor description) {
        this.description.set(description.getDescription());
        return this;
    }

    public double getSize() {
        return this.size.get();
    }

    public StyleableDoubleProperty sizeProperty() {
        return this.size;
    }

    public MFXFontIcon setSize(double size) {
        this.size.set(size);
        return this;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.cssMetaDataList;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return MFXFontIcon.getClassCssMetaData();
    }

    protected MFXFontIcon clone() {
        MFXFontIcon clone = new MFXFontIcon();
        clone.setDescriptionConverter(this.getDescriptionConverter());
        clone.setDescription(this.getDescription());
        clone.setSize(this.getSize());
        clone.setColor(this.getColor());
        return clone;
    }

    public String toString() {
        return "MFXFontIcon{description=" + this.getDescription() + ", code=" + this.symbolToCode() + ", color=" + String.valueOf(this.getColor()) + ", size=" + this.getSize() + "}";
    }

    public Function<String, Character> getDescriptionConverter() {
        return (Function)this.descriptionConverter.get();
    }

    public ObjectProperty<Function<String, Character>> descriptionConverterProperty() {
        return this.descriptionConverter;
    }

    public void setDescriptionConverter(Function<String, Character> descriptionConverter) {
        this.descriptionConverter.set(descriptionConverter);
    }

    private static class StyleableProperties {
        private static final StyleablePropertyFactory<MFXFontIcon> FACTORY = new StyleablePropertyFactory(Text.getClassCssMetaData());
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<MFXFontIcon, Color> COLOR;
        private static final CssMetaData<MFXFontIcon, String> DESCRIPTION;
        private static final CssMetaData<MFXFontIcon, Number> SIZE;

        private StyleableProperties() {
        }

        static {
            COLOR = FACTORY.createColorCssMetaData("-mfx-color", MFXFontIcon::colorProperty, Color.web((String)"#454545"));
            DESCRIPTION = FACTORY.createStringCssMetaData("-mfx-description", MFXFontIcon::descriptionProperty);
            SIZE = FACTORY.createSizeCssMetaData("-mfx-size", MFXFontIcon::sizeProperty, (Number)16.0);
            ArrayList txtMetadata = new ArrayList(Text.getClassCssMetaData());
            Collections.addAll(txtMetadata, COLOR, DESCRIPTION, SIZE);
            cssMetaDataList = List.copyOf(txtMetadata);
        }
    }
}

