/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.mfxresources.fonts;

import io.github.palexdev.mfxeffects.animations.AnimationFactory;
import io.github.palexdev.mfxeffects.animations.Animations;
import io.github.palexdev.mfxeffects.animations.motion.M3Motion;
import io.github.palexdev.mfxeffects.beans.Position;
import io.github.palexdev.mfxeffects.ripple.MFXRippleGenerator;
import io.github.palexdev.mfxresources.base.properties.IconProperty;
import io.github.palexdev.mfxresources.fonts.IconDescriptor;
import io.github.palexdev.mfxresources.fonts.IconProvider;
import io.github.palexdev.mfxresources.fonts.MFXFontIcon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.util.Duration;

public class MFXIconWrapper
extends StackPane {
    private final String STYLE_CLASS = "mfx-icon-wrapper";
    private final IconProperty icon = new IconProperty(){

        public void set(MFXFontIcon newValue) {
            MFXFontIcon oldValue = (MFXFontIcon)this.get();
            if (MFXIconWrapper.this.isAnimated() && newValue != null) {
                super.set((Object)newValue);
                newValue.setVisible(false);
                MFXIconWrapper.this.addChild((Node)newValue);
                if (MFXIconWrapper.this.animation != null) {
                    MFXIconWrapper.this.animation.stop(MFXIconWrapper.this);
                }
                if (MFXIconWrapper.this.animationProvider != null) {
                    MFXIconWrapper.this.animation = MFXIconWrapper.this.animationProvider.apply(oldValue, newValue);
                    MFXIconWrapper.this.animation.play();
                    return;
                }
            }
            MFXIconWrapper.this.removeChild((Node)oldValue);
            super.set((Object)newValue);
            if (newValue != null) {
                MFXIconWrapper.this.addChild((Node)newValue);
            }
        }

        protected void invalidated() {
            MFXIconWrapper.this.updateChildren();
        }
    };
    private MFXRippleGenerator rg;
    private EventHandler<MouseEvent> pressHandler;
    private EventHandler<MouseEvent> releaseHandler;
    private EventHandler<MouseEvent> exitHandler;
    private IconAnimation animation;
    private BiFunction<MFXFontIcon, MFXFontIcon, IconAnimation> animationProvider;
    private final StyleableBooleanProperty animated = new SimpleStyleableBooleanProperty(StyleableProperties.ANIMATED, (Object)this, "animated", false){

        public StyleOrigin getStyleOrigin() {
            return StyleOrigin.USER_AGENT;
        }
    };
    private final StyleableObjectProperty<AnimationPresets> animationPreset = new SimpleStyleableObjectProperty<AnimationPresets>(StyleableProperties.ANIMATION_PRESET, (Object)this, "animationPreset", null){

        protected void invalidated() {
            AnimationPresets p = (AnimationPresets)((Object)this.get());
            if (p == null) {
                return;
            }
            MFXIconWrapper.this.setAnimationProvider(p);
        }

        public StyleOrigin getStyleOrigin() {
            return StyleOrigin.USER_AGENT;
        }
    };
    private final StyleableDoubleProperty size = new SimpleStyleableDoubleProperty(StyleableProperties.SIZE, (Object)this, "size", -1.0){

        protected void invalidated() {
            MFXIconWrapper.this.setPrefSize(this.get(), this.get());
        }

        public StyleOrigin getStyleOrigin() {
            return StyleOrigin.USER_AGENT;
        }
    };
    private final StyleableBooleanProperty enableRipple = new SimpleStyleableBooleanProperty(StyleableProperties.ENABLE_RIPPLE, (Object)this, "enableRipple", false){

        protected void invalidated() {
            boolean state = this.get();
            if (!state && MFXIconWrapper.this.rg != null) {
                MFXIconWrapper.this.enableRippleGenerator(false);
            }
            if (state && MFXIconWrapper.this.rg == null) {
                MFXIconWrapper.this.enableRippleGenerator(true);
            }
            MFXIconWrapper.this.updateChildren();
        }

        public StyleOrigin getStyleOrigin() {
            return StyleOrigin.USER_AGENT;
        }
    };
    private final StyleableBooleanProperty round = new SimpleStyleableBooleanProperty(StyleableProperties.ROUND, (Object)this, "round", false){

        protected void invalidated() {
            boolean state = this.get();
            MFXIconWrapper.this.makeRound(state);
        }

        public StyleOrigin getStyleOrigin() {
            return StyleOrigin.USER_AGENT;
        }
    };

    public MFXIconWrapper() {
        this(new MFXFontIcon(), -1.0);
    }

    public MFXIconWrapper(MFXFontIcon icon) {
        this(icon, -1.0);
    }

    public MFXIconWrapper(MFXFontIcon icon, double size) {
        this.initialize();
        this.setIcon(icon);
        this.setSize(size);
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-icon-wrapper");
        this.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.addEventHandler(MouseEvent.MOUSE_PRESSED, e -> this.requestFocus());
        this.setAnimationPreset(AnimationPresets.FADE);
    }

    public MFXIconWrapper enableRippleGenerator(boolean enable) {
        return this.enableRippleGenerator(enable, e -> Position.of((double)e.getX(), (double)e.getY()));
    }

    public MFXIconWrapper enableRippleGenerator(boolean enable, Function<MouseEvent, Position> positionFunction) {
        if (!enable) {
            if (this.rg != null && this.pressHandler != null) {
                this.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.pressHandler);
                this.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.releaseHandler);
                this.removeEventHandler(MouseEvent.MOUSE_EXITED, this.exitHandler);
                this.removeChild((Node)this.rg);
                this.rg = null;
            }
            return this;
        }
        if (this.rg != null) {
            throw new IllegalStateException("Ripple generator has already been enabled for this icon!");
        }
        if (this.pressHandler == null) {
            this.pressHandler = e -> {
                if (e.getButton() == MouseButton.PRIMARY) {
                    this.rg.generate(e);
                }
            };
            this.releaseHandler = e -> this.rg.release();
            this.exitHandler = e -> this.rg.release();
        }
        this.rg = new MFXRippleGenerator((Region)this);
        this.rg.setManaged(false);
        this.rg.setMeToPosConverter(positionFunction);
        this.addEventHandler(MouseEvent.MOUSE_PRESSED, this.pressHandler);
        this.addEventHandler(MouseEvent.MOUSE_RELEASED, this.releaseHandler);
        this.addEventHandler(MouseEvent.MOUSE_EXITED, this.exitHandler);
        if (this.animation != null) {
            this.animation.stop(this);
        }
        this.addChild((Node)this.rg);
        this.setEnableRipple(true);
        return this;
    }

    public MFXIconWrapper makeRound(boolean state) {
        if (!state) {
            this.setClip(null);
            return this;
        }
        Node clip = this.getClip();
        if (clip != null) {
            return this;
        }
        Circle circle = new Circle();
        circle.radiusProperty().bind((ObservableValue)this.widthProperty().divide(2.0));
        circle.centerXProperty().bind((ObservableValue)this.widthProperty().divide(2.0));
        circle.centerYProperty().bind((ObservableValue)this.heightProperty().divide(2.0));
        this.setClip((Node)circle);
        this.setRound(true);
        return this;
    }

    public MFXIconWrapper makeRound(boolean state, double radius) {
        if (!state) {
            this.setClip(null);
            return this;
        }
        Node clip = this.getClip();
        if (clip != null) {
            return this;
        }
        Circle circle = new Circle(radius);
        circle.centerXProperty().bind((ObservableValue)this.widthProperty().divide(2.0));
        circle.centerYProperty().bind((ObservableValue)this.heightProperty().divide(2.0));
        this.setClip((Node)circle);
        this.setRound(true);
        return this;
    }

    protected void updateChildren() {
        MFXFontIcon icon = this.getIcon();
        if (this.rg != null) {
            this.rg.setViewOrder(0.0);
        }
        if (icon != null) {
            icon.setViewOrder(1.0);
        }
    }

    protected void addChild(Node child) {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(() -> super.getChildren().add((Object)child));
            return;
        }
        super.getChildren().add((Object)child);
    }

    protected void removeChild(Node child) {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(() -> super.getChildren().remove((Object)child));
            return;
        }
        super.getChildren().remove((Object)child);
    }

    public ObservableList<Node> getChildren() {
        return this.getChildrenUnmodifiable();
    }

    protected void layoutChildren() {
        MFXFontIcon icon;
        super.layoutChildren();
        if (this.rg != null) {
            this.rg.resizeRelocate(0.0, 0.0, this.getWidth(), this.getHeight());
        }
        if ((icon = this.getIcon()) != null && icon.getDescription() != null && !icon.getDescription().isBlank() && this.getSize() == -1.0) {
            double iW = icon.prefWidth(-1.0);
            double iH = icon.prefHeight(-1.0);
            double size = Math.max(this.snappedLeftInset() + iW + this.snappedRightInset(), this.snappedTopInset() + iH + this.snappedBottomInset());
            this.setSize(size);
        }
    }

    public boolean isAnimated() {
        return this.animated.get();
    }

    public StyleableBooleanProperty animatedProperty() {
        return this.animated;
    }

    public MFXIconWrapper setAnimated(boolean animated) {
        this.animated.set(animated);
        return this;
    }

    public AnimationPresets getAnimationPreset() {
        return (AnimationPresets)((Object)this.animationPreset.get());
    }

    public StyleableObjectProperty<AnimationPresets> animationPresetProperty() {
        return this.animationPreset;
    }

    public void setAnimationPreset(AnimationPresets animationPreset) {
        this.animationPreset.set((Object)animationPreset);
    }

    public double getSize() {
        return this.size.get();
    }

    public StyleableDoubleProperty sizeProperty() {
        return this.size;
    }

    public MFXIconWrapper setSize(double size) {
        this.size.set(size);
        return this;
    }

    public boolean isEnableRipple() {
        return this.enableRipple.get();
    }

    public StyleableBooleanProperty enableRippleProperty() {
        return this.enableRipple;
    }

    public MFXIconWrapper setEnableRipple(boolean enableRipple) {
        this.enableRipple.set(enableRipple);
        return this;
    }

    public boolean isRound() {
        return this.round.get();
    }

    public StyleableBooleanProperty roundProperty() {
        return this.round;
    }

    public MFXIconWrapper setRound(boolean round) {
        this.round.set(round);
        return this;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.cssMetaDataList;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return MFXIconWrapper.getClassCssMetaData();
    }

    public MFXRippleGenerator getRippleGenerator() {
        return this.rg;
    }

    public MFXFontIcon getIcon() {
        return (MFXFontIcon)this.icon.get();
    }

    public IconProperty iconProperty() {
        return this.icon;
    }

    public MFXIconWrapper setIcon(MFXFontIcon icon) {
        this.icon.set(icon);
        return this;
    }

    public MFXIconWrapper setIcon(String desc) {
        this.setIcon(new MFXFontIcon(desc));
        return this;
    }

    public MFXIconWrapper setIcon(IconProvider provider, String desc) {
        this.setIcon(new MFXFontIcon().setIconsProvider(provider).setDescription(desc));
        return this;
    }

    public MFXIconWrapper setIcon(Font font, Function<String, Character> converter, String desc) {
        this.setIcon(new MFXFontIcon().setIconsProvider(font, converter).setDescription(desc));
        return this;
    }

    public MFXIconWrapper setIcon(IconDescriptor descriptor) {
        this.setIcon(new MFXFontIcon(descriptor));
        return this;
    }

    public BiFunction<MFXFontIcon, MFXFontIcon, IconAnimation> getAnimationProvider() {
        return this.animationProvider;
    }

    public MFXIconWrapper setAnimationProvider(BiFunction<MFXFontIcon, MFXFontIcon, IconAnimation> animationProvider) {
        this.animationProvider = animationProvider;
        return this;
    }

    public MFXIconWrapper setAnimationProvider(AnimationPresets preset) {
        this.animationProvider = (o, n) -> preset.animate(this, (MFXFontIcon)o, (MFXFontIcon)n);
        return this;
    }

    private static class StyleableProperties {
        private static final StyleablePropertyFactory<MFXIconWrapper> FACTORY = new StyleablePropertyFactory(StackPane.getClassCssMetaData());
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<MFXIconWrapper, Boolean> ANIMATED;
        private static final CssMetaData<MFXIconWrapper, AnimationPresets> ANIMATION_PRESET;
        private static final CssMetaData<MFXIconWrapper, Number> SIZE;
        private static final CssMetaData<MFXIconWrapper, Boolean> ENABLE_RIPPLE;
        private static final CssMetaData<MFXIconWrapper, Boolean> ROUND;

        private StyleableProperties() {
        }

        static {
            ANIMATED = FACTORY.createBooleanCssMetaData("-mfx-animated", MFXIconWrapper::animatedProperty, false);
            ANIMATION_PRESET = FACTORY.createEnumCssMetaData(AnimationPresets.class, "-mfx-animation-preset", MFXIconWrapper::animationPresetProperty, null);
            SIZE = FACTORY.createSizeCssMetaData("-mfx-size", MFXIconWrapper::sizeProperty, (Number)-1.0);
            ENABLE_RIPPLE = FACTORY.createBooleanCssMetaData("-mfx-enable-ripple", MFXIconWrapper::enableRippleProperty, false);
            ROUND = FACTORY.createBooleanCssMetaData("-mfx-round", MFXIconWrapper::roundProperty, false);
            ArrayList data = new ArrayList(StackPane.getClassCssMetaData());
            Collections.addAll(data, ANIMATED, ANIMATION_PRESET, SIZE, ENABLE_RIPPLE, ROUND);
            cssMetaDataList = List.copyOf(data);
        }
    }

    public static enum AnimationPresets {
        FADE{

            @Override
            public IconAnimation animate(MFXIconWrapper wrapper, MFXFontIcon oldIcon, MFXFontIcon newIcon) {
                newIcon.setOpacity(0.0);
                newIcon.setVisible(true);
                Duration d = M3Motion.SHORT4;
                Interpolator i = M3Motion.STANDARD;
                Animations.SequentialBuilder sb = new Animations.SequentialBuilder();
                if (oldIcon != null) {
                    sb.add((Animation)AnimationFactory.FADE_OUT.build((Node)oldIcon, d, i));
                }
                sb.add((Animation)AnimationFactory.FADE_IN.build((Node)newIcon, d, i));
                return new IconAnimation(wrapper, (Animation)sb.getAnimation(), oldIcon, newIcon);
            }
        }
        ,
        SLIDE_UP{

            @Override
            public IconAnimation animate(MFXIconWrapper wrapper, MFXFontIcon oldIcon, MFXFontIcon newIcon) {
                this.clip(wrapper);
                Duration d = M3Motion.MEDIUM1;
                Animations.SequentialBuilder sb = new Animations.SequentialBuilder();
                if (oldIcon != null) {
                    sb.add((Animation)AnimationFactory.SLIDE_OUT_TOP.build((Node)oldIcon, d, M3Motion.EMPHASIZED_ACCELERATE));
                }
                Timeline t = AnimationFactory.SLIDE_IN_TOP.build((Node)newIcon, d, M3Motion.EMPHASIZED_DECELERATE);
                t.getKeyFrames().add((Object)Animations.KeyFrames.of((double)0.0, e -> newIcon.setVisible(true)));
                sb.add((Animation)t);
                Animations.onStopped((Animation)sb.getAnimation(), () -> {
                    if (!wrapper.isRound()) {
                        wrapper.setClip(null);
                    }
                }, (boolean)true);
                return new IconAnimation(wrapper, (Animation)sb.getAnimation(), oldIcon, newIcon);
            }
        }
        ,
        SLIDE_BOTTOM{

            @Override
            public IconAnimation animate(MFXIconWrapper wrapper, MFXFontIcon oldIcon, MFXFontIcon newIcon) {
                this.clip(wrapper);
                Duration d = M3Motion.MEDIUM1;
                Animations.SequentialBuilder sb = new Animations.SequentialBuilder();
                if (oldIcon != null) {
                    sb.add((Animation)AnimationFactory.SLIDE_OUT_BOTTOM.build((Node)oldIcon, d, M3Motion.EMPHASIZED_ACCELERATE));
                }
                Timeline t = AnimationFactory.SLIDE_IN_BOTTOM.build((Node)newIcon, d, M3Motion.EMPHASIZED_DECELERATE);
                t.getKeyFrames().add((Object)Animations.KeyFrames.of((double)0.0, e -> newIcon.setVisible(true)));
                sb.add((Animation)t);
                Animations.onStopped((Animation)sb.getAnimation(), () -> {
                    if (!wrapper.isRound()) {
                        wrapper.setClip(null);
                    }
                }, (boolean)true);
                return new IconAnimation(wrapper, (Animation)sb.getAnimation(), oldIcon, newIcon);
            }
        }
        ,
        SLIDE_BOTTOM_UP{

            @Override
            public IconAnimation animate(MFXIconWrapper wrapper, MFXFontIcon oldIcon, MFXFontIcon newIcon) {
                this.clip(wrapper);
                Duration d = M3Motion.MEDIUM1;
                Animations.SequentialBuilder sb = new Animations.SequentialBuilder();
                if (oldIcon != null) {
                    sb.add((Animation)AnimationFactory.SLIDE_OUT_BOTTOM.build((Node)oldIcon, d, M3Motion.EMPHASIZED_ACCELERATE));
                }
                Timeline t = AnimationFactory.SLIDE_IN_TOP.build((Node)newIcon, d, M3Motion.EMPHASIZED_DECELERATE);
                t.getKeyFrames().add((Object)Animations.KeyFrames.of((double)0.0, e -> newIcon.setVisible(true)));
                sb.add((Animation)t);
                Animations.onStopped((Animation)sb.getAnimation(), () -> {
                    if (!wrapper.isRound()) {
                        wrapper.setClip(null);
                    }
                }, (boolean)true);
                return new IconAnimation(wrapper, (Animation)sb.getAnimation(), oldIcon, newIcon);
            }
        }
        ,
        SLIDE_UP_BOTTOM{

            @Override
            public IconAnimation animate(MFXIconWrapper wrapper, MFXFontIcon oldIcon, MFXFontIcon newIcon) {
                this.clip(wrapper);
                Duration d = M3Motion.MEDIUM1;
                Animations.SequentialBuilder sb = new Animations.SequentialBuilder();
                if (oldIcon != null) {
                    sb.add((Animation)AnimationFactory.SLIDE_OUT_TOP.build((Node)oldIcon, d, M3Motion.EMPHASIZED_ACCELERATE));
                }
                Timeline t = AnimationFactory.SLIDE_IN_BOTTOM.build((Node)newIcon, d, M3Motion.EMPHASIZED_DECELERATE);
                t.getKeyFrames().add((Object)Animations.KeyFrames.of((double)0.0, e -> newIcon.setVisible(true)));
                sb.add((Animation)t);
                Animations.onStopped((Animation)sb.getAnimation(), () -> {
                    if (!wrapper.isRound()) {
                        wrapper.setClip(null);
                    }
                }, (boolean)true);
                return new IconAnimation(wrapper, (Animation)sb.getAnimation(), oldIcon, newIcon);
            }
        }
        ,
        SLIDE_RIGHT{

            @Override
            public IconAnimation animate(MFXIconWrapper wrapper, MFXFontIcon oldIcon, MFXFontIcon newIcon) {
                this.clip(wrapper);
                Duration d = M3Motion.MEDIUM1;
                Animations.SequentialBuilder sb = new Animations.SequentialBuilder();
                if (oldIcon != null) {
                    sb.add((Animation)AnimationFactory.SLIDE_OUT_RIGHT.build((Node)oldIcon, d, M3Motion.EMPHASIZED_ACCELERATE));
                }
                Timeline t = AnimationFactory.SLIDE_IN_RIGHT.build((Node)newIcon, d, M3Motion.EMPHASIZED_DECELERATE);
                t.getKeyFrames().add((Object)Animations.KeyFrames.of((double)0.0, e -> newIcon.setVisible(true)));
                sb.add((Animation)t);
                Animations.onStopped((Animation)sb.getAnimation(), () -> {
                    if (!wrapper.isRound()) {
                        wrapper.setClip(null);
                    }
                }, (boolean)true);
                return new IconAnimation(wrapper, (Animation)sb.getAnimation(), oldIcon, newIcon);
            }
        }
        ,
        SLIDE_LEFT{

            @Override
            public IconAnimation animate(MFXIconWrapper wrapper, MFXFontIcon oldIcon, MFXFontIcon newIcon) {
                this.clip(wrapper);
                Duration d = M3Motion.MEDIUM1;
                Animations.SequentialBuilder sb = new Animations.SequentialBuilder();
                if (oldIcon != null) {
                    sb.add((Animation)AnimationFactory.SLIDE_OUT_LEFT.build((Node)oldIcon, d, M3Motion.EMPHASIZED_ACCELERATE));
                }
                Timeline t = AnimationFactory.SLIDE_IN_LEFT.build((Node)newIcon, d, M3Motion.EMPHASIZED_DECELERATE);
                t.getKeyFrames().add((Object)Animations.KeyFrames.of((double)0.0, e -> newIcon.setVisible(true)));
                sb.add((Animation)t);
                Animations.onStopped((Animation)sb.getAnimation(), () -> {
                    if (!wrapper.isRound()) {
                        wrapper.setClip(null);
                    }
                }, (boolean)true);
                return new IconAnimation(wrapper, (Animation)sb.getAnimation(), oldIcon, newIcon);
            }
        }
        ,
        SLIDE_RIGHT_LEFT{

            @Override
            public IconAnimation animate(MFXIconWrapper wrapper, MFXFontIcon oldIcon, MFXFontIcon newIcon) {
                this.clip(wrapper);
                Duration d = M3Motion.MEDIUM1;
                Animations.SequentialBuilder sb = new Animations.SequentialBuilder();
                if (oldIcon != null) {
                    sb.add((Animation)AnimationFactory.SLIDE_OUT_RIGHT.build((Node)oldIcon, d, M3Motion.EMPHASIZED_ACCELERATE));
                }
                Timeline t = AnimationFactory.SLIDE_IN_RIGHT.build((Node)newIcon, d, M3Motion.EMPHASIZED_DECELERATE);
                t.getKeyFrames().add((Object)Animations.KeyFrames.of((double)0.0, e -> newIcon.setVisible(true)));
                sb.add((Animation)t);
                Animations.onStopped((Animation)sb.getAnimation(), () -> {
                    if (!wrapper.isRound()) {
                        wrapper.setClip(null);
                    }
                }, (boolean)true);
                return new IconAnimation(wrapper, (Animation)sb.getAnimation(), oldIcon, newIcon);
            }
        }
        ,
        SLIDE_LEFT_RIGHT{

            @Override
            public IconAnimation animate(MFXIconWrapper wrapper, MFXFontIcon oldIcon, MFXFontIcon newIcon) {
                this.clip(wrapper);
                Duration d = M3Motion.MEDIUM1;
                Animations.SequentialBuilder sb = new Animations.SequentialBuilder();
                if (oldIcon != null) {
                    sb.add((Animation)AnimationFactory.SLIDE_OUT_LEFT.build((Node)oldIcon, d, M3Motion.EMPHASIZED_ACCELERATE));
                }
                Timeline t = AnimationFactory.SLIDE_IN_LEFT.build((Node)newIcon, d, M3Motion.EMPHASIZED_DECELERATE);
                t.getKeyFrames().add((Object)Animations.KeyFrames.of((double)0.0, e -> newIcon.setVisible(true)));
                sb.add((Animation)t);
                Animations.onStopped((Animation)sb.getAnimation(), () -> {
                    if (!wrapper.isRound()) {
                        wrapper.setClip(null);
                    }
                }, (boolean)true);
                return new IconAnimation(wrapper, (Animation)sb.getAnimation(), oldIcon, newIcon);
            }
        }
        ,
        SCALE{

            @Override
            public IconAnimation animate(MFXIconWrapper wrapper, MFXFontIcon oldIcon, MFXFontIcon newIcon) {
                newIcon.setOpacity(0.0);
                newIcon.setVisible(true);
                Duration d = M3Motion.SHORT4;
                Interpolator downCurve = M3Motion.EMPHASIZED_ACCELERATE;
                Interpolator upCurve = M3Motion.EMPHASIZED_DECELERATE;
                Animation animation = Animations.SequentialBuilder.build().add((Animation)Animations.TimelineBuilder.build().add(new KeyFrame[]{Animations.KeyFrames.of((Duration)d, (WritableValue)oldIcon.opacityProperty(), (Object)0.0, (Interpolator)downCurve)}).add(new KeyFrame[]{Animations.KeyFrames.of((Duration)d, (WritableValue)wrapper.scaleXProperty(), (Object)0.0, (Interpolator)downCurve)}).add(new KeyFrame[]{Animations.KeyFrames.of((Duration)d, (WritableValue)wrapper.scaleYProperty(), (Object)0.0, (Interpolator)downCurve)}).getAnimation()).add((Animation)Animations.TimelineBuilder.build().add(new KeyFrame[]{Animations.KeyFrames.of((Duration)d, (WritableValue)newIcon.opacityProperty(), (Object)1.0, (Interpolator)upCurve)}).add(new KeyFrame[]{Animations.KeyFrames.of((Duration)d, (WritableValue)wrapper.scaleXProperty(), (Object)1.0, (Interpolator)upCurve)}).add(new KeyFrame[]{Animations.KeyFrames.of((Duration)d, (WritableValue)wrapper.scaleYProperty(), (Object)1.0, (Interpolator)upCurve)}).getAnimation()).getAnimation();
                Animations.onStopped((Animation)animation, () -> {
                    newIcon.setOpacity(1.0);
                    wrapper.setScaleX(1.0);
                    wrapper.setScaleY(1.0);
                }, (boolean)true);
                return new IconAnimation(wrapper, animation, oldIcon, newIcon);
            }
        }
        ,
        CLIP{

            @Override
            public IconAnimation animate(MFXIconWrapper wrapper, MFXFontIcon oldIcon, MFXFontIcon newIcon) {
                Animations.TimelineBuilder aBuilder = new Animations.TimelineBuilder();
                Duration d = M3Motion.LONG1;
                Interpolator i = M3Motion.EMPHASIZED;
                double wh = wrapper.getHeight();
                if (oldIcon != null) {
                    Rectangle oClip = new Rectangle(oldIcon.prefWidth(-1.0), oldIcon.prefHeight(-1.0));
                    oClip.setLayoutY(-oClip.getHeight());
                    oldIcon.setClip((Node)oClip);
                    aBuilder.add(new KeyFrame[]{Animations.KeyFrames.of((Duration)d, (WritableValue)oClip.widthProperty(), (Object)0.0, (Interpolator)i)});
                }
                wrapper.applyCss();
                double nSize = newIcon.prefWidth(-1.0);
                Rectangle nClip = new Rectangle(0.0, wh);
                nClip.setLayoutY(-wh);
                newIcon.setClip((Node)nClip);
                newIcon.setVisible(true);
                aBuilder.add(new KeyFrame[]{Animations.KeyFrames.of((Duration)d, (WritableValue)nClip.widthProperty(), (Object)nSize, (Interpolator)i)});
                Animations.onStopped((Animation)aBuilder.getAnimation(), () -> {
                    if (oldIcon != null) {
                        oldIcon.setClip(null);
                    }
                    newIcon.setClip(null);
                }, (boolean)true);
                return new IconAnimation(wrapper, (Animation)aBuilder.getAnimation(), oldIcon, newIcon);
            }
        };


        public abstract IconAnimation animate(MFXIconWrapper var1, MFXFontIcon var2, MFXFontIcon var3);

        protected void clip(MFXIconWrapper wrapper) {
            if (wrapper.isRound()) {
                return;
            }
            Rectangle r = new Rectangle();
            r.widthProperty().bind((ObservableValue)wrapper.widthProperty());
            r.heightProperty().bind((ObservableValue)wrapper.heightProperty());
            wrapper.setClip((Node)r);
        }
    }

    public static class IconAnimation {
        private final Animation animation;
        private final MFXFontIcon oldIcon;
        private final MFXFontIcon newIcon;

        public IconAnimation(MFXIconWrapper wrapper, Animation animation, MFXFontIcon oldIcon, MFXFontIcon newIcon) {
            this.animation = animation;
            this.oldIcon = oldIcon;
            this.newIcon = newIcon;
            Animations.onStopped((Animation)animation, () -> wrapper.removeChild((Node)oldIcon), (boolean)true);
        }

        public IconAnimation play() {
            if (this.animation != null) {
                this.animation.play();
            }
            return this;
        }

        public void stop(MFXIconWrapper wrapper) {
            if (!Animations.isStopped((Animation)this.animation)) {
                this.animation.stop();
                wrapper.removeChild((Node)this.oldIcon);
                wrapper.updateChildren();
            }
        }

        public Animation getAnimation() {
            return this.animation;
        }

        public MFXFontIcon getOldIcon() {
            return this.oldIcon;
        }

        public MFXFontIcon getNewIcon() {
            return this.newIcon;
        }
    }
}

