/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.beans;

public class VirtualBounds {
    public static VirtualBounds EMPTY = new VirtualBounds();
    private final double width;
    private final double height;
    private final double virtualWidth;
    private final double virtualHeight;

    protected VirtualBounds() {
        this.width = 0.0;
        this.height = 0.0;
        this.virtualWidth = 0.0;
        this.virtualHeight = 0.0;
    }

    public VirtualBounds(double width, double height, double virtualWidth, double virtualHeight) {
        this.width = width;
        this.height = height;
        this.virtualWidth = virtualWidth;
        this.virtualHeight = virtualHeight;
    }

    public static VirtualBounds of(double width, double height, double virtualWidth, double virtualHeight) {
        return new VirtualBounds(width, height, virtualWidth, virtualHeight);
    }

    public boolean isEmpty() {
        return this == EMPTY || this.width == 0.0 && this.virtualWidth == 0.0 && this.height == 0.0 && this.virtualHeight == 0.0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualBounds that = (VirtualBounds)o;
        return that.getWidth() == this.getWidth() && that.getHeight() == this.getHeight() && that.getVirtualWidth() == this.getVirtualWidth() && that.getVirtualHeight() == this.getVirtualHeight();
    }

    public String toString() {
        return "VirtualBounds{width=" + this.width + ", height=" + this.height + ", virtualWidth=" + this.virtualWidth + ", virtualHeight=" + this.virtualHeight + "}";
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getVirtualWidth() {
        return this.virtualWidth;
    }

    public double getVirtualHeight() {
        return this.virtualHeight;
    }
}

