/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.controls;

import io.github.palexdev.mfxcore.base.properties.styleable.StyleableBooleanProperty;
import io.github.palexdev.mfxcore.base.properties.styleable.StyleableDoubleProperty;
import io.github.palexdev.mfxcore.base.properties.styleable.StyleableObjectProperty;
import io.github.palexdev.mfxcore.utils.fx.PropUtils;
import io.github.palexdev.mfxcore.utils.fx.StyleUtils;
import io.github.palexdev.virtualizedfx.controls.behavior.MFXScrollBarBehavior;
import io.github.palexdev.virtualizedfx.controls.behavior.base.BehaviorBase;
import io.github.palexdev.virtualizedfx.controls.behavior.base.MFXBehavioral;
import io.github.palexdev.virtualizedfx.controls.skins.MFXScrollBarSkin;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleablePropertyFactory;
import javafx.geometry.Orientation;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;

public class MFXScrollBar
extends Control
implements MFXBehavioral<MFXScrollBar, MFXScrollBarBehavior> {
    private final String STYLE_CLASS = "mfx-scroll-bar";
    private final DoubleProperty min = PropUtils.clampedDoubleProperty(() -> 0.0, this::getMax);
    private final DoubleProperty value = PropUtils.clampedDoubleProperty(this::getMin, this::getMax);
    private final DoubleProperty max = PropUtils.clampedDoubleProperty(this::getMin, () -> 1.0);
    private final DoubleProperty visibleAmount = new SimpleDoubleProperty();
    private final DoubleProperty thumbPos = new SimpleDoubleProperty();
    private final DoubleProperty trackLength = new SimpleDoubleProperty();
    private static final PseudoClass DRAGGING_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"dragging");
    private final BooleanProperty dragging = new SimpleBooleanProperty(){

        protected void invalidated() {
            MFXScrollBar.this.pseudoClassStateChanged(DRAGGING_PSEUDO_CLASS, this.get());
        }
    };
    private final ObjectProperty<MFXScrollBarBehavior> behavior = PropUtils.mappedObjectProperty(val -> {
        MFXScrollBarBehavior old = this.getBehavior();
        if (old != null) {
            ((BehaviorBase)old).dispose();
        }
        return val;
    });
    private final StyleableBooleanProperty buttonsVisible = new StyleableBooleanProperty(StyleableProperties.BUTTONS_VISIBLE, (Object)this, "buttonsVisible", false);
    private final StyleableDoubleProperty buttonsGap = new StyleableDoubleProperty(StyleableProperties.BUTTONS_GAP, (Object)this, "buttonsGap", Double.valueOf(3.0));
    private final StyleableObjectProperty<Orientation> orientation = new StyleableObjectProperty(StyleableProperties.ORIENTATION, (Object)this, "orientation", (Object)Orientation.VERTICAL);
    private final StyleableDoubleProperty trackIncrement = new StyleableDoubleProperty(StyleableProperties.TRACK_INCREMENT, (Object)this, "trackIncrement", Double.valueOf(0.1));
    private final StyleableDoubleProperty unitIncrement = new StyleableDoubleProperty(StyleableProperties.UNIT_INCREMENT, (Object)this, "unitIncrement", Double.valueOf(0.01));
    private final StyleableBooleanProperty smoothScroll = new StyleableBooleanProperty(StyleableProperties.SMOOTH_SCROLL, (Object)this, "smoothScroll", false);
    private final StyleableBooleanProperty trackSmoothScroll = new StyleableBooleanProperty(StyleableProperties.TRACK_SMOOTH_SCROLL, (Object)this, "trackSmoothScroll", false);

    public MFXScrollBar() {
        this(Orientation.VERTICAL);
    }

    public MFXScrollBar(Orientation orientation) {
        this.setOrientation(orientation);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-scroll-bar");
        this.setBehavior(this.defaultBehavior());
        this.setMin(0.0);
        this.setMax(1.0);
    }

    @Override
    public MFXScrollBarBehavior defaultBehavior() {
        return new MFXScrollBarBehavior(this);
    }

    @Override
    public MFXScrollBarBehavior getBehavior() {
        return (MFXScrollBarBehavior)this.behavior.get();
    }

    @Override
    public ObjectProperty<MFXScrollBarBehavior> behaviorProperty() {
        return this.behavior;
    }

    @Override
    public void setBehavior(MFXScrollBarBehavior behavior) {
        this.behavior.set((Object)behavior);
    }

    protected Skin<?> createDefaultSkin() {
        return new MFXScrollBarSkin(this);
    }

    public boolean isButtonsVisible() {
        return this.buttonsVisible.get();
    }

    public StyleableBooleanProperty buttonsVisibleProperty() {
        return this.buttonsVisible;
    }

    public void setButtonsVisible(boolean buttonsVisible) {
        this.buttonsVisible.set(buttonsVisible);
    }

    public double getButtonsGap() {
        return this.buttonsGap.get();
    }

    public StyleableDoubleProperty buttonsGapProperty() {
        return this.buttonsGap;
    }

    public void setButtonsGap(double buttonsGap) {
        this.buttonsGap.set(buttonsGap);
    }

    public Orientation getOrientation() {
        return (Orientation)this.orientation.get();
    }

    public StyleableObjectProperty<Orientation> orientationProperty() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation.set((Object)orientation);
    }

    public double getTrackIncrement() {
        return this.trackIncrement.get();
    }

    public StyleableDoubleProperty trackIncrementProperty() {
        return this.trackIncrement;
    }

    public void setTrackIncrement(double trackIncrement) {
        this.trackIncrement.set(trackIncrement);
    }

    public double getUnitIncrement() {
        return this.unitIncrement.get();
    }

    public StyleableDoubleProperty unitIncrementProperty() {
        return this.unitIncrement;
    }

    public void setUnitIncrement(double unitIncrement) {
        this.unitIncrement.set(unitIncrement);
    }

    public boolean isSmoothScroll() {
        return this.smoothScroll.get();
    }

    public StyleableBooleanProperty smoothScrollProperty() {
        return this.smoothScroll;
    }

    public void setSmoothScroll(boolean smoothScroll) {
        this.smoothScroll.set(smoothScroll);
    }

    public boolean isTrackSmoothScroll() {
        return this.trackSmoothScroll.get();
    }

    public StyleableBooleanProperty trackSmoothScrollProperty() {
        return this.trackSmoothScroll;
    }

    public void setTrackSmoothScroll(boolean trackSmoothScroll) {
        this.trackSmoothScroll.set(trackSmoothScroll);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.cssMetaDataList;
    }

    public double getMin() {
        return this.min.get();
    }

    public DoubleProperty minProperty() {
        return this.min;
    }

    public void setMin(double min) {
        this.min.set(min);
    }

    public double getValue() {
        return this.value.get();
    }

    public DoubleProperty valueProperty() {
        return this.value;
    }

    public void setValue(double value) {
        this.value.set(value);
    }

    public double getMax() {
        return this.max.get();
    }

    public DoubleProperty maxProperty() {
        return this.max;
    }

    public void setMax(double max) {
        this.max.set(max);
    }

    public double getVisibleAmount() {
        return this.visibleAmount.get();
    }

    public ReadOnlyDoubleProperty visibleAmountProperty() {
        return this.visibleAmount;
    }

    public double getThumbPos() {
        return this.thumbPos.get();
    }

    public ReadOnlyDoubleProperty thumbPosProperty() {
        return this.thumbPos;
    }

    public double getTrackLength() {
        return this.trackLength.get();
    }

    public ReadOnlyDoubleProperty trackLengthProperty() {
        return this.trackLength;
    }

    public boolean isDragging() {
        return this.dragging.get();
    }

    public ReadOnlyBooleanProperty draggingProperty() {
        return this.dragging;
    }

    private static class StyleableProperties {
        private static final StyleablePropertyFactory<MFXScrollBar> FACTORY = new StyleablePropertyFactory(Control.getClassCssMetaData());
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<MFXScrollBar, Boolean> BUTTONS_VISIBLE;
        private static final CssMetaData<MFXScrollBar, Number> BUTTONS_GAP;
        private static final CssMetaData<MFXScrollBar, Orientation> ORIENTATION;
        private static final CssMetaData<MFXScrollBar, Number> TRACK_INCREMENT;
        private static final CssMetaData<MFXScrollBar, Number> UNIT_INCREMENT;
        private static final CssMetaData<MFXScrollBar, Boolean> SMOOTH_SCROLL;
        private static final CssMetaData<MFXScrollBar, Boolean> TRACK_SMOOTH_SCROLL;

        private StyleableProperties() {
        }

        static {
            BUTTONS_VISIBLE = FACTORY.createBooleanCssMetaData("-mfx-buttons-visible", MFXScrollBar::buttonsVisibleProperty, false);
            BUTTONS_GAP = FACTORY.createSizeCssMetaData("-mfx-buttons-gap", MFXScrollBar::buttonsGapProperty, (Number)3.0);
            ORIENTATION = FACTORY.createEnumCssMetaData(Orientation.class, "-mfx-orientation", MFXScrollBar::orientationProperty, (Enum)Orientation.VERTICAL);
            TRACK_INCREMENT = FACTORY.createSizeCssMetaData("-mfx-track-increment", MFXScrollBar::trackIncrementProperty, (Number)0.1);
            UNIT_INCREMENT = FACTORY.createSizeCssMetaData("-mfx-unit-increment", MFXScrollBar::unitIncrementProperty, (Number)0.01);
            SMOOTH_SCROLL = FACTORY.createBooleanCssMetaData("-mfx-smooth-scroll", MFXScrollBar::smoothScrollProperty, false);
            TRACK_SMOOTH_SCROLL = FACTORY.createBooleanCssMetaData("-mfx-track-smooth-scroll", MFXScrollBar::trackSmoothScrollProperty, false);
            cssMetaDataList = StyleUtils.cssMetaDataList((List)Control.getClassCssMetaData(), (CssMetaData[])new CssMetaData[]{BUTTONS_VISIBLE, BUTTONS_GAP, ORIENTATION, TRACK_INCREMENT, UNIT_INCREMENT, SMOOTH_SCROLL, TRACK_SMOOTH_SCROLL});
        }
    }
}

