/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.controls;

import io.github.palexdev.mfxcore.base.properties.functional.FunctionProperty;
import io.github.palexdev.mfxcore.base.properties.styleable.StyleableBooleanProperty;
import io.github.palexdev.mfxcore.base.properties.styleable.StyleableDoubleProperty;
import io.github.palexdev.mfxcore.base.properties.styleable.StyleableObjectProperty;
import io.github.palexdev.mfxcore.utils.fx.PropUtils;
import io.github.palexdev.mfxcore.utils.fx.StyleUtils;
import io.github.palexdev.virtualizedfx.beans.VirtualBounds;
import io.github.palexdev.virtualizedfx.controls.MFXScrollBar;
import io.github.palexdev.virtualizedfx.controls.behavior.MFXScrollBarBehavior;
import io.github.palexdev.virtualizedfx.controls.skins.VirtualScrollPaneSkin;
import io.github.palexdev.virtualizedfx.enums.ScrollPaneEnums;
import java.util.List;
import java.util.function.Function;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleablePropertyFactory;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;

public class VirtualScrollPane
extends Control {
    private final String STYLE_CLASS = "virtual-scroll-pane";
    private final ObjectProperty<Node> content = new SimpleObjectProperty();
    private final ObjectProperty<VirtualBounds> contentBounds = new SimpleObjectProperty((Object)VirtualBounds.EMPTY);
    private final DoubleProperty hMin = PropUtils.clampedDoubleProperty(() -> 0.0, this::getHMax);
    private final DoubleProperty hVal = PropUtils.clampedDoubleProperty(this::getHMin, this::getHMax);
    private final DoubleProperty hMax = PropUtils.clampedDoubleProperty(this::getHMin, () -> 1.0);
    private final DoubleProperty vMin = PropUtils.clampedDoubleProperty(() -> 0.0, this::getVMax);
    private final DoubleProperty vVal = PropUtils.clampedDoubleProperty(this::getVMin, this::getVMax);
    private final DoubleProperty vMax = PropUtils.clampedDoubleProperty(this::getVMin, () -> 1.0);
    private final ObjectProperty<Orientation> orientation = new SimpleObjectProperty((Object)Orientation.VERTICAL);
    private final FunctionProperty<MFXScrollBar, MFXScrollBarBehavior> hBarBehavior = PropUtils.function(MFXScrollBarBehavior::new);
    private final FunctionProperty<MFXScrollBar, MFXScrollBarBehavior> vBarBehavior = PropUtils.function(MFXScrollBarBehavior::new);
    private final StyleableObjectProperty<ScrollPaneEnums.LayoutMode> layoutMode = new StyleableObjectProperty(StyleableProperties.LAYOUT_MODE, (Object)this, "layoutMode", (Object)ScrollPaneEnums.LayoutMode.DEFAULT);
    private final StyleableBooleanProperty autoHideBars = new StyleableBooleanProperty(StyleableProperties.AUTO_HIDE_BARS, (Object)this, "autoHideBars", false);
    private final StyleableObjectProperty<ScrollPaneEnums.ScrollBarPolicy> hBarPolicy = new StyleableObjectProperty(StyleableProperties.HBAR_POLICY, (Object)this, "hBarPolicy", (Object)ScrollPaneEnums.ScrollBarPolicy.DEFAULT);
    private final StyleableObjectProperty<ScrollPaneEnums.ScrollBarPolicy> vBarPolicy = new StyleableObjectProperty(StyleableProperties.VBAR_POLICY, (Object)this, "vBarPolicy", (Object)ScrollPaneEnums.ScrollBarPolicy.DEFAULT);
    private final StyleableObjectProperty<ScrollPaneEnums.HBarPos> hBarPos = new StyleableObjectProperty(StyleableProperties.HBAR_POS, (Object)this, "hBarPos", (Object)ScrollPaneEnums.HBarPos.BOTTOM);
    private final StyleableObjectProperty<ScrollPaneEnums.VBarPos> vBarPos = new StyleableObjectProperty(StyleableProperties.VBAR_POS, (Object)this, "vBarPos", (Object)ScrollPaneEnums.VBarPos.RIGHT);
    private final StyleableObjectProperty<Insets> hBarPadding = new StyleableObjectProperty(StyleableProperties.HBAR_PADDING, (Object)this, "hBarPadding", (Object)Insets.EMPTY);
    private final StyleableObjectProperty<Insets> vBarPadding = new StyleableObjectProperty(StyleableProperties.VBAR_PADDING, (Object)this, "vBarPadding", (Object)Insets.EMPTY);
    private final StyleableDoubleProperty hBarOffset = new StyleableDoubleProperty(StyleableProperties.HBAR_OFFSET, (Object)this, "hBarOffset", Double.valueOf(0.0));
    private final StyleableDoubleProperty vBarOffset = new StyleableDoubleProperty(StyleableProperties.VBAR_OFFSET, (Object)this, "vBarOffset", Double.valueOf(0.0));
    private final StyleableBooleanProperty dragToScroll = new StyleableBooleanProperty(StyleableProperties.DRAG_TO_SCROLL, (Object)this, "dragToScroll", false);
    private final StyleableBooleanProperty buttonsVisible = new StyleableBooleanProperty(StyleableProperties.BUTTONS_VISIBLE, (Object)this, "buttonsVisible", false);
    private final StyleableDoubleProperty buttonsGap = new StyleableDoubleProperty(StyleableProperties.BUTTONS_GAP, (Object)this, "buttonsGap", Double.valueOf(3.0));
    private final StyleableDoubleProperty hTrackIncrement = new StyleableDoubleProperty(StyleableProperties.H_TRACK_INCREMENT, (Object)this, "hTrackIncrement", Double.valueOf(0.1));
    private final StyleableDoubleProperty hUnitIncrement = new StyleableDoubleProperty(StyleableProperties.H_UNIT_INCREMENT, (Object)this, "hUnitIncrement", Double.valueOf(0.01));
    private final StyleableDoubleProperty vTrackIncrement = new StyleableDoubleProperty(StyleableProperties.V_TRACK_INCREMENT, (Object)this, "vTrackIncrement", Double.valueOf(0.1));
    private final StyleableDoubleProperty vUnitIncrement = new StyleableDoubleProperty(StyleableProperties.V_UNIT_INCREMENT, (Object)this, "vUnitIncrement", Double.valueOf(0.01));
    private final StyleableBooleanProperty smoothScroll = new StyleableBooleanProperty(StyleableProperties.SMOOTH_SCROLL, (Object)this, "smoothScroll", false);
    private final StyleableBooleanProperty trackSmoothScroll = new StyleableBooleanProperty(StyleableProperties.SMOOTH_SCROLL_ON_TRACK_PRESS, (Object)this, "trackSmoothScroll", false);
    private final StyleableDoubleProperty clipBorderRadius = new StyleableDoubleProperty(StyleableProperties.CLIP_BORDER_RADIUS, (Object)this, "clipBorderRadius", Double.valueOf(0.0));

    public VirtualScrollPane() {
        this(null);
    }

    public VirtualScrollPane(Node content) {
        this.setContent(content);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"virtual-scroll-pane");
    }

    protected Skin<?> createDefaultSkin() {
        return new VirtualScrollPaneSkin(this);
    }

    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return VirtualScrollPane.getClassCssMetaData();
    }

    public ScrollPaneEnums.LayoutMode getLayoutMode() {
        return (ScrollPaneEnums.LayoutMode)((Object)this.layoutMode.get());
    }

    public StyleableObjectProperty<ScrollPaneEnums.LayoutMode> layoutModeProperty() {
        return this.layoutMode;
    }

    public void setLayoutMode(ScrollPaneEnums.LayoutMode layoutMode) {
        this.layoutMode.set((Object)layoutMode);
    }

    public boolean isAutoHideBars() {
        return this.autoHideBars.get();
    }

    public StyleableBooleanProperty autoHideBarsProperty() {
        return this.autoHideBars;
    }

    public void setAutoHideBars(boolean autoHideBars) {
        this.autoHideBars.set(autoHideBars);
    }

    public ScrollPaneEnums.ScrollBarPolicy getHBarPolicy() {
        return (ScrollPaneEnums.ScrollBarPolicy)((Object)this.hBarPolicy.get());
    }

    public StyleableObjectProperty<ScrollPaneEnums.ScrollBarPolicy> hBarPolicyProperty() {
        return this.hBarPolicy;
    }

    public void setHBarPolicy(ScrollPaneEnums.ScrollBarPolicy hBarPolicy) {
        this.hBarPolicy.set((Object)hBarPolicy);
    }

    public ScrollPaneEnums.ScrollBarPolicy getVBarPolicy() {
        return (ScrollPaneEnums.ScrollBarPolicy)((Object)this.vBarPolicy.get());
    }

    public StyleableObjectProperty<ScrollPaneEnums.ScrollBarPolicy> vBarPolicyProperty() {
        return this.vBarPolicy;
    }

    public void setVBarPolicy(ScrollPaneEnums.ScrollBarPolicy vBarPolicy) {
        this.vBarPolicy.set((Object)vBarPolicy);
    }

    public ScrollPaneEnums.HBarPos getHBarPos() {
        return (ScrollPaneEnums.HBarPos)((Object)this.hBarPos.get());
    }

    public StyleableObjectProperty<ScrollPaneEnums.HBarPos> hBarPosProperty() {
        return this.hBarPos;
    }

    public void setHBarPos(ScrollPaneEnums.HBarPos hBarPos) {
        this.hBarPos.set((Object)hBarPos);
    }

    public ScrollPaneEnums.VBarPos getVBarPos() {
        return (ScrollPaneEnums.VBarPos)((Object)this.vBarPos.get());
    }

    public StyleableObjectProperty<ScrollPaneEnums.VBarPos> vBarPosProperty() {
        return this.vBarPos;
    }

    public void setVBarPos(ScrollPaneEnums.VBarPos vBarPos) {
        this.vBarPos.set((Object)vBarPos);
    }

    public Insets getHBarPadding() {
        return (Insets)this.hBarPadding.get();
    }

    public StyleableObjectProperty<Insets> hBarPaddingProperty() {
        return this.hBarPadding;
    }

    public void setHBarPadding(Insets hBarPadding) {
        this.hBarPadding.set((Object)hBarPadding);
    }

    public Insets getVBarPadding() {
        return (Insets)this.vBarPadding.get();
    }

    public StyleableObjectProperty<Insets> vBarPaddingProperty() {
        return this.vBarPadding;
    }

    public void setVBarPadding(Insets vBarPadding) {
        this.vBarPadding.set((Object)vBarPadding);
    }

    public double getHBarOffset() {
        return this.hBarOffset.get();
    }

    public StyleableDoubleProperty hBarOffsetProperty() {
        return this.hBarOffset;
    }

    public void setHBarOffset(double hBarOffset) {
        this.hBarOffset.set(hBarOffset);
    }

    public double getVBarOffset() {
        return this.vBarOffset.get();
    }

    public StyleableDoubleProperty vBarOffsetProperty() {
        return this.vBarOffset;
    }

    public void setVBarOffset(double vBarOffset) {
        this.vBarOffset.set(vBarOffset);
    }

    public boolean isDragToScroll() {
        return this.dragToScroll.get();
    }

    public StyleableBooleanProperty dragToScrollProperty() {
        return this.dragToScroll;
    }

    public void setDragToScroll(boolean dragToScroll) {
        this.dragToScroll.set(dragToScroll);
    }

    public boolean isButtonsVisible() {
        return this.buttonsVisible.get();
    }

    public StyleableBooleanProperty buttonsVisibleProperty() {
        return this.buttonsVisible;
    }

    public void setButtonsVisible(boolean buttonsVisible) {
        this.buttonsVisible.set(buttonsVisible);
    }

    public double getButtonsGap() {
        return this.buttonsGap.get();
    }

    public StyleableDoubleProperty buttonsGapProperty() {
        return this.buttonsGap;
    }

    public void setButtonsGap(double buttonsGap) {
        this.buttonsGap.set(buttonsGap);
    }

    public double getHTrackIncrement() {
        return this.hTrackIncrement.get();
    }

    public StyleableDoubleProperty hTrackIncrementProperty() {
        return this.hTrackIncrement;
    }

    public void setHTrackIncrement(double hTrackIncrement) {
        this.hTrackIncrement.set(hTrackIncrement);
    }

    public double getHUnitIncrement() {
        return this.hUnitIncrement.get();
    }

    public StyleableDoubleProperty hUnitIncrementProperty() {
        return this.hUnitIncrement;
    }

    public void setHUnitIncrement(double hUnitIncrement) {
        this.hUnitIncrement.set(hUnitIncrement);
    }

    public double getVTrackIncrement() {
        return this.vTrackIncrement.get();
    }

    public StyleableDoubleProperty vTrackIncrementProperty() {
        return this.vTrackIncrement;
    }

    public void setVTrackIncrement(double trackIncrement) {
        this.vTrackIncrement.set(trackIncrement);
    }

    public double getVUnitIncrement() {
        return this.vUnitIncrement.get();
    }

    public StyleableDoubleProperty vUnitIncrementProperty() {
        return this.vUnitIncrement;
    }

    public void setVUnitIncrement(double unitIncrement) {
        this.vUnitIncrement.set(unitIncrement);
    }

    public boolean isSmoothScroll() {
        return this.smoothScroll.get();
    }

    public StyleableBooleanProperty smoothScrollProperty() {
        return this.smoothScroll;
    }

    public void setSmoothScroll(boolean smoothScroll) {
        this.smoothScroll.set(smoothScroll);
    }

    public boolean isTrackSmoothScroll() {
        return this.trackSmoothScroll.get();
    }

    public StyleableBooleanProperty trackSmoothScrollProperty() {
        return this.trackSmoothScroll;
    }

    public void setTrackSmoothScroll(boolean trackSmoothScroll) {
        this.trackSmoothScroll.set(trackSmoothScroll);
    }

    public double getClipBorderRadius() {
        return this.clipBorderRadius.get();
    }

    public StyleableDoubleProperty clipBorderRadiusProperty() {
        return this.clipBorderRadius;
    }

    public void setClipBorderRadius(double clipBorderRadius) {
        this.clipBorderRadius.set(clipBorderRadius);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.cssMetaDataList;
    }

    public Node getContent() {
        return (Node)this.content.get();
    }

    public ObjectProperty<Node> contentProperty() {
        return this.content;
    }

    public void setContent(Node content) {
        this.content.set((Object)content);
    }

    public VirtualBounds getContentBounds() {
        return (VirtualBounds)this.contentBounds.get();
    }

    public ObjectProperty<VirtualBounds> contentBoundsProperty() {
        return this.contentBounds;
    }

    public void setContentBounds(VirtualBounds contentBounds) {
        this.contentBounds.set((Object)contentBounds);
    }

    public double getHMin() {
        return this.hMin.get();
    }

    public DoubleProperty hMinProperty() {
        return this.hMin;
    }

    public void setHMin(double hMin) {
        this.hMin.set(hMin);
    }

    public double getHVal() {
        return this.hVal.get();
    }

    public DoubleProperty hValProperty() {
        return this.hVal;
    }

    public void setHVal(double hVal) {
        this.hVal.set(hVal);
    }

    public double getHMax() {
        return this.hMax.get();
    }

    public DoubleProperty hMaxProperty() {
        return this.hMax;
    }

    public void setHMax(double hMax) {
        this.hMax.set(hMax);
    }

    public double getVMin() {
        return this.vMin.get();
    }

    public DoubleProperty vMinProperty() {
        return this.vMin;
    }

    public void setVMin(double vMin) {
        this.vMin.set(vMin);
    }

    public double getVVal() {
        return this.vVal.get();
    }

    public DoubleProperty vValProperty() {
        return this.vVal;
    }

    public void setVVal(double vVal) {
        this.vVal.set(vVal);
    }

    public double getVMax() {
        return this.vMax.get();
    }

    public DoubleProperty vMaxProperty() {
        return this.vMax;
    }

    public void setVMax(double vMax) {
        this.vMax.set(vMax);
    }

    public Orientation getOrientation() {
        return (Orientation)this.orientation.get();
    }

    public ObjectProperty<Orientation> orientationProperty() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation.set((Object)orientation);
    }

    public Function<MFXScrollBar, MFXScrollBarBehavior> getHBarBehavior() {
        return (Function)this.hBarBehavior.get();
    }

    public FunctionProperty<MFXScrollBar, MFXScrollBarBehavior> hBarBehaviorProperty() {
        return this.hBarBehavior;
    }

    public void setHBarBehavior(Function<MFXScrollBar, MFXScrollBarBehavior> hBarBehavior) {
        this.hBarBehavior.set(hBarBehavior);
    }

    public Function<MFXScrollBar, MFXScrollBarBehavior> getVBarBehavior() {
        return (Function)this.vBarBehavior.get();
    }

    public FunctionProperty<MFXScrollBar, MFXScrollBarBehavior> vBarBehaviorProperty() {
        return this.vBarBehavior;
    }

    public void setVBarBehavior(Function<MFXScrollBar, MFXScrollBarBehavior> vBarBehavior) {
        this.vBarBehavior.set(vBarBehavior);
    }

    private static class StyleableProperties {
        private static final StyleablePropertyFactory<VirtualScrollPane> FACTORY = new StyleablePropertyFactory(Control.getClassCssMetaData());
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<VirtualScrollPane, ScrollPaneEnums.LayoutMode> LAYOUT_MODE;
        private static final CssMetaData<VirtualScrollPane, Boolean> AUTO_HIDE_BARS;
        private static final CssMetaData<VirtualScrollPane, ScrollPaneEnums.ScrollBarPolicy> HBAR_POLICY;
        private static final CssMetaData<VirtualScrollPane, ScrollPaneEnums.ScrollBarPolicy> VBAR_POLICY;
        private static final CssMetaData<VirtualScrollPane, ScrollPaneEnums.HBarPos> HBAR_POS;
        private static final CssMetaData<VirtualScrollPane, ScrollPaneEnums.VBarPos> VBAR_POS;
        private static final CssMetaData<VirtualScrollPane, Insets> HBAR_PADDING;
        private static final CssMetaData<VirtualScrollPane, Insets> VBAR_PADDING;
        private static final CssMetaData<VirtualScrollPane, Number> HBAR_OFFSET;
        private static final CssMetaData<VirtualScrollPane, Number> VBAR_OFFSET;
        private static final CssMetaData<VirtualScrollPane, Boolean> DRAG_TO_SCROLL;
        private static final CssMetaData<VirtualScrollPane, Boolean> BUTTONS_VISIBLE;
        private static final CssMetaData<VirtualScrollPane, Number> BUTTONS_GAP;
        private static final CssMetaData<VirtualScrollPane, Number> H_TRACK_INCREMENT;
        private static final CssMetaData<VirtualScrollPane, Number> H_UNIT_INCREMENT;
        private static final CssMetaData<VirtualScrollPane, Number> V_TRACK_INCREMENT;
        private static final CssMetaData<VirtualScrollPane, Number> V_UNIT_INCREMENT;
        private static final CssMetaData<VirtualScrollPane, Boolean> SMOOTH_SCROLL;
        private static final CssMetaData<VirtualScrollPane, Boolean> SMOOTH_SCROLL_ON_TRACK_PRESS;
        private static final CssMetaData<VirtualScrollPane, Number> CLIP_BORDER_RADIUS;

        private StyleableProperties() {
        }

        static {
            LAYOUT_MODE = FACTORY.createEnumCssMetaData(ScrollPaneEnums.LayoutMode.class, "-fx-layout-mode", VirtualScrollPane::layoutModeProperty, (Enum)ScrollPaneEnums.LayoutMode.DEFAULT);
            AUTO_HIDE_BARS = FACTORY.createBooleanCssMetaData("-fx-autohide-bars", VirtualScrollPane::autoHideBarsProperty, false);
            HBAR_POLICY = FACTORY.createEnumCssMetaData(ScrollPaneEnums.ScrollBarPolicy.class, "-fx-hbar-policy", VirtualScrollPane::hBarPolicyProperty, (Enum)ScrollPaneEnums.ScrollBarPolicy.DEFAULT);
            VBAR_POLICY = FACTORY.createEnumCssMetaData(ScrollPaneEnums.ScrollBarPolicy.class, "-fx-vbar-policy", VirtualScrollPane::vBarPolicyProperty, (Enum)ScrollPaneEnums.ScrollBarPolicy.DEFAULT);
            HBAR_POS = FACTORY.createEnumCssMetaData(ScrollPaneEnums.HBarPos.class, "-fx-hbar-pos", VirtualScrollPane::hBarPosProperty, (Enum)ScrollPaneEnums.HBarPos.BOTTOM);
            VBAR_POS = FACTORY.createEnumCssMetaData(ScrollPaneEnums.VBarPos.class, "-fx-vbar-pos", VirtualScrollPane::vBarPosProperty, (Enum)ScrollPaneEnums.VBarPos.RIGHT);
            HBAR_PADDING = FACTORY.createInsetsCssMetaData("-fx-hbar-padding", VirtualScrollPane::hBarPaddingProperty, Insets.EMPTY);
            VBAR_PADDING = FACTORY.createInsetsCssMetaData("-fx-vbar-padding", VirtualScrollPane::vBarPaddingProperty, Insets.EMPTY);
            HBAR_OFFSET = FACTORY.createSizeCssMetaData("-fx-hbar-offset", VirtualScrollPane::hBarOffsetProperty, (Number)0.0);
            VBAR_OFFSET = FACTORY.createSizeCssMetaData("-fx-vbar-offset", VirtualScrollPane::vBarOffsetProperty, (Number)0.0);
            DRAG_TO_SCROLL = FACTORY.createBooleanCssMetaData("-fx-drag-to-scroll", VirtualScrollPane::dragToScrollProperty, false);
            BUTTONS_VISIBLE = FACTORY.createBooleanCssMetaData("-fx-buttons-visible", VirtualScrollPane::buttonsVisibleProperty, false);
            BUTTONS_GAP = FACTORY.createSizeCssMetaData("-fx-buttons-gap", VirtualScrollPane::buttonsGapProperty, (Number)3.0);
            H_TRACK_INCREMENT = FACTORY.createSizeCssMetaData("-fx-htrack-increment", VirtualScrollPane::hTrackIncrementProperty, (Number)0.1);
            H_UNIT_INCREMENT = FACTORY.createSizeCssMetaData("-fx-hunit-increment", VirtualScrollPane::hUnitIncrementProperty, (Number)0.01);
            V_TRACK_INCREMENT = FACTORY.createSizeCssMetaData("-fx-vtrack-increment", VirtualScrollPane::vTrackIncrementProperty, (Number)0.1);
            V_UNIT_INCREMENT = FACTORY.createSizeCssMetaData("-fx-vunit-increment", VirtualScrollPane::vUnitIncrementProperty, (Number)0.01);
            SMOOTH_SCROLL = FACTORY.createBooleanCssMetaData("-fx-smooth-scroll", VirtualScrollPane::smoothScrollProperty, false);
            SMOOTH_SCROLL_ON_TRACK_PRESS = FACTORY.createBooleanCssMetaData("-fx-track-smooth-scroll", VirtualScrollPane::trackSmoothScrollProperty, false);
            CLIP_BORDER_RADIUS = FACTORY.createSizeCssMetaData("-fx-clip-border-radius", VirtualScrollPane::clipBorderRadiusProperty, (Number)0.0);
            cssMetaDataList = StyleUtils.cssMetaDataList((List)Control.getClassCssMetaData(), (CssMetaData[])new CssMetaData[]{LAYOUT_MODE, HBAR_POLICY, VBAR_POLICY, HBAR_POS, VBAR_POS, HBAR_PADDING, VBAR_PADDING, HBAR_OFFSET, VBAR_OFFSET, AUTO_HIDE_BARS, DRAG_TO_SCROLL, BUTTONS_VISIBLE, BUTTONS_GAP, H_TRACK_INCREMENT, H_UNIT_INCREMENT, V_TRACK_INCREMENT, V_UNIT_INCREMENT, SMOOTH_SCROLL, SMOOTH_SCROLL_ON_TRACK_PRESS, CLIP_BORDER_RADIUS});
        }
    }

    public static interface Wrappable {
        public VirtualScrollPane wrap();
    }
}

