/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.controls.behavior;

import io.github.palexdev.mfxcore.base.beans.range.DoubleRange;
import io.github.palexdev.mfxcore.utils.NumberUtils;
import io.github.palexdev.mfxcore.utils.fx.ScrollUtils;
import io.github.palexdev.mfxeffects.animations.Animations;
import io.github.palexdev.mfxeffects.animations.MomentumTransition;
import io.github.palexdev.mfxeffects.animations.base.Curve;
import io.github.palexdev.virtualizedfx.controls.MFXScrollBar;
import io.github.palexdev.virtualizedfx.controls.behavior.base.BehaviorBase;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.geometry.Orientation;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;

public class MFXScrollBarBehavior
extends BehaviorBase<MFXScrollBar> {
    private final ObjectProperty<ScrollUtils.ScrollDirection> direction = new SimpleObjectProperty();
    private Animation holdAnimation;
    private Animation scrollAnimation;
    private final Queue<Animation> smoothScrollAnimations = new ConcurrentLinkedQueue<Animation>();
    private double dragStart;

    public MFXScrollBarBehavior(MFXScrollBar sb) {
        super(sb);
    }

    public void scroll(ScrollEvent se) {
        MFXScrollBar sb = (MFXScrollBar)this.getNode();
        boolean isSmooth = sb.isSmoothScroll();
        double delta = this.getScrollDelta(se);
        if (delta == 0.0) {
            return;
        }
        int mul = delta > 0.0 ? -1 : 1;
        this.updateScrollDirection(mul);
        if (isSmooth) {
            this.smoothScroll(mul);
            return;
        }
        sb.setValue(sb.getValue() + sb.getUnitIncrement() * (double)mul);
    }

    public void thumbPressed(MouseEvent me) {
        this.stopAnimations();
        this.requestFocus();
        this.dragStart = this.getMousePos(me);
    }

    public void thumbDragged(MouseEvent me) {
        MFXScrollBar sb = (MFXScrollBar)this.getNode();
        double position = this.getMousePos(me);
        double delta = position - this.dragStart;
        int mul = delta < 0.0 ? -1 : 1;
        double deltaVal = this.posToVal(Math.abs(delta));
        this.updateScrollDirection(mul);
        this.setDragging(true);
        sb.setValue(sb.getValue() + deltaVal * (double)mul);
    }

    public void thumbReleased() {
        this.dragStart = 0.0;
        this.setDragging(false);
    }

    public void trackPressed(MouseEvent me) {
        this.stopAnimations();
        this.requestFocus();
        MFXScrollBar sb = (MFXScrollBar)this.getNode();
        if (sb.isSmoothScroll() && sb.isTrackSmoothScroll()) {
            return;
        }
        double position = this.getMousePos(me);
        boolean increment = this.isIncrementing(position);
        int mul = increment ? 1 : -1;
        this.updateScrollDirection(mul);
        double newVal = sb.getValue() + sb.getTrackIncrement() * (double)mul;
        Timeline firstTick = Animations.TimelineBuilder.build().add(new KeyFrame[]{Animations.KeyFrames.of((double)300.0, (WritableValue)sb.valueProperty(), (Object)newVal, (Interpolator)Curve.EASE_OUT)}).getAnimation();
        this.holdAnimation = Animations.PauseBuilder.build().setDuration(350.0).setOnFinished(event -> {
            boolean isMax;
            double thPos = this.getThumbPos() + (increment ? this.thumbLength() : 0.0);
            boolean incAndGreater = increment && thPos > position;
            boolean decAndLesser = !increment && thPos < position;
            boolean bl = isMax = sb.getValue() == sb.getMax();
            if (incAndGreater || decAndLesser || isMax) {
                return;
            }
            double target = increment ? this.posToVal(position - this.thumbLength()) : this.posToVal(position);
            double delta = Math.abs(target - sb.getValue());
            MomentumTransition mt = MomentumTransition.fromDeceleration((double)delta, (double)-1.5E-6);
            mt.setOnUpdate(upd -> {
                double val = sb.getValue() + upd * (double)mul;
                double clamped = increment ? Math.min(val, target) : Math.max(val, target);
                sb.setValue(clamped);
            });
            mt.setInterpolator(Curve.EASE_BOTH);
            this.scrollAnimation = mt;
            this.scrollAnimation.play();
        }).getAnimation();
        firstTick.play();
        this.holdAnimation.play();
    }

    public void trackReleased(MouseEvent me) {
        this.stopAnimations();
        MFXScrollBar sb = (MFXScrollBar)this.getNode();
        if (sb.isSmoothScroll() && sb.isTrackSmoothScroll()) {
            double position = this.getMousePos(me);
            boolean increment = this.isIncrementing(position);
            int mul = increment ? 1 : -1;
            this.updateScrollDirection(mul);
            double target = increment ? this.posToVal(position - this.thumbLength()) : this.posToVal(position);
            double delta = Math.abs(target - sb.getValue());
            MomentumTransition mt = MomentumTransition.fromDeceleration((double)delta, (double)-2.0E-6);
            mt.setOnUpdate(upd -> {
                double val = sb.getValue() + upd * (double)mul;
                double clamp = increment ? Math.min(val, target) : Math.max(val, target);
                sb.setValue(clamp);
            });
            mt.setInterpolator(Curve.EASE_BOTH);
            this.scrollAnimation = mt;
            this.scrollAnimation.play();
        }
    }

    public void decPressed() {
        this.stopAnimations();
        MFXScrollBar sb = (MFXScrollBar)this.getNode();
        double newVal = sb.getValue() - sb.getUnitIncrement();
        Timeline firstTick = Animations.TimelineBuilder.build().add(new KeyFrame[]{Animations.KeyFrames.of((double)50.0, (WritableValue)sb.valueProperty(), (Object)newVal, (Interpolator)Curve.EASE_BOTH)}).getAnimation();
        this.holdAnimation = Animations.PauseBuilder.build().setDuration(350.0).setOnFinished(event -> {
            double duration = sb.getValue() / (sb.getUnitIncrement() / 50.0);
            this.scrollAnimation = Animations.TimelineBuilder.build().add(new KeyFrame[]{Animations.KeyFrames.of((double)duration, (WritableValue)sb.valueProperty(), (Object)sb.getMin())}).getAnimation();
            this.scrollAnimation.play();
        }).getAnimation();
        this.updateScrollDirection(-1);
        firstTick.play();
        this.holdAnimation.play();
    }

    public void incPressed() {
        this.stopAnimations();
        MFXScrollBar sb = (MFXScrollBar)this.getNode();
        double newVal = NumberUtils.clamp((double)(sb.getValue() + sb.getUnitIncrement()), (double)sb.getMin(), (double)sb.getMax());
        Timeline firstTick = Animations.TimelineBuilder.build().add(new KeyFrame[]{Animations.KeyFrames.of((double)50.0, (WritableValue)sb.valueProperty(), (Object)newVal, (Interpolator)Curve.EASE_BOTH)}).getAnimation();
        this.holdAnimation = Animations.PauseBuilder.build().setDuration(350.0).setOnFinished(event -> {
            double duration = (sb.getMax() - sb.getValue()) / (sb.getUnitIncrement() / 50.0);
            this.scrollAnimation = Animations.TimelineBuilder.build().add(new KeyFrame[]{Animations.KeyFrames.of((double)duration, (WritableValue)sb.valueProperty(), (Object)sb.getMax())}).getAnimation();
            this.scrollAnimation.play();
        }).getAnimation();
        this.updateScrollDirection(1);
        firstTick.play();
        this.holdAnimation.play();
    }

    public void smoothScroll(int direction) {
        MFXScrollBar sb = (MFXScrollBar)this.getNode();
        double target = sb.getValue() + sb.getUnitIncrement() * (double)direction;
        double delta = Math.abs(sb.getValue() - target);
        MomentumTransition mt = MomentumTransition.fromTime((double)delta, (double)530.0);
        mt.setInterpolator(Curve.EASE_BOTH);
        mt.setOnUpdate(upd -> sb.setValue(sb.getValue() + upd * (double)direction));
        mt.setOnFinished(event -> this.smoothScrollAnimations.remove(mt));
        this.smoothScrollAnimations.add((Animation)mt);
        mt.play();
    }

    public void stopAnimations() {
        if (!this.smoothScrollAnimations.isEmpty()) {
            this.smoothScrollAnimations.forEach(Animation::stop);
            this.smoothScrollAnimations.clear();
        }
        if (this.holdAnimation != null) {
            this.holdAnimation.stop();
            this.holdAnimation = null;
        }
        if (this.scrollAnimation != null) {
            this.scrollAnimation.stop();
            this.scrollAnimation = null;
        }
    }

    protected void updateScrollDirection(int i) {
        Orientation o = ((MFXScrollBar)this.getNode()).getOrientation();
        ScrollUtils.ScrollDirection sd = o == Orientation.VERTICAL ? (i == 1 ? ScrollUtils.ScrollDirection.DOWN : ScrollUtils.ScrollDirection.UP) : (i == 1 ? ScrollUtils.ScrollDirection.RIGHT : ScrollUtils.ScrollDirection.LEFT);
        this.setDirection(sd);
    }

    protected void requestFocus() {
        MFXScrollBar sb = (MFXScrollBar)this.getNode();
        if (!sb.isFocused() && sb.isFocusTraversable()) {
            sb.requestFocus();
        }
    }

    protected double getScrollDelta(ScrollEvent se) {
        double delta;
        double d = delta = ((MFXScrollBar)this.getNode()).getOrientation() == Orientation.VERTICAL ? se.getDeltaY() : se.getDeltaX();
        return delta != 0.0 ? delta : (se.getDeltaY() != 0.0 ? se.getDeltaY() : se.getDeltaX());
    }

    protected double getMousePos(MouseEvent me) {
        return ((MFXScrollBar)this.getNode()).getOrientation() == Orientation.VERTICAL ? me.getY() : me.getX();
    }

    private double posToVal(double position) {
        MFXScrollBar sb = (MFXScrollBar)this.getNode();
        double maxPos = this.getTrackLength() - this.thumbLength();
        double clampedPos = NumberUtils.clamp((double)position, (double)0.0, (double)maxPos);
        return NumberUtils.mapOneRangeToAnother((double)clampedPos, (DoubleRange)DoubleRange.of((Double)0.0, (Double)maxPos), (DoubleRange)DoubleRange.of((Double)sb.getMin(), (Double)sb.getMax()));
    }

    private double thumbLength() {
        MFXScrollBar sb = (MFXScrollBar)this.getNode();
        return this.getTrackLength() * sb.getVisibleAmount();
    }

    private boolean isIncrementing(double position) {
        return position > this.getThumbPos();
    }

    @Override
    public void dispose() {
        this.smoothScrollAnimations.clear();
        super.dispose();
    }

    public ScrollUtils.ScrollDirection getDirection() {
        return (ScrollUtils.ScrollDirection)this.direction.get();
    }

    public ReadOnlyObjectProperty<ScrollUtils.ScrollDirection> directionProperty() {
        return this.direction;
    }

    protected void setDirection(ScrollUtils.ScrollDirection direction) {
        this.direction.set((Object)direction);
    }

    protected double getThumbPos() {
        return ((MFXScrollBar)this.getNode()).getThumbPos();
    }

    protected double getTrackLength() {
        return ((MFXScrollBar)this.getNode()).getTrackLength();
    }

    protected boolean isDragging() {
        return ((MFXScrollBar)this.getNode()).isDragging();
    }

    protected ReadOnlyBooleanProperty draggingProperty() {
        return ((MFXScrollBar)this.getNode()).draggingProperty();
    }

    protected void setDragging(boolean dragging) {
        ((BooleanProperty)this.draggingProperty()).set(dragging);
    }
}

