/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.controls.behavior.actions;

import io.github.palexdev.virtualizedfx.controls.behavior.base.DisposableAction;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;

public class EventAction<E extends Event>
implements DisposableAction {
    private Node node;
    private EventType<E> eventType;
    private EventHandler<E> handler;
    protected boolean isFilter = false;

    public EventAction(Node node, EventType<E> eventType, EventHandler<E> handler) {
        this.node = node;
        this.eventType = eventType;
        this.handler = handler;
    }

    public EventAction(Node node, EventType<E> eventType, EventHandler<E> handler, boolean isFilter) {
        this.node = node;
        this.eventType = eventType;
        this.handler = handler;
        this.isFilter = isFilter;
    }

    public static <E extends Event> EventAction<E> handler(Node node, EventType<E> et, EventHandler<E> handler) {
        EventAction<E> ea = new EventAction<E>(node, et, handler);
        node.addEventHandler(et, handler);
        return ea;
    }

    public static <E extends Event> EventAction<E> filter(Node node, EventType<E> et, EventHandler<E> handler) {
        EventAction<E> ea = new EventAction<E>(node, et, handler, true);
        node.addEventFilter(et, handler);
        return ea;
    }

    @Override
    public void dispose() {
        if (this.isFilter) {
            this.node.removeEventFilter(this.eventType, this.handler);
        } else {
            this.node.removeEventHandler(this.eventType, this.handler);
        }
        this.eventType = null;
        this.handler = null;
        this.node = null;
    }

    public Node getNode() {
        return this.node;
    }

    public EventType<E> getEventType() {
        return this.eventType;
    }

    public EventHandler<E> getHandler() {
        return this.handler;
    }

    public boolean isFilter() {
        return this.isFilter;
    }
}

