/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.controls.behavior.base;

import io.github.palexdev.virtualizedfx.controls.behavior.actions.ChangeAction;
import io.github.palexdev.virtualizedfx.controls.behavior.actions.EventAction;
import io.github.palexdev.virtualizedfx.controls.behavior.actions.InvalidationAction;
import io.github.palexdev.virtualizedfx.controls.behavior.base.DisposableAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;

public abstract class BehaviorBase<N extends Node> {
    private N node;
    private final List<DisposableAction> actions = new ArrayList<DisposableAction>();

    public BehaviorBase(N node) {
        this.node = node;
    }

    public <E extends Event> void handler(Node node, EventType<E> eventType, EventHandler<E> handler) {
        this.actions.add(EventAction.handler(node, eventType, handler));
    }

    public <E extends Event> void filter(Node node, EventType<E> eventType, EventHandler<E> handler) {
        this.actions.add(EventAction.filter(node, eventType, handler));
    }

    public <T> void register(ObservableValue<T> observable, ChangeListener<T> listener) {
        this.actions.add(ChangeAction.of(observable, listener));
    }

    public <T> void register(ObservableValue<T> observable, InvalidationListener listener) {
        this.actions.add(InvalidationAction.of(observable, listener));
    }

    public void dispose() {
        this.actions.forEach(DisposableAction::dispose);
        this.actions.clear();
        this.node = null;
    }

    public N getNode() {
        return this.node;
    }

    public List<DisposableAction> getActions() {
        return Collections.unmodifiableList(this.actions);
    }
}

