/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.controls.skins;

import io.github.palexdev.mfxcore.base.beans.Position;
import io.github.palexdev.mfxcore.base.beans.range.DoubleRange;
import io.github.palexdev.mfxcore.builders.bindings.BooleanBindingBuilder;
import io.github.palexdev.mfxcore.builders.bindings.DoubleBindingBuilder;
import io.github.palexdev.mfxcore.observables.When;
import io.github.palexdev.mfxcore.utils.NumberUtils;
import io.github.palexdev.mfxcore.utils.fx.LayoutUtils;
import io.github.palexdev.mfxresources.builders.IconBuilder;
import io.github.palexdev.mfxresources.builders.IconWrapperBuilder;
import io.github.palexdev.mfxresources.fonts.MFXIconWrapper;
import io.github.palexdev.virtualizedfx.controls.MFXScrollBar;
import io.github.palexdev.virtualizedfx.controls.behavior.MFXScrollBarBehavior;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Region;

public class MFXScrollBarSkin
extends SkinBase<MFXScrollBar> {
    private final Region track;
    private final Region thumb;
    private final MFXIconWrapper decIcon;
    private final MFXIconWrapper incIcon;
    private final double DEFAULT_LENGTH = 100.0;
    private double trackLength;
    private double thumbLength;
    private DoubleBinding thumbPos;
    private boolean vamAdjust = false;
    private boolean barPressed = false;
    private static final PseudoClass VERTICAL_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"vertical");
    private static final PseudoClass HORIZONTAL_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"horizontal");
    private static final PseudoClass FOCUS_WITHIN_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"focus-within");
    protected final List<When<?>> whens = new ArrayList();

    public MFXScrollBarSkin(MFXScrollBar scrollBar) {
        super((Control)scrollBar);
        this.track = new Region();
        this.track.getStyleClass().add((Object)"track");
        this.thumb = new Region();
        this.thumb.getStyleClass().add((Object)"thumb");
        this.decIcon = IconWrapperBuilder.build().setIcon(IconBuilder.build().get()).enableRippleGenerator(true).addStyleClasses(new String[]{"decrement-icon"}).get();
        this.incIcon = IconWrapperBuilder.build().setIcon(IconBuilder.build().get()).enableRippleGenerator(true).addStyleClasses(new String[]{"increment-icon"}).get();
        this.thumbPos = (DoubleBinding)DoubleBindingBuilder.build().setMapper(() -> this.valToPos(scrollBar.getValue())).addSources(new Observable[]{scrollBar.valueProperty()}).addSources(new Observable[]{this.thumb.widthProperty(), this.thumb.heightProperty()}).get();
        this.onOrientationChange();
        this.updateChildren();
        scrollBar.setValue(scrollBar.getValue());
        this.addListeners();
        this.initBehavior();
    }

    private void addListeners() {
        MFXScrollBar sb = (MFXScrollBar)this.getSkinnable();
        InvalidationListener reLayout = invalidated -> {
            if (this.vamAdjust) {
                this.vamAdjust = false;
                return;
            }
            sb.requestLayout();
        };
        sb.minProperty().addListener(reLayout);
        sb.maxProperty().addListener(reLayout);
        sb.visibleAmountProperty().addListener(reLayout);
        sb.buttonsGapProperty().addListener(reLayout);
        ((DoubleProperty)sb.thumbPosProperty()).bind((ObservableValue)this.thumbPos);
        ((DoubleProperty)sb.trackLengthProperty()).bind((ObservableValue)DoubleBindingBuilder.build().setMapper(() -> sb.getOrientation() == Orientation.VERTICAL ? this.track.getHeight() : this.track.getWidth()).addSources(new Observable[]{this.track.widthProperty(), this.track.heightProperty()}).addSources(new Observable[]{sb.orientationProperty()}).get());
        sb.visibleProperty().bind((ObservableValue)BooleanBindingBuilder.build().setMapper(() -> sb.getVisibleAmount() < 1.0).addSources(new Observable[]{sb.visibleAmountProperty()}).get());
        Collections.addAll(this.whens, When.onInvalidated((ObservableValue)sb.buttonsVisibleProperty()).then(v -> {
            this.updateChildren();
            this.thumbPos.invalidate();
            sb.requestLayout();
        }).listen(), When.onInvalidated(sb.orientationProperty()).then(v -> {
            this.onOrientationChange();
            sb.requestLayout();
        }).listen(), When.onInvalidated(sb.behaviorProperty()).then(v -> this.initBehavior()).listen(), When.onChanged((ObservableValue)this.decIcon.focusedProperty()).then((o, n) -> this.pseudoClassStateChanged(FOCUS_WITHIN_PSEUDO_CLASS, (boolean)n)).listen(), When.onChanged((ObservableValue)this.incIcon.focusedProperty()).then((o, n) -> this.pseudoClassStateChanged(FOCUS_WITHIN_PSEUDO_CLASS, (boolean)n)).listen());
        When.onChanged((ObservableValue)this.track.layoutBoundsProperty()).condition((oldValue, newValue) -> newValue.getWidth() > 0.0 && newValue.getHeight() > 0.0).then((oldValue, newValue) -> this.thumbPos.invalidate()).oneShot().listen();
    }

    private void initBehavior() {
        MFXScrollBar sb = (MFXScrollBar)this.getSkinnable();
        MFXScrollBarBehavior behavior = sb.getBehavior();
        if (behavior == null) {
            return;
        }
        behavior.handler((Node)sb, ScrollEvent.SCROLL, behavior::scroll);
        behavior.handler((Node)sb, MouseEvent.MOUSE_PRESSED, me -> {
            if (me.getPickResult().getIntersectedNode() == sb) {
                this.barPressed = true;
                Point2D toTrack = this.track.parentToLocal(me.getX(), me.getY());
                MouseEvent nme = new MouseEvent(null, (EventTarget)this.track, MouseEvent.MOUSE_PRESSED, toTrack.getX(), toTrack.getY(), 0.0, 0.0, MouseButton.PRIMARY, 1, false, false, false, false, true, false, false, false, false, false, null);
                Event.fireEvent((EventTarget)this.track, (Event)nme);
                me.consume();
            }
        });
        behavior.handler((Node)sb, MouseEvent.MOUSE_RELEASED, me -> {
            if (this.barPressed) {
                behavior.trackReleased((MouseEvent)me);
                this.barPressed = false;
            }
        });
        behavior.handler((Node)this.thumb, MouseEvent.MOUSE_PRESSED, behavior::thumbPressed);
        behavior.handler((Node)this.thumb, MouseEvent.MOUSE_DRAGGED, behavior::thumbDragged);
        behavior.handler((Node)this.thumb, MouseEvent.MOUSE_RELEASED, me -> behavior.thumbReleased());
        behavior.handler((Node)this.track, MouseEvent.MOUSE_PRESSED, behavior::trackPressed);
        behavior.handler((Node)this.track, MouseEvent.MOUSE_RELEASED, behavior::trackReleased);
        behavior.handler((Node)this.decIcon, MouseEvent.MOUSE_PRESSED, me -> {
            this.decIcon.requestFocus();
            behavior.decPressed();
        });
        behavior.handler((Node)this.decIcon, MouseEvent.MOUSE_RELEASED, me -> behavior.stopAnimations());
        behavior.handler((Node)this.incIcon, MouseEvent.MOUSE_PRESSED, me -> {
            this.incIcon.requestFocus();
            behavior.incPressed();
        });
        behavior.handler((Node)this.incIcon, MouseEvent.MOUSE_RELEASED, me -> behavior.stopAnimations());
    }

    private void updateChildren() {
        MFXScrollBar sb = (MFXScrollBar)this.getSkinnable();
        boolean buttonsVisible = sb.isButtonsVisible();
        if (buttonsVisible) {
            this.getChildren().setAll((Object[])new Node[]{this.track, this.thumb, this.decIcon, this.incIcon});
        } else {
            this.getChildren().setAll((Object[])new Node[]{this.track, this.thumb});
        }
    }

    private void onOrientationChange() {
        MFXScrollBar sb = (MFXScrollBar)this.getSkinnable();
        Orientation o = sb.getOrientation();
        if (o == Orientation.VERTICAL) {
            this.pseudoClassStateChanged(HORIZONTAL_PSEUDO_CLASS, false);
            this.pseudoClassStateChanged(VERTICAL_PSEUDO_CLASS, true);
            this.thumb.translateXProperty().unbind();
            this.thumb.translateYProperty().bind((ObservableValue)this.thumbPos);
        } else {
            this.pseudoClassStateChanged(VERTICAL_PSEUDO_CLASS, false);
            this.pseudoClassStateChanged(HORIZONTAL_PSEUDO_CLASS, true);
            this.thumb.translateYProperty().unbind();
            this.thumb.translateXProperty().bind((ObservableValue)this.thumbPos);
        }
    }

    private double valToPos(double val) {
        MFXScrollBar sb = (MFXScrollBar)this.getSkinnable();
        double min = sb.getMin();
        double max = sb.getMax();
        assert (val >= min && val <= max);
        return NumberUtils.mapOneRangeToAnother((double)val, (DoubleRange)DoubleRange.of((Double)min, (Double)max), (DoubleRange)DoubleRange.of((Double)0.0, (Double)(this.trackLength - this.thumbLength)));
    }

    private double getLength(Orientation orientation) {
        double length;
        double padding;
        MFXScrollBar sb = (MFXScrollBar)this.getSkinnable();
        if (orientation == Orientation.VERTICAL) {
            padding = this.snappedLeftInset() + this.snappedRightInset();
            length = LayoutUtils.boundWidth((Node)this.thumb) + padding;
        } else {
            padding = this.snappedTopInset() + this.snappedBottomInset();
            length = LayoutUtils.boundHeight((Node)this.thumb) + padding;
        }
        if (sb.isButtonsVisible()) {
            length = Math.max(length, Math.max(this.decIcon.getSize(), this.incIcon.getSize()) + padding);
        }
        return length;
    }

    private double minTrackLength(Orientation orientation) {
        return this.getLength(orientation) * 2.0;
    }

    private double minThumbLength(Orientation orientation) {
        return this.getLength(orientation) * 1.5;
    }

    private double visiblePortion() {
        MFXScrollBar sb = (MFXScrollBar)this.getSkinnable();
        return sb.getVisibleAmount() / (sb.getMax() - sb.getMin());
    }

    private DoubleProperty visibleAmountProperty() {
        return (DoubleProperty)((MFXScrollBar)this.getSkinnable()).visibleAmountProperty();
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        MFXScrollBar sb = (MFXScrollBar)this.getSkinnable();
        Orientation o = sb.getOrientation();
        boolean buttonsVisible = sb.isButtonsVisible();
        double buttonsGap = buttonsVisible ? sb.getButtonsGap() : 0.0;
        return o == Orientation.VERTICAL ? this.getLength(Orientation.VERTICAL) : leftInset + this.decIcon.getSize() + this.minTrackLength(Orientation.HORIZONTAL) + this.incIcon.getSize() + rightInset + buttonsGap * 2.0;
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        MFXScrollBar sb = (MFXScrollBar)this.getSkinnable();
        Orientation o = sb.getOrientation();
        boolean buttonsVisible = sb.isButtonsVisible();
        double buttonsGap = buttonsVisible ? sb.getButtonsGap() : 0.0;
        return o == Orientation.VERTICAL ? topInset + this.decIcon.getSize() + this.minTrackLength(Orientation.VERTICAL) + this.incIcon.getSize() + bottomInset + buttonsGap * 2.0 : this.getLength(Orientation.HORIZONTAL);
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        MFXScrollBar sb = (MFXScrollBar)this.getSkinnable();
        Orientation o = sb.getOrientation();
        boolean buttonsVisible = sb.isButtonsVisible();
        double buttonsGap = buttonsVisible ? sb.getButtonsGap() : 0.0;
        return o == Orientation.VERTICAL ? this.getLength(Orientation.VERTICAL) : leftInset + 100.0 + rightInset + buttonsGap * 2.0;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        MFXScrollBar sb = (MFXScrollBar)this.getSkinnable();
        Orientation o = sb.getOrientation();
        boolean buttonsVisible = sb.isButtonsVisible();
        double buttonsGap = buttonsVisible ? sb.getButtonsGap() : 0.0;
        return o == Orientation.VERTICAL ? topInset + 100.0 + bottomInset + buttonsGap * 2.0 : this.getLength(Orientation.HORIZONTAL);
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        MFXScrollBar scrollBar = (MFXScrollBar)this.getSkinnable();
        return scrollBar.getOrientation() == Orientation.VERTICAL ? scrollBar.prefWidth(-1.0) : Double.MAX_VALUE;
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        MFXScrollBar scrollBar = (MFXScrollBar)this.getSkinnable();
        return scrollBar.getOrientation() == Orientation.VERTICAL ? Double.MAX_VALUE : scrollBar.prefHeight(-1.0);
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        double incSize;
        MFXScrollBar sb = (MFXScrollBar)this.getSkinnable();
        Orientation o = sb.getOrientation();
        boolean buttonsVisible = sb.isButtonsVisible();
        double buttonsGap = buttonsVisible ? sb.getButtonsGap() : 0.0;
        double decSize = buttonsVisible ? this.decIcon.getSize() + buttonsGap : 0.0;
        double d = incSize = buttonsVisible ? this.incIcon.getSize() + buttonsGap : 0.0;
        if (buttonsVisible) {
            HPos decHPos = o == Orientation.VERTICAL ? HPos.CENTER : HPos.LEFT;
            HPos incHPos = o == Orientation.VERTICAL ? HPos.CENTER : HPos.RIGHT;
            VPos decVPos = o == Orientation.VERTICAL ? VPos.TOP : VPos.CENTER;
            VPos incVPos = o == Orientation.VERTICAL ? VPos.BOTTOM : VPos.CENTER;
            this.layoutInArea((Node)this.decIcon, x, y, w, h, 0.0, decHPos, decVPos);
            this.layoutInArea((Node)this.incIcon, x, y, w, h, 0.0, incHPos, incVPos);
        }
        double visiblePortion = this.visiblePortion();
        if (o == Orientation.VERTICAL) {
            this.trackLength = this.snapSizeY(h - (decSize + incSize));
            this.layoutInArea((Node)this.track, x, y + decSize, w, this.trackLength, 0.0, HPos.CENTER, VPos.TOP);
            this.thumbLength = this.snapSizeY(NumberUtils.clamp((double)(this.trackLength * visiblePortion), (double)this.minThumbLength(Orientation.VERTICAL), (double)this.trackLength));
            double visibleAmount = this.thumbLength * (sb.getMax() - sb.getMin()) / this.trackLength;
            if (sb.getVisibleAmount() != visibleAmount && !this.visibleAmountProperty().isBound()) {
                this.vamAdjust = true;
                this.visibleAmountProperty().set(visibleAmount);
            }
            Position position = LayoutUtils.computePosition((Region)sb, (Node)this.thumb, (double)x, (double)(y + decSize), (double)w, (double)this.thumbLength, (double)0.0, (Insets)Insets.EMPTY, (HPos)HPos.CENTER, (VPos)VPos.TOP, (boolean)false, (boolean)true);
            double thumbW = LayoutUtils.boundWidth((Node)this.thumb);
            this.thumb.resizeRelocate(position.getX(), position.getY(), thumbW, this.thumbLength);
        } else {
            this.trackLength = this.snapSizeX(w - (decSize + incSize));
            this.layoutInArea((Node)this.track, x + decSize, y, this.trackLength, h, 0.0, HPos.LEFT, VPos.CENTER);
            this.thumbLength = this.snapSizeX(NumberUtils.clamp((double)(this.trackLength * visiblePortion), (double)this.minThumbLength(Orientation.HORIZONTAL), (double)this.trackLength));
            double visibleAmount = this.thumbLength * (sb.getMax() - sb.getMin()) / this.trackLength;
            if (sb.getVisibleAmount() != visibleAmount && !this.visibleAmountProperty().isBound()) {
                this.vamAdjust = true;
                this.visibleAmountProperty().set(visibleAmount);
            }
            Position position = LayoutUtils.computePosition((Region)sb, (Node)this.thumb, (double)(x + decSize), (double)y, (double)this.thumbLength, (double)h, (double)0.0, (Insets)Insets.EMPTY, (HPos)HPos.LEFT, (VPos)VPos.CENTER, (boolean)false, (boolean)true);
            double thumbH = LayoutUtils.boundWidth((Node)this.thumb);
            this.thumb.resizeRelocate(position.getX(), position.getY(), this.thumbLength, thumbH);
        }
    }

    public void dispose() {
        MFXScrollBarBehavior behavior = ((MFXScrollBar)this.getSkinnable()).getBehavior();
        if (behavior != null) {
            behavior.dispose();
        }
        this.thumb.translateXProperty().unbind();
        this.thumb.translateYProperty().unbind();
        this.thumbPos = null;
        this.whens.forEach(w -> w.dispose());
        super.dispose();
    }
}

