/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.controls.skins;

import io.github.palexdev.mfxcore.base.beans.Position;
import io.github.palexdev.mfxcore.base.beans.range.DoubleRange;
import io.github.palexdev.mfxcore.builders.bindings.BooleanBindingBuilder;
import io.github.palexdev.mfxcore.builders.bindings.DoubleBindingBuilder;
import io.github.palexdev.mfxcore.builders.bindings.ObjectBindingBuilder;
import io.github.palexdev.mfxcore.observables.When;
import io.github.palexdev.mfxcore.utils.NumberUtils;
import io.github.palexdev.mfxcore.utils.fx.LayoutUtils;
import io.github.palexdev.mfxcore.utils.fx.NodeUtils;
import io.github.palexdev.mfxeffects.animations.Animations;
import io.github.palexdev.virtualizedfx.controls.MFXScrollBar;
import io.github.palexdev.virtualizedfx.controls.VirtualScrollPane;
import io.github.palexdev.virtualizedfx.enums.ScrollPaneEnums;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;

public class VirtualScrollPaneSkin
extends SkinBase<VirtualScrollPane> {
    private final Pane container;
    private final Rectangle clip;
    private final MFXScrollBar vBar;
    private final MFXScrollBar hBar;
    private final double DEFAULT_SIZE = 100.0;
    private Node content;
    private Position initValues = Position.of((double)0.0, (double)0.0);
    private Position dragStart = Position.of((double)-1.0, (double)-1.0);
    private static final PseudoClass COMPACT_MODE_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"compact");
    private static final PseudoClass DRAG_TO_SCROLL_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"drag-to-scroll");
    private final double duration = 250.0;
    private Animation hShow;
    private Animation hHide;
    private Animation vShow;
    private Animation vHide;

    public VirtualScrollPaneSkin(VirtualScrollPane scrollPane) {
        super((Control)scrollPane);
        this.content = scrollPane.getContent();
        this.container = new Pane(){

            protected void layoutChildren() {
                if (VirtualScrollPaneSkin.this.content != null) {
                    VirtualScrollPaneSkin.this.content.resizeRelocate(0.0, 0.0, this.getWidth(), this.getHeight());
                }
            }
        };
        this.container.getStyleClass().add((Object)"container");
        if (this.content != null) {
            this.container.getChildren().add((Object)this.content);
        }
        this.clip = new Rectangle();
        this.clip.widthProperty().bind((ObservableValue)this.container.widthProperty());
        this.clip.heightProperty().bind((ObservableValue)this.container.heightProperty());
        this.clip.arcWidthProperty().bind((ObservableValue)scrollPane.clipBorderRadiusProperty());
        this.clip.arcHeightProperty().bind((ObservableValue)scrollPane.clipBorderRadiusProperty());
        this.container.setClip((Node)this.clip);
        this.hBar = new MFXScrollBar(Orientation.HORIZONTAL);
        this.hBar.behaviorProperty().bind((ObservableValue)ObjectBindingBuilder.build().setMapper(() -> scrollPane.getHBarBehavior().apply(this.hBar)).addSources(new Observable[]{scrollPane.hBarBehaviorProperty()}).get());
        this.vBar = new MFXScrollBar(Orientation.VERTICAL);
        this.vBar.behaviorProperty().bind((ObservableValue)ObjectBindingBuilder.build().setMapper(() -> scrollPane.getVBarBehavior().apply(this.vBar)).addSources(new Observable[]{scrollPane.vBarBehaviorProperty()}).get());
        if (scrollPane.isAutoHideBars()) {
            this.hBar.setOpacity(0.0);
            this.vBar.setOpacity(0.0);
        }
        this.pseudoClassStateChanged(COMPACT_MODE_PSEUDO_CLASS, scrollPane.getLayoutMode() == ScrollPaneEnums.LayoutMode.COMPACT);
        this.pseudoClassStateChanged(DRAG_TO_SCROLL_PSEUDO_CLASS, scrollPane.isDragToScroll());
        this.hShow = Animations.TimelineBuilder.build().add(new KeyFrame[]{Animations.KeyFrames.of((double)250.0, (WritableValue)this.hBar.opacityProperty(), (Object)1.0)}).setOnFinished(event -> {
            if (this.hBar.isHover() || this.hBar.isPressed()) {
                return;
            }
            this.hHide.playFromStart();
        }).getAnimation();
        this.hHide = Animations.TimelineBuilder.build().setDelay(600.0).add(new KeyFrame[]{Animations.KeyFrames.of((double)250.0, (WritableValue)this.hBar.opacityProperty(), (Object)0.0)}).getAnimation();
        this.vShow = Animations.TimelineBuilder.build().add(new KeyFrame[]{Animations.KeyFrames.of((double)250.0, (WritableValue)this.vBar.opacityProperty(), (Object)1.0)}).setOnFinished(event -> {
            if (this.vBar.isHover() || this.vBar.isPressed()) {
                return;
            }
            this.vHide.playFromStart();
        }).getAnimation();
        this.vHide = Animations.TimelineBuilder.build().setDelay(600.0).add(new KeyFrame[]{Animations.KeyFrames.of((double)250.0, (WritableValue)this.vBar.opacityProperty(), (Object)0.0)}).getAnimation();
        this.bindings();
        this.addListeners();
        this.getChildren().setAll((Object[])new Node[]{this.container, this.vBar, this.hBar});
    }

    private void bindings() {
        VirtualScrollPane sp = (VirtualScrollPane)this.getSkinnable();
        this.hBarVisibleAmountProperty().bind((ObservableValue)DoubleBindingBuilder.build().setMapper(() -> sp.getWidth() / sp.getContentBounds().getVirtualWidth()).addSources(new Observable[]{sp.widthProperty(), sp.contentBoundsProperty()}).get());
        this.hBar.visibleProperty().bind((ObservableValue)BooleanBindingBuilder.build().setMapper(() -> this.hBar.getVisibleAmount() < 1.0 && sp.getHBarPolicy() != ScrollPaneEnums.ScrollBarPolicy.NEVER).addSources(new Observable[]{this.hBar.visibleAmountProperty(), sp.hBarPolicyProperty()}).get());
        sp.hMinProperty().bindBidirectional((Property)this.hBar.minProperty());
        sp.hValProperty().bindBidirectional((Property)this.hBar.valueProperty());
        sp.hMaxProperty().bindBidirectional((Property)this.hBar.maxProperty());
        this.hBar.buttonsGapProperty().bind((ObservableValue)sp.buttonsGapProperty());
        this.hBar.trackIncrementProperty().bind((ObservableValue)sp.hTrackIncrementProperty());
        this.hBar.unitIncrementProperty().bind((ObservableValue)sp.hUnitIncrementProperty());
        this.hBar.smoothScrollProperty().bind((ObservableValue)sp.smoothScrollProperty());
        this.hBar.trackSmoothScrollProperty().bind((ObservableValue)sp.trackSmoothScrollProperty());
        this.vBarVisibleAmountProperty().bind((ObservableValue)DoubleBindingBuilder.build().setMapper(() -> sp.getHeight() / sp.getContentBounds().getVirtualHeight()).addSources(new Observable[]{sp.heightProperty(), sp.contentBoundsProperty()}).get());
        this.vBar.visibleProperty().bind((ObservableValue)BooleanBindingBuilder.build().setMapper(() -> this.vBar.getVisibleAmount() < 1.0 && sp.getVBarPolicy() != ScrollPaneEnums.ScrollBarPolicy.NEVER).addSources(new Observable[]{this.vBar.visibleAmountProperty(), sp.vBarPolicyProperty()}).get());
        sp.vMinProperty().bindBidirectional((Property)this.vBar.minProperty());
        sp.vValProperty().bindBidirectional((Property)this.vBar.valueProperty());
        sp.vMaxProperty().bindBidirectional((Property)this.vBar.maxProperty());
        this.vBar.buttonsVisibleProperty().bind((ObservableValue)sp.buttonsVisibleProperty());
        this.vBar.buttonsGapProperty().bind((ObservableValue)sp.buttonsGapProperty());
        this.vBar.trackIncrementProperty().bind((ObservableValue)sp.vTrackIncrementProperty());
        this.vBar.unitIncrementProperty().bind((ObservableValue)sp.vUnitIncrementProperty());
        this.vBar.smoothScrollProperty().bind((ObservableValue)sp.smoothScrollProperty());
        this.vBar.trackSmoothScrollProperty().bind((ObservableValue)sp.trackSmoothScrollProperty());
    }

    private void addListeners() {
        VirtualScrollPane sp = (VirtualScrollPane)this.getSkinnable();
        InvalidationListener reLayout = invalidated -> sp.requestLayout();
        sp.contentProperty().addListener((observable, oldValue, newValue) -> {
            if (this.content != null) {
                this.content = null;
                this.container.getChildren().clear();
            }
            if (newValue != null) {
                this.content = newValue;
                this.container.getChildren().setAll((Object[])new Node[]{this.content});
            }
        });
        sp.contentBoundsProperty().addListener((observable, oldValue, newValue) -> {
            if (!sp.isAutoHideBars()) {
                return;
            }
            if (oldValue.getVirtualWidth() != newValue.getVirtualHeight()) {
                this.hShow.playFromStart();
            }
            if (oldValue.getVirtualHeight() != newValue.getVirtualHeight()) {
                this.vShow.playFromStart();
            }
        });
        sp.layoutModeProperty().addListener((observable, oldValue, newValue) -> {
            this.pseudoClassStateChanged(COMPACT_MODE_PSEUDO_CLASS, newValue == ScrollPaneEnums.LayoutMode.COMPACT);
            sp.requestLayout();
        });
        sp.hBarPolicyProperty().addListener(reLayout);
        sp.vBarPolicyProperty().addListener(reLayout);
        sp.vBarPosProperty().addListener(reLayout);
        sp.hBarPosProperty().addListener(reLayout);
        sp.vBarPaddingProperty().addListener(reLayout);
        sp.hBarPaddingProperty().addListener(reLayout);
        sp.dragToScrollProperty().addListener((observable, oldValue, newValue) -> this.pseudoClassStateChanged(DRAG_TO_SCROLL_PSEUDO_CLASS, (boolean)newValue));
        sp.autoHideBarsProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                if (!this.hBar.isHover() && !this.hBar.isPressed()) {
                    this.hHide.playFromStart();
                }
                if (!this.vBar.isHover() && !this.vBar.isPressed()) {
                    this.vHide.playFromStart();
                }
            } else {
                this.hBar.setOpacity(1.0);
                this.vBar.setOpacity(1.0);
            }
        });
        this.hBar.valueProperty().addListener(invalidated -> {
            if (!sp.isAutoHideBars()) {
                return;
            }
            this.hHide.stop();
            this.hShow.play();
        });
        this.hBar.hoverProperty().addListener((observable, oldValue, newValue) -> {
            if (!sp.isAutoHideBars()) {
                return;
            }
            if (!newValue.booleanValue() && this.hBar.isPressed()) {
                When.onChanged((ObservableValue)this.hBar.pressedProperty()).then((ov, nv) -> {
                    if (!nv.booleanValue()) {
                        this.hHide.playFromStart();
                    }
                }).oneShot().listen();
                return;
            }
            if (newValue.booleanValue()) {
                this.hHide.stop();
                this.hShow.playFromStart();
            } else if (!Animations.isPlaying((Animation)this.hShow)) {
                this.hHide.playFromStart();
            }
        });
        this.vBar.valueProperty().addListener(invalidated -> {
            if (!sp.isAutoHideBars()) {
                return;
            }
            this.vHide.stop();
            this.vShow.play();
        });
        this.vBar.hoverProperty().addListener((observable, oldValue, newValue) -> {
            if (!sp.isAutoHideBars()) {
                return;
            }
            if (!newValue.booleanValue() && this.vBar.isPressed()) {
                When.onChanged((ObservableValue)this.vBar.pressedProperty()).then((ov, nv) -> {
                    if (!nv.booleanValue()) {
                        this.vHide.playFromStart();
                    }
                }).oneShot().listen();
                return;
            }
            if (newValue.booleanValue()) {
                this.vHide.stop();
                this.vShow.playFromStart();
            } else if (!Animations.isPlaying((Animation)this.vShow)) {
                this.vHide.playFromStart();
            }
        });
        this.container.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
            if (this.vBar.isDragging() || this.hBar.isDragging()) {
                return;
            }
            if (!sp.isDragToScroll()) {
                this.dragStart = Position.of((double)-1.0, (double)-1.0);
                this.initValues = Position.of((double)0.0, (double)0.0);
                return;
            }
            this.dragStart = Position.of((double)event.getX(), (double)event.getY());
            this.initValues = Position.of((double)this.hBar.getValue(), (double)this.vBar.getValue());
        });
        this.container.addEventHandler(MouseEvent.MOUSE_DRAGGED, event -> {
            if (this.dragStart.getX() == -1.0 || this.dragStart.getY() == -1.0) {
                return;
            }
            if (this.hBar.isVisible()) {
                double xDelta = -(event.getX() - this.dragStart.getX());
                double xvDelta = this.posToVal(this.hBar.getTrackLength(), this.hBar.getVisibleAmount(), xDelta, this.hBar.getMin(), this.hBar.getMax());
                this.hBar.setValue(this.initValues.getX() + xvDelta);
            }
            if (this.vBar.isVisible()) {
                double yDelta = -(event.getY() - this.dragStart.getY());
                double yvDelta = this.posToVal(this.vBar.getTrackLength(), this.vBar.getVisibleAmount(), yDelta, this.vBar.getMin(), this.vBar.getMax());
                this.vBar.setValue(this.initValues.getY() + yvDelta);
            }
        });
        sp.addEventHandler(ScrollEvent.SCROLL, event -> {
            MFXScrollBar target;
            if (NodeUtils.inHierarchy((Node)event.getPickResult().getIntersectedNode(), (Node)this.vBar) || NodeUtils.inHierarchy((Node)event.getPickResult().getIntersectedNode(), (Node)this.hBar)) {
                event.consume();
                return;
            }
            Orientation orientation = sp.getOrientation();
            switch (orientation) {
                case VERTICAL: {
                    target = event.isShiftDown() ? this.hBar : this.vBar;
                    break;
                }
                case HORIZONTAL: {
                    target = event.isShiftDown() ? this.vBar : this.hBar;
                    break;
                }
                default: {
                    target = this.vBar;
                }
            }
            if (target.isVisible()) {
                this.reRouteScrollEvent((Node)target, (ScrollEvent)event);
            }
        });
    }

    private double posToVal(double trackLength, double visibleAmount, double pos, double vMin, double vMax) {
        double maxPos = trackLength - trackLength * visibleAmount;
        return NumberUtils.mapOneRangeToAnother((double)pos, (DoubleRange)DoubleRange.of((Double)0.0, (Double)maxPos), (DoubleRange)DoubleRange.of((Double)vMin, (Double)vMax));
    }

    private void reRouteScrollEvent(Node target, ScrollEvent se) {
        Event.fireEvent((EventTarget)target, (Event)new ScrollEvent(null, (EventTarget)target, ScrollEvent.SCROLL, 0.0, 0.0, 0.0, 0.0, false, false, false, false, false, false, se.getDeltaX(), se.getDeltaY(), 0.0, 0.0, ScrollEvent.HorizontalTextScrollUnits.NONE, 0.0, ScrollEvent.VerticalTextScrollUnits.NONE, 0.0, 0, null));
    }

    private DoubleProperty hBarVisibleAmountProperty() {
        return (DoubleProperty)this.hBar.visibleAmountProperty();
    }

    private DoubleProperty vBarVisibleAmountProperty() {
        return (DoubleProperty)this.vBar.visibleAmountProperty();
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return leftInset + 100.0 + LayoutUtils.boundWidth((Node)this.vBar) + rightInset;
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + 100.0 + LayoutUtils.boundHeight((Node)this.hBar) + bottomInset;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        VirtualScrollPane sp = (VirtualScrollPane)this.getSkinnable();
        Node content = sp.getContent();
        ScrollPaneEnums.LayoutMode layoutMode = sp.getLayoutMode();
        ScrollPaneEnums.ScrollBarPolicy vBarPolicy = sp.getVBarPolicy();
        double contentW = content != null ? content.prefWidth(-1.0) : 0.0;
        double prefW = leftInset + contentW + rightInset;
        if (layoutMode == ScrollPaneEnums.LayoutMode.DEFAULT && vBarPolicy != ScrollPaneEnums.ScrollBarPolicy.NEVER) {
            prefW += LayoutUtils.boundWidth((Node)this.vBar);
        }
        return prefW;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        VirtualScrollPane sp = (VirtualScrollPane)this.getSkinnable();
        Node content = sp.getContent();
        ScrollPaneEnums.LayoutMode layoutMode = sp.getLayoutMode();
        ScrollPaneEnums.ScrollBarPolicy hBarPolicy = sp.getHBarPolicy();
        double contentH = content != null ? content.prefHeight(-1.0) : 0.0;
        double prefH = topInset + contentH + bottomInset;
        if (layoutMode == ScrollPaneEnums.LayoutMode.DEFAULT && hBarPolicy != ScrollPaneEnums.ScrollBarPolicy.NEVER) {
            prefH += LayoutUtils.boundHeight((Node)this.hBar);
        }
        return prefH;
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        double hBarY;
        VirtualScrollPane sp = (VirtualScrollPane)this.getSkinnable();
        ScrollPaneEnums.LayoutMode layoutMode = sp.getLayoutMode();
        HPos vBarPos = sp.getVBarPos().toHPos();
        VPos hBarPos = sp.getHBarPos().toVPos();
        ScrollPaneEnums.ScrollBarPolicy vBarPolicy = sp.getVBarPolicy();
        ScrollPaneEnums.ScrollBarPolicy hBarPolicy = sp.getHBarPolicy();
        double vBarOffset = sp.getVBarOffset();
        Insets vBarPadding = sp.getVBarPadding();
        double hPadding = this.snappedLeftInset() + this.snappedRightInset();
        double hBarOffset = sp.getHBarOffset();
        Insets hBarPadding = sp.getHBarPadding();
        double vPadding = this.snappedTopInset() + this.snappedBottomInset();
        double totalWidth = w + hPadding;
        double totalHeight = h + vPadding;
        double vBarW = LayoutUtils.boundWidth((Node)this.vBar);
        double vBarH = totalHeight - vBarPadding.getBottom() - vBarPadding.getTop() - vBarOffset;
        double vBarX = vBarPos == HPos.LEFT ? vBarPadding.getLeft() : totalWidth - vBarW - vBarPadding.getRight();
        double vBarY = vBarPadding.getTop() + vBarOffset;
        double hBarW = totalWidth - hBarPadding.getLeft() - hBarPadding.getRight() - hBarOffset;
        double hBarH = LayoutUtils.boundHeight((Node)this.hBar);
        double hBarX = hBarPadding.getLeft() + hBarOffset;
        double d = hBarY = hBarPos == VPos.TOP ? hBarPadding.getTop() : totalHeight - hBarH - hBarPadding.getBottom();
        if (layoutMode != ScrollPaneEnums.LayoutMode.COMPACT || hBarPolicy != ScrollPaneEnums.ScrollBarPolicy.NEVER && !this.hBar.isVisible()) {
            vBarH -= hBarH;
        }
        if (layoutMode != ScrollPaneEnums.LayoutMode.COMPACT || vBarPolicy != ScrollPaneEnums.ScrollBarPolicy.NEVER && !this.vBar.isVisible()) {
            hBarW -= vBarW;
        }
        this.vBar.resizeRelocate(vBarX, vBarY, vBarW, vBarH);
        this.hBar.resizeRelocate(hBarX, hBarY, hBarW, hBarH);
        double viewW = layoutMode == ScrollPaneEnums.LayoutMode.DEFAULT && vBarPolicy != ScrollPaneEnums.ScrollBarPolicy.NEVER ? w - vBarW : w;
        double viewH = layoutMode == ScrollPaneEnums.LayoutMode.DEFAULT && hBarPolicy != ScrollPaneEnums.ScrollBarPolicy.NEVER ? h - hBarH : h;
        this.container.resizeRelocate(this.snappedLeftInset(), this.snappedTopInset(), viewW, viewH);
    }

    public void dispose() {
        this.vShow.stop();
        this.hShow.stop();
        this.vHide.stop();
        this.hHide.stop();
        this.vShow = null;
        this.hShow = null;
        this.vHide = null;
        this.hHide = null;
        this.content = null;
        super.dispose();
    }
}

